/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.wizards;

import com.objfac.xmleditor.Config;
import com.objfac.xmleditor.actions.OkDialog;
import com.objfac.xmleditor.actions.VersionAction;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class WizardAction
implements IWorkbenchWindowActionDelegate {
    private boolean fPro;
    private IWorkbenchWindow fWindow;
    private IStructuredSelection fSelection;

    public WizardAction(boolean bl) {
        this.fPro = bl;
    }

    public void dispose() {
        this.fWindow = null;
        this.fSelection = null;
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.fWindow = iWorkbenchWindow;
    }

    public void run(IAction iAction) {
        if (this.fSelection == null) {
            return;
        }
        if (this.fPro && !Config.pro()) {
            OkDialog okDialog = new OkDialog("License Reminder", "Sorry, this feature requires a PRO license.");
            okDialog.open();
            VersionAction.promptForLicense();
            return;
        }
        INewWizard iNewWizard = this.createWizard();
        iNewWizard.init(this.fWindow.getWorkbench(), this.fSelection);
        WizardDialog wizardDialog = new WizardDialog(this.fWindow.getShell(), (IWizard)iNewWizard);
        wizardDialog.create();
        wizardDialog.open();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.fSelection = this.getStructuredSelection(iSelection);
        iAction.setEnabled(this.fSelection != null);
    }

    protected IStructuredSelection getStructuredSelection(ISelection iSelection) {
        IStructuredSelection iStructuredSelection = null;
        if (iSelection instanceof IStructuredSelection) {
            iStructuredSelection = (IStructuredSelection)iSelection;
        } else {
            IEditorInput iEditorInput;
            IEditorPart iEditorPart = this.fWindow.getActivePage().getActiveEditor();
            if (iEditorPart != null && (iEditorInput = iEditorPart.getEditorInput()) instanceof IFileEditorInput) {
                LinkedList<IFile> linkedList = new LinkedList<IFile>();
                linkedList.add(((IFileEditorInput)iEditorInput).getFile());
                iStructuredSelection = new StructuredSelection(linkedList);
            }
        }
        return iStructuredSelection;
    }

    protected abstract INewWizard createWizard();

    protected abstract String getText();
}

