/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.xpath;

import com.objfac.util.Local;
import com.objfac.util.Misc;
import com.objfac.xml.XMLCharacter;
import com.objfac.xml.schema.impl.ExternalEntity;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.partition.scanner.XMLParser;
import com.objfac.xmleditor.resources.PluginFactoryExtension;
import com.objfac.xmleditor.search.SearchUtils;
import com.objfac.xmleditor.xmltree.XMLTree;
import com.objfac.xmleditor.xpath.TreeMapEntry;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class DocumentFinder {
    private XMLParser parser = new XMLParser();
    private IEditorPart[] editors;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TreeMapEntry findDocument(IFile iFile, MultiStatus multiStatus) {
        String string;
        XMLTree xMLTree = null;
        ITextEditor iTextEditor = this.findEditorFor(iFile);
        if (iTextEditor != null) {
            if (iTextEditor instanceof XMLEditor) {
                XMLEditor xMLEditor = (XMLEditor)iTextEditor;
                xMLTree = xMLEditor.getXMLTree();
                string = xMLEditor.getUrl();
                return new TreeMapEntry(xMLTree, string);
            } else {
                String string2 = iTextEditor.getDocumentProvider().getDocument((Object)iTextEditor.getEditorInput()).get();
                char[] cArray = string2.toCharArray();
                if (!this.canBeXML(cArray)) {
                    return null;
                }
                xMLTree = this.parser.parse(cArray);
                if (xMLTree.getRoot() == null) {
                    return null;
                }
                IEditorInput iEditorInput = iTextEditor.getEditorInput();
                if (!(iEditorInput instanceof IPathEditorInput)) return null;
                IPath iPath = ((IPathEditorInput)iEditorInput).getPath();
                String string3 = iPath.toOSString();
                string = Misc.absPathToUrl((String)string3);
            }
            return new TreeMapEntry(xMLTree, string);
        } else {
            IPath iPath = iFile.getLocation();
            String string4 = iPath.toOSString();
            string = Misc.absPathToUrl((String)string4);
            xMLTree = this.parseTree(string, multiStatus);
            if (xMLTree != null) return new TreeMapEntry(xMLTree, string);
            return null;
        }
    }

    public TreeMapEntry findDocument(String string, String string2) {
        Object object;
        TreeMapEntry treeMapEntry = null;
        boolean bl = false;
        if (string.startsWith("file:")) {
            object = Misc.fileUrlToPath((String)string);
            Path path = new Path((String)object);
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            if (iFile != null && iFile.exists()) {
                treeMapEntry = this.findDocument(iFile, null);
                bl = true;
            }
        }
        if (!bl && (object = this.parseTree(string = Misc.getAbsUrl((String)string2, (String)string), null)) != null) {
            treeMapEntry = new TreeMapEntry((XMLTree)object, string);
        }
        return treeMapEntry;
    }

    private XMLTree parseTree(String string, MultiStatus multiStatus) {
        XMLTree xMLTree;
        block3: {
            xMLTree = null;
            ExternalEntity externalEntity = new ExternalEntity(null, null, string, PluginFactoryExtension.getFactory());
            try {
                char[] cArray = externalEntity.getContents();
                if (this.canBeXML(cArray) && (xMLTree = this.parser.parse(cArray)).getRoot() == null) {
                    xMLTree = null;
                }
            }
            catch (IOException iOException) {
                if (multiStatus == null) break block3;
                multiStatus.add((IStatus)new Status(4, XMLPlugin.getPluginId(), 0, Local.format((String)"Can''t read file {0}", (Object)string), (Throwable)iOException));
            }
        }
        return xMLTree;
    }

    private boolean canBeXML(char[] cArray) {
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n && XMLCharacter.isWhitespace((char)cArray[n2])) {
            ++n2;
        }
        return n2 < n && cArray[n2] == '<';
    }

    private ITextEditor findEditorFor(IFile iFile) {
        if (this.editors == null) {
            this.editors = SearchUtils.getActiveEditors();
        }
        int n = 0;
        IPath iPath = iFile.getLocation();
        while (n < this.editors.length) {
            IEditorPart iEditorPart = this.editors[n];
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput instanceof IPathEditorInput && iEditorPart instanceof ITextEditor && ((IPathEditorInput)iEditorInput).getPath().equals((Object)iPath)) {
                return (ITextEditor)iEditorPart;
            }
            ++n;
        }
        return null;
    }
}

