/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moved;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension3;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;

public class DefaultUndoManager
implements IUndoManager {
    private StringBuffer fTextBuffer = new StringBuffer();
    private StringBuffer fPreservedTextBuffer = new StringBuffer();
    private PretendedUndoManagerState fPretendedState = new PretendedUndoManagerState();
    private ITextListener fTextListener;
    private KeyAndMouseListener fKeyAndMouseListener;
    private boolean fInserting = false;
    private boolean fDeleting = false;
    private boolean fOverwriting = false;
    private boolean fFoldingIntoCompoundChange = false;
    private ITextViewer fTextViewer;
    private int fUndoLevel;
    private List fCommandStack;
    private TextCommand fCurrent;
    private TextCommand fPreviousDelete;
    private int fCommandCounter = -1;

    public DefaultUndoManager(int n) {
        this.setMaximalUndoLevel(n);
    }

    public void beginCompoundChange() {
        this.fFoldingIntoCompoundChange = true;
        this.commit();
    }

    public void convertToCompoundChange() {
        if (!this.fFoldingIntoCompoundChange) {
            this.fFoldingIntoCompoundChange = true;
            CompoundTextCommand compoundTextCommand = new CompoundTextCommand();
            compoundTextCommand.add(this.fCurrent);
            this.fCurrent = compoundTextCommand;
        }
    }

    public void endCompoundChange() {
        this.fFoldingIntoCompoundChange = false;
        this.commit();
    }

    private void addListeners() {
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText != null) {
            this.fKeyAndMouseListener = new KeyAndMouseListener();
            styledText.addMouseListener((MouseListener)this.fKeyAndMouseListener);
            styledText.addKeyListener((KeyListener)this.fKeyAndMouseListener);
            this.listenToTextChanges(true);
        }
    }

    private void removeListeners() {
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText != null && this.fKeyAndMouseListener != null) {
            styledText.removeMouseListener((MouseListener)this.fKeyAndMouseListener);
            styledText.removeKeyListener((KeyListener)this.fKeyAndMouseListener);
            this.listenToTextChanges(false);
        }
    }

    private void listenToTextChanges(boolean bl) {
        if (bl && this.fTextListener == null) {
            this.fTextListener = new TextListener();
            this.fTextViewer.addTextListener(this.fTextListener);
        } else if (!bl && this.fTextListener != null) {
            this.fTextViewer.removeTextListener(this.fTextListener);
            this.fTextListener = null;
        }
    }

    private void commit() {
        this.fInserting = false;
        this.fDeleting = false;
        this.fOverwriting = false;
        this.fPreviousDelete.reinitialize();
        this.fCurrent.commit();
    }

    private void internalRedo() {
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText != null) {
            ++this.fCommandCounter;
            TextCommand textCommand = (TextCommand)this.fCommandStack.get(this.fCommandCounter);
            this.listenToTextChanges(false);
            textCommand.redo(styledText);
            this.listenToTextChanges(true);
            this.fCurrent = new TextCommand();
        }
    }

    private void internalUndo() {
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText != null) {
            TextCommand textCommand = (TextCommand)this.fCommandStack.get(this.fCommandCounter);
            --this.fCommandCounter;
            this.listenToTextChanges(false);
            textCommand.undo(styledText);
            this.listenToTextChanges(true);
            this.fCurrent = new TextCommand();
        }
    }

    private boolean isWhitespaceText(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        String[] stringArray = this.fTextViewer.getDocument().getLegalLineDelimiters();
        int n = TextUtilities.startsWith((String[])stringArray, (String)string);
        if (n > -1) {
            int n2 = string.length();
            int n3 = stringArray[n].length();
            while (n3 < n2) {
                char c = string.charAt(n3);
                if (c != ' ' && c != '\t') {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    private PretendedUndoManagerState pretendCommit() {
        if (this.fCurrent.fStart < 0) {
            this.fPretendedState.stackSize = this.fCommandStack.size();
            this.fPretendedState.cmdCounter = this.fCommandCounter;
        } else {
            int n = Math.max(this.fCommandCounter, 0) + 1;
            if (n > this.fUndoLevel) {
                n -= this.fUndoLevel;
            }
            this.fPretendedState.stackSize = n;
            this.fPretendedState.cmdCounter = n - 1;
        }
        return this.fPretendedState;
    }

    private void processTextEvent(TextEvent textEvent) {
        int n = textEvent.getOffset();
        int n2 = textEvent.getOffset() + textEvent.getLength();
        String string = textEvent.getText();
        String string2 = textEvent.getReplacedText();
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        int n3 = string.length();
        int n4 = n2 - n;
        if (n4 < 0) {
            int n5 = n2;
            n2 = n;
            n = n5;
            n4 = -n4;
        }
        if (n == n2) {
            if (n3 == 1 || this.isWhitespaceText(string)) {
                if (!this.fInserting || n != this.fCurrent.fStart + this.fTextBuffer.length()) {
                    this.commit();
                    this.fInserting = true;
                }
                if (this.fCurrent.fStart < 0) {
                    this.fCurrent.fStart = this.fCurrent.fEnd = n;
                }
                if (n3 > 0) {
                    this.fTextBuffer.append(string);
                }
            } else if (n3 > 0) {
                this.commit();
                this.fCurrent.fStart = this.fCurrent.fEnd = n;
                this.fTextBuffer.append(string);
                this.commit();
            }
        } else if (n3 == 0) {
            n3 = string2.length();
            String[] stringArray = this.fTextViewer.getDocument().getLegalLineDelimiters();
            if (n3 == 1 || TextUtilities.equals((String[])stringArray, (String)string2) > -1) {
                if (this.fPreviousDelete.fStart == n && this.fPreviousDelete.fEnd == n2) {
                    if (this.fCurrent.fStart == n2 && this.fCurrent.fEnd == n) {
                        this.fCurrent.fStart = n;
                        this.fCurrent.fEnd = n2;
                    }
                    this.fPreservedTextBuffer.append(string2);
                    ++this.fCurrent.fEnd;
                } else if (this.fPreviousDelete.fStart == n2) {
                    this.fPreservedTextBuffer.insert(0, string2);
                    this.fCurrent.fStart = n;
                } else {
                    this.commit();
                    this.fDeleting = true;
                    this.fPreservedTextBuffer.append(string2);
                    this.fCurrent.fStart = n;
                    this.fCurrent.fEnd = n2;
                }
                this.fPreviousDelete.set(n, n2);
            } else if (n3 > 0) {
                this.commit();
                this.fCurrent.fStart = n;
                this.fCurrent.fEnd = n2;
                this.fPreservedTextBuffer.append(string2);
            }
        } else {
            if (n3 == 1) {
                n3 = string2.length();
                String[] stringArray = this.fTextViewer.getDocument().getLegalLineDelimiters();
                if (n3 == 1 || TextUtilities.equals((String[])stringArray, (String)string2) > -1) {
                    if (!this.fOverwriting || n != this.fCurrent.fStart + this.fTextBuffer.length()) {
                        this.commit();
                        this.fOverwriting = true;
                    }
                    if (this.fCurrent.fStart < 0) {
                        this.fCurrent.fStart = n;
                    }
                    this.fCurrent.fEnd = n2;
                    this.fTextBuffer.append(string);
                    this.fPreservedTextBuffer.append(string2);
                    return;
                }
            }
            this.commit();
            this.fCurrent.fStart = n;
            this.fCurrent.fEnd = n2;
            this.fTextBuffer.append(string);
            this.fPreservedTextBuffer.append(string2);
        }
    }

    public void setMaximalUndoLevel(int n) {
        this.fUndoLevel = n;
    }

    public void connect(ITextViewer iTextViewer) {
        if (this.fTextViewer == null) {
            this.fTextViewer = iTextViewer;
            this.fCommandStack = new ArrayList();
            this.fCurrent = new TextCommand();
            this.fPreviousDelete = new TextCommand();
            this.addListeners();
        }
    }

    public void disconnect() {
        if (this.fTextViewer != null) {
            this.removeListeners();
            this.fCurrent = null;
            if (this.fCommandStack != null) {
                this.fCommandStack.clear();
                this.fCommandStack = null;
            }
            this.fTextBuffer = null;
            this.fPreservedTextBuffer = null;
            this.fTextViewer = null;
        }
    }

    public void reset() {
        if (this.fCommandStack != null) {
            this.fCommandStack.clear();
        }
        this.fCommandCounter = -1;
        if (this.fCurrent != null) {
            this.fCurrent.reinitialize();
        }
        this.fFoldingIntoCompoundChange = false;
        this.fInserting = false;
        this.fDeleting = false;
        this.fOverwriting = false;
        this.fTextBuffer.setLength(0);
        this.fPreservedTextBuffer.setLength(0);
    }

    public boolean redoable() {
        if (this.fCommandStack != null) {
            PretendedUndoManagerState pretendedUndoManagerState = this.pretendCommit();
            return pretendedUndoManagerState.cmdCounter + 1 >= 0 && pretendedUndoManagerState.cmdCounter + 1 < pretendedUndoManagerState.stackSize;
        }
        return false;
    }

    public boolean undoable() {
        if (this.fCommandStack != null) {
            PretendedUndoManagerState pretendedUndoManagerState = this.pretendCommit();
            return pretendedUndoManagerState.cmdCounter >= 0 && pretendedUndoManagerState.cmdCounter < pretendedUndoManagerState.stackSize;
        }
        return false;
    }

    public void redo() {
        if (this.redoable()) {
            this.commit();
            this.internalRedo();
        }
    }

    public void undo() {
        if (this.undoable()) {
            this.fFoldingIntoCompoundChange = false;
            this.commit();
            this.internalUndo();
        }
    }

    class TextCommand {
        protected int fStart = -1;
        protected int fEnd = -1;
        protected String fText;
        protected String fPreservedText;

        TextCommand() {
        }

        protected void reinitialize() {
            this.fEnd = -1;
            this.fStart = -1;
            this.fPreservedText = null;
            this.fText = null;
        }

        protected void set(int n, int n2) {
            this.fStart = n;
            this.fEnd = n2;
            this.fText = null;
            this.fPreservedText = null;
        }

        protected void undoTextChange(StyledText styledText) {
            styledText.replaceTextRange(this.fStart, this.fText.length(), this.fPreservedText);
        }

        protected void undo(StyledText styledText) {
            this.undoTextChange(styledText);
            IRegion iRegion = this.widgetRange2ModelRange(this.fStart, this.fPreservedText == null ? 0 : this.fPreservedText.length());
            DefaultUndoManager.this.fTextViewer.setSelectedRange(iRegion.getOffset(), iRegion.getLength());
            DefaultUndoManager.this.fTextViewer.revealRange(iRegion.getOffset(), iRegion.getLength());
        }

        protected void redoTextChange(StyledText styledText) {
            styledText.replaceTextRange(this.fStart, this.fEnd - this.fStart, this.fText);
        }

        protected void redo(StyledText styledText) {
            this.redoTextChange(styledText);
            IRegion iRegion = this.widgetRange2ModelRange(this.fStart, this.fText == null ? 0 : this.fText.length());
            DefaultUndoManager.this.fTextViewer.setSelectedRange(iRegion.getOffset(), iRegion.getLength());
            DefaultUndoManager.this.fTextViewer.revealRange(iRegion.getOffset(), iRegion.getLength());
        }

        protected IRegion widgetRange2ModelRange(int n, int n2) {
            if (DefaultUndoManager.this.fTextViewer instanceof ITextViewerExtension3) {
                ITextViewerExtension3 iTextViewerExtension3 = (ITextViewerExtension3)DefaultUndoManager.this.fTextViewer;
                return iTextViewerExtension3.widgetRange2ModelRange((IRegion)new Region(n, n2));
            }
            IRegion iRegion = DefaultUndoManager.this.fTextViewer.getVisibleRegion();
            return new Region(n + iRegion.getOffset(), n2);
        }

        protected void updateCommandStack() {
            int n = DefaultUndoManager.this.fCommandStack.size();
            int n2 = DefaultUndoManager.this.fCommandCounter + 1;
            while (n2 < n) {
                DefaultUndoManager.this.fCommandStack.remove(DefaultUndoManager.this.fCommandCounter + 1);
                ++n2;
            }
            DefaultUndoManager.this.fCommandStack.add(this);
            while (DefaultUndoManager.this.fCommandStack.size() > DefaultUndoManager.this.fUndoLevel) {
                DefaultUndoManager.this.fCommandStack.remove(0);
            }
            DefaultUndoManager.this.fCommandCounter = DefaultUndoManager.this.fCommandStack.size() - 1;
        }

        protected TextCommand createCurrent() {
            return DefaultUndoManager.this.fFoldingIntoCompoundChange ? new CompoundTextCommand() : new TextCommand();
        }

        protected void commit() {
            if (this.fStart < 0) {
                this.reinitialize();
            } else {
                this.fText = DefaultUndoManager.this.fTextBuffer.toString();
                DefaultUndoManager.this.fTextBuffer.setLength(0);
                this.fPreservedText = DefaultUndoManager.this.fPreservedTextBuffer.toString();
                DefaultUndoManager.this.fPreservedTextBuffer.setLength(0);
                this.updateCommandStack();
            }
            DefaultUndoManager.this.fCurrent = this.createCurrent();
        }
    }

    class CompoundTextCommand
    extends TextCommand {
        private List fCommands = new ArrayList();

        CompoundTextCommand() {
        }

        protected void add(TextCommand textCommand) {
            this.fCommands.add(textCommand);
        }

        /*
         * Exception decompiling
         */
        protected void undo(StyledText var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 136->140)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        protected void redo(StyledText var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 139->143)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected void updateCommandStack() {
            TextCommand textCommand = new TextCommand();
            textCommand.fStart = this.fStart;
            textCommand.fEnd = this.fEnd;
            textCommand.fText = this.fText;
            textCommand.fPreservedText = this.fPreservedText;
            this.add(textCommand);
            if (!DefaultUndoManager.this.fFoldingIntoCompoundChange) {
                super.updateCommandStack();
            }
        }

        protected TextCommand createCurrent() {
            if (!DefaultUndoManager.this.fFoldingIntoCompoundChange) {
                return new TextCommand();
            }
            this.reinitialize();
            return this;
        }

        protected void commit() {
            if (this.fStart < 0 && this.fCommands.size() > 0 && !DefaultUndoManager.this.fFoldingIntoCompoundChange) {
                super.updateCommandStack();
                DefaultUndoManager.this.fCurrent = this.createCurrent();
                return;
            }
            super.commit();
        }
    }

    class PretendedUndoManagerState {
        protected int cmdCounter = -1;
        protected int stackSize = -1;

        PretendedUndoManagerState() {
        }
    }

    class KeyAndMouseListener
    implements MouseListener,
    KeyListener {
        KeyAndMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            if (mouseEvent.button == 1) {
                DefaultUndoManager.this.commit();
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: {
                    DefaultUndoManager.this.commit();
                }
            }
        }
    }

    class TextListener
    implements ITextListener {
        TextListener() {
        }

        public void textChanged(TextEvent textEvent) {
            if (textEvent.getDocumentEvent() != null) {
                DefaultUndoManager.this.processTextEvent(textEvent);
            }
        }
    }
}

