/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class ExpressionNormalizer {
    protected Expression additionalExpression;
    protected SQLSelectStatement statement;
    protected Vector subSelectExpressions;
    protected AbstractSession session;

    public ExpressionNormalizer(SQLSelectStatement statement) {
        this.statement = statement;
    }

    public void addAdditionalExpression(Expression theExpression) {
        this.additionalExpression = this.additionalExpression == null ? theExpression : this.additionalExpression.and(theExpression);
    }

    public void addSubSelectExpression(SubSelectExpression subSelectExpression) {
        if (this.subSelectExpressions == null) {
            this.subSelectExpressions = new Vector(1);
        }
        this.subSelectExpressions.add(subSelectExpression);
    }

    public Expression getAdditionalExpression() {
        return this.additionalExpression;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public SQLSelectStatement getStatement() {
        return this.statement;
    }

    public boolean encounteredSubSelectExpressions() {
        return this.subSelectExpressions != null;
    }

    public void normalizeSubSelects(Map clonedExpressions) {
        Enumeration enumtr = this.subSelectExpressions.elements();
        while (enumtr.hasMoreElements()) {
            SubSelectExpression next = (SubSelectExpression)enumtr.nextElement();
            next.normalizeSubSelect(this, clonedExpressions);
        }
    }

    public void setAdditionalExpression(Expression additionalExpression) {
        this.additionalExpression = additionalExpression;
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }

    public void setStatement(SQLSelectStatement statement) {
        this.statement = statement;
    }
}

