/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen;

import java.util.Iterator;
import java.util.LinkedList;
import org.jaxen.JaxenException;
import org.jaxen.expr.DefaultXPathFactory;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.FunctionCallExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.Predicated;
import org.jaxen.expr.Step;
import org.jaxen.expr.XPathExpr;
import org.jaxen.expr.XPathFactory;
import org.saxpath.XPathHandler;

public class JaxenHandler
implements XPathHandler {
    private XPathFactory xpathFactory;
    private XPathExpr xpath;
    protected boolean simplified;
    protected LinkedList stack = new LinkedList();

    public JaxenHandler() {
        this.xpathFactory = new DefaultXPathFactory();
    }

    public void setXPathFactory(XPathFactory xPathFactory) {
        this.xpathFactory = xPathFactory;
    }

    public XPathFactory getXPathFactory() {
        return this.xpathFactory;
    }

    public XPathExpr getXPathExpr() {
        return this.getXPathExpr(true);
    }

    public XPathExpr getXPathExpr(boolean bl) {
        if (bl && !this.simplified) {
            this.xpath.simplify();
            this.simplified = true;
        }
        return this.xpath;
    }

    public void startXPath() throws JaxenException {
        this.simplified = false;
        this.pushFrame();
    }

    public void endXPath() throws JaxenException {
        this.xpath = this.getXPathFactory().createXPath((Expr)this.pop());
        this.popFrame();
    }

    public void startPathExpr() throws JaxenException {
        this.pushFrame();
    }

    public void endPathExpr() throws JaxenException {
        FilterExpr filterExpr;
        LocationPath locationPath;
        if (this.stackSize() == 2) {
            locationPath = (LocationPath)this.pop();
            filterExpr = (FilterExpr)this.pop();
        } else {
            Object object = this.pop();
            if (object instanceof LocationPath) {
                locationPath = (LocationPath)object;
                filterExpr = null;
            } else {
                locationPath = null;
                filterExpr = (FilterExpr)object;
            }
        }
        this.popFrame();
        this.push(this.getXPathFactory().createPathExpr(filterExpr, locationPath));
    }

    public void startAbsoluteLocationPath() throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createAbsoluteLocationPath());
    }

    public void endAbsoluteLocationPath() throws JaxenException {
        this.endLocationPath();
    }

    public void startRelativeLocationPath() throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createRelativeLocationPath());
    }

    public void endRelativeLocationPath() throws JaxenException {
        this.endLocationPath();
    }

    protected void endLocationPath() throws JaxenException {
        LocationPath locationPath = (LocationPath)this.peekFrame().removeFirst();
        this.addSteps(locationPath, this.popFrame().iterator());
        this.push(locationPath);
    }

    protected void addSteps(LocationPath locationPath, Iterator iterator) {
        while (iterator.hasNext()) {
            locationPath.addStep((Step)iterator.next());
        }
    }

    public void startNameStep(int n, String string, String string2) throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createNameStep(n, string, string2));
    }

    public void endNameStep() throws JaxenException {
        this.endStep();
    }

    public void startTextNodeStep(int n) throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createTextNodeStep(n));
    }

    public void endTextNodeStep() throws JaxenException {
        this.endStep();
    }

    public void startCommentNodeStep(int n) throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createCommentNodeStep(n));
    }

    public void endCommentNodeStep() throws JaxenException {
        this.endStep();
    }

    public void startAllNodeStep(int n) throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createAllNodeStep(n));
    }

    public void endAllNodeStep() throws JaxenException {
        this.endStep();
    }

    public void startProcessingInstructionNodeStep(int n, String string) throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createProcessingInstructionNodeStep(n, string));
    }

    public void endProcessingInstructionNodeStep() throws JaxenException {
        this.endStep();
    }

    protected void endStep() {
        Step step = (Step)this.peekFrame().removeFirst();
        this.addPredicates(step, this.popFrame().iterator());
        this.push(step);
    }

    public void startPredicate() throws JaxenException {
        this.pushFrame();
    }

    public void endPredicate() throws JaxenException {
        Predicate predicate = this.getXPathFactory().createPredicate((Expr)this.pop());
        this.popFrame();
        this.push(predicate);
    }

    public void startFilterExpr() throws JaxenException {
        this.pushFrame();
    }

    public void endFilterExpr() throws JaxenException {
        Expr expr = (Expr)this.peekFrame().removeFirst();
        FilterExpr filterExpr = this.getXPathFactory().createFilterExpr(expr);
        Iterator iterator = this.popFrame().iterator();
        this.addPredicates(filterExpr, iterator);
        this.push(filterExpr);
    }

    protected void addPredicates(Predicated predicated, Iterator iterator) {
        while (iterator.hasNext()) {
            predicated.addPredicate((Predicate)iterator.next());
        }
    }

    protected void returnExpr() {
        Expr expr = (Expr)this.pop();
        this.popFrame();
        this.push(expr);
    }

    public void startOrExpr() throws JaxenException {
    }

    public void endOrExpr(boolean bl) throws JaxenException {
        if (bl) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createOrExpr(expr2, expr));
        }
    }

    public void startAndExpr() throws JaxenException {
    }

    public void endAndExpr(boolean bl) throws JaxenException {
        if (bl) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createAndExpr(expr2, expr));
        }
    }

    public void startEqualityExpr() throws JaxenException {
    }

    public void endEqualityExpr(int n) throws JaxenException {
        if (n != 0) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createEqualityExpr(expr2, expr, n));
        }
    }

    public void startRelationalExpr() throws JaxenException {
    }

    public void endRelationalExpr(int n) throws JaxenException {
        if (n != 0) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createRelationalExpr(expr2, expr, n));
        }
    }

    public void startAdditiveExpr() throws JaxenException {
    }

    public void endAdditiveExpr(int n) throws JaxenException {
        if (n != 0) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createAdditiveExpr(expr2, expr, n));
        }
    }

    public void startMultiplicativeExpr() throws JaxenException {
    }

    public void endMultiplicativeExpr(int n) throws JaxenException {
        if (n != 0) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createMultiplicativeExpr(expr2, expr, n));
        }
    }

    public void startUnaryExpr() throws JaxenException {
    }

    public void endUnaryExpr(int n) throws JaxenException {
        if (n != 0) {
            this.push(this.getXPathFactory().createUnaryExpr((Expr)this.pop(), n));
        }
    }

    public void startUnionExpr() throws JaxenException {
    }

    public void endUnionExpr(boolean bl) throws JaxenException {
        if (bl) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createUnionExpr(expr2, expr));
        }
    }

    public void number(int n) throws JaxenException {
        this.push(this.getXPathFactory().createNumberExpr(n));
    }

    public void number(double d) throws JaxenException {
        this.push(this.getXPathFactory().createNumberExpr(d));
    }

    public void literal(String string) throws JaxenException {
        this.push(this.getXPathFactory().createLiteralExpr(string));
    }

    public void variableReference(String string, String string2) throws JaxenException {
        this.push(this.getXPathFactory().createVariableReferenceExpr(string, string2));
    }

    public void startFunction(String string, String string2) throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createFunctionCallExpr(string, string2));
    }

    public void endFunction() throws JaxenException {
        FunctionCallExpr functionCallExpr = (FunctionCallExpr)this.peekFrame().removeFirst();
        this.addParameters(functionCallExpr, this.popFrame().iterator());
        this.push(functionCallExpr);
    }

    protected void addParameters(FunctionCallExpr functionCallExpr, Iterator iterator) {
        while (iterator.hasNext()) {
            functionCallExpr.addParameter((Expr)iterator.next());
        }
    }

    protected int stackSize() {
        return this.peekFrame().size();
    }

    protected void push(Object object) {
        this.peekFrame().addLast(object);
    }

    protected Object pop() {
        return this.peekFrame().removeLast();
    }

    protected boolean canPop() {
        return this.peekFrame().size() > 0;
    }

    protected void pushFrame() {
        this.stack.addLast(new LinkedList());
    }

    protected LinkedList popFrame() {
        return (LinkedList)this.stack.removeLast();
    }

    protected LinkedList peekFrame() {
        return (LinkedList)this.stack.getLast();
    }
}

