/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.epp.internal.mpc.core.service.CatalogBranding;
import org.eclipse.epp.internal.mpc.ui.CatalogExtensionPointReader;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogRegistry {
    private static CatalogRegistry instance;
    private final List<CatalogDescriptor> catalogDescriptors = new CopyOnWriteArrayList<CatalogDescriptor>();
    private final Map<CatalogDescriptor, CatalogBranding> catalogBrandings = new HashMap<CatalogDescriptor, CatalogBranding>();

    public static synchronized CatalogRegistry getInstance() {
        if (instance == null) {
            instance = new CatalogRegistry();
        }
        return instance;
    }

    public CatalogRegistry() {
        this.catalogDescriptors.addAll(new CatalogExtensionPointReader().getCatalogDescriptors());
    }

    public void register(CatalogDescriptor catalogDescriptor) {
        this.catalogDescriptors.add(new CatalogDescriptor(catalogDescriptor));
    }

    public void unregister(CatalogDescriptor catalogDescriptor) {
        this.catalogDescriptors.remove(catalogDescriptor);
    }

    public List<CatalogDescriptor> getCatalogDescriptors() {
        return Collections.unmodifiableList(this.catalogDescriptors);
    }

    public void addCatalogBranding(CatalogDescriptor descriptor, CatalogBranding branding) {
        this.catalogBrandings.put(descriptor, branding);
    }

    public CatalogBranding getCatalogBranding(CatalogDescriptor descriptor) {
        return this.catalogBrandings.get(descriptor);
    }

    public CatalogDescriptor findCatalogDescriptor(String url) {
        if (url == null || url.length() == 0) {
            return null;
        }
        for (CatalogDescriptor catalogDescriptor : this.catalogDescriptors) {
            if (!url.startsWith(catalogDescriptor.getUrl().toExternalForm())) continue;
            return catalogDescriptor;
        }
        return null;
    }
}

