/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util;

import com.objfac.util.Equator;
import java.util.Iterator;

public class CustomHashMap {
    private Entry[] fHead = new Entry[13];
    private int size = 0;
    private Equator fEq;

    public CustomHashMap(Equator equator) {
        this.fEq = equator;
    }

    public int size() {
        return this.size;
    }

    public void put(Object object, Object object2) {
        Entry entry;
        int n = this.fEq.hash(object);
        if (n < 0) {
            n = -n;
        }
        int n2 = n % this.fHead.length;
        Entry entry2 = this.fHead[n2];
        while (entry2 != null) {
            if (n == entry2.hash && this.fEq.equal(entry2.key, object)) {
                entry2.value = object2;
                return;
            }
            entry2 = entry2.next;
        }
        this.fHead[n2] = entry = new Entry(object, object2, n, entry2);
        ++this.size;
    }

    public Object get(Object object) {
        int n = this.fEq.hash(object);
        if (n < 0) {
            n = -n;
        }
        int n2 = n % this.fHead.length;
        Entry entry = this.fHead[n2];
        while (entry != null) {
            if (n == entry.hash && this.fEq.equal(entry.key, object)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean containsKey(Object object) {
        int n = this.fEq.hash(object);
        if (n < 0) {
            n = -n;
        }
        int n2 = n % this.fHead.length;
        Entry entry = this.fHead[n2];
        while (entry != null) {
            if (n == entry.hash && this.fEq.equal(entry.key, object)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Iterator entryIterator() {
        return new EntryIterator();
    }

    public Iterator keyIterator() {
        return new KeyIterator();
    }

    public Iterator valueIterator() {
        return new ValueIterator();
    }

    private static class Entry {
        Object key;
        Object value;
        int hash;
        Entry next;

        public Entry(Object object, Object object2, int n, Entry entry) {
            this.key = object;
            this.value = object2;
            this.hash = n;
            this.next = entry;
        }
    }

    private class EntryIterator
    implements Iterator {
        int index = 0;
        Entry next = null;

        public EntryIterator() {
            while (this.index < CustomHashMap.this.fHead.length) {
                this.next = CustomHashMap.this.fHead[this.index];
                if (this.next != null) break;
                ++this.index;
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                throw new IllegalStateException("next() called when hasNext() false");
            }
            Entry entry = this.next;
            this.next = entry.next;
            if (this.next == null && this.index < CustomHashMap.this.fHead.length) {
                ++this.index;
                while (this.index < CustomHashMap.this.fHead.length) {
                    this.next = CustomHashMap.this.fHead[this.index];
                    if (this.next != null) break;
                    ++this.index;
                }
            }
            return entry;
        }

        public void remove() {
            throw new IllegalArgumentException("remove() not supported");
        }
    }

    private class ValueIterator
    extends EntryIterator {
        ValueIterator() {
        }

        public Object next() {
            Entry entry = (Entry)super.next();
            return entry.value;
        }
    }

    private class KeyIterator
    extends EntryIterator {
        KeyIterator() {
        }

        public Object next() {
            Entry entry = (Entry)super.next();
            return entry.key;
        }
    }
}

