/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util.config;

import com.objfac.util.config.Messages;
import com.objfac.util.config.POMDocument;
import com.objfac.util.config.POMHandler;
import com.objfac.util.config.VirtualCharSequence;
import com.objfac.util.config.event.ErrorHandler;
import com.objfac.util.config.event.EventHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;

public class ParameterParser {
    private EventHandler eventHandler;
    private ErrorHandler errorHandler;
    private Reader reader;
    private static final int BUFFER_SIZE = 1024;
    static final char EOF = '\uffff';
    static final char MAX_TEXT = '\ufff8';
    private static final char BEGIN_COMPOUND = '\ufffc';
    private static final char END_COMPOUND = '\ufff9';
    private static final char BEGIN_SIMPLE = '\ufffd';
    private static final char BEGIN_COMMENT = '\ufffa';
    private static final char END_OF_FILE = '\uffff';
    private char[] buffer;
    private int inpos;
    private int top;
    private static final char NOPEEK = '\ufffe';
    private char peek = (char)65534;
    private VirtualCharSequence lineSeq;
    private static final char EOL = '\uffff';
    private int linepos;
    private boolean eofSeen;

    public static POMDocument parseDocument(File file, ErrorHandler errorHandler, boolean bl) {
        ParameterParser parameterParser = new ParameterParser();
        POMHandler pOMHandler = new POMHandler(bl);
        parameterParser.parse(file, (EventHandler)pOMHandler, errorHandler);
        return pOMHandler;
    }

    public static POMDocument parseDocument(InputStream inputStream, ErrorHandler errorHandler, boolean bl) {
        ParameterParser parameterParser = new ParameterParser();
        POMHandler pOMHandler = new POMHandler(bl);
        parameterParser.parse(inputStream, (EventHandler)pOMHandler, errorHandler);
        return pOMHandler;
    }

    public static POMDocument parseDocument(Reader reader, ErrorHandler errorHandler, boolean bl) {
        ParameterParser parameterParser = new ParameterParser();
        POMHandler pOMHandler = new POMHandler(bl);
        parameterParser.parse(reader, (EventHandler)pOMHandler, errorHandler);
        return pOMHandler;
    }

    static char encodedType(int n) {
        return (char)(65535 - n);
    }

    static int decodedType(char c) {
        return 65535 - c;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(File file, EventHandler eventHandler, ErrorHandler errorHandler) {
        this.initialize(eventHandler, errorHandler);
        eventHandler.beginDocument();
        this.reader = null;
        try {
            try {
                this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                this.readFile();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error(4, 1, MessageFormat.format(Messages.fileNotFound, file.getAbsolutePath()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.error(4, 0, Messages.unsupportedEncodingException);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                this.reader.close();
            }
            catch (IOException iOException) {}
            eventHandler.endDocument();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (IOException iOException) {}
        this.reader.close();
        eventHandler.endDocument();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(InputStream inputStream, EventHandler eventHandler, ErrorHandler errorHandler) {
        this.initialize(eventHandler, errorHandler);
        eventHandler.beginDocument();
        try {
            try {
                this.reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                this.readFile();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.error(4, 0, Messages.unsupportedEncodingException);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            eventHandler.endDocument();
            throw throwable;
        }
        {
            Object var4_6 = null;
            eventHandler.endDocument();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(Reader reader, EventHandler eventHandler, ErrorHandler errorHandler) {
        this.initialize(eventHandler, errorHandler);
        this.reader = reader;
        eventHandler.beginDocument();
        try {
            this.readFile();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            eventHandler.endDocument();
            throw throwable;
        }
        {
            Object var4_6 = null;
            eventHandler.endDocument();
            return;
        }
    }

    private void error(int n, int n2, String string) {
        if (this.errorHandler != null) {
            this.errorHandler.error(n, n2, string);
        }
    }

    private void initialize(EventHandler eventHandler, ErrorHandler errorHandler) {
        if (eventHandler == null) {
            throw new IllegalArgumentException();
        }
        this.eventHandler = eventHandler;
        this.errorHandler = errorHandler;
        this.buffer = null;
        this.inpos = 0;
        this.top = 0;
        this.peek = (char)65534;
        this.linepos = 0;
        this.eofSeen = false;
    }

    private void readFile() {
        VirtualCharSequence virtualCharSequence = new VirtualCharSequence();
        VirtualCharSequence virtualCharSequence2 = new VirtualCharSequence();
        block0: while (this.readLine(virtualCharSequence)) {
            this.newLine(virtualCharSequence);
            this.reset(virtualCharSequence2);
            while (true) {
                char c;
                char c2;
                if ((c2 = this.nextChar()) == '\uffff') {
                    this.textEvent(virtualCharSequence2);
                    continue block0;
                }
                if (c2 == '#') {
                    this.textEvent(virtualCharSequence2);
                    while ((c2 = this.nextChar()) != '\uffff') {
                        this.extend(virtualCharSequence2);
                    }
                    this.commentEvent(virtualCharSequence2);
                    continue;
                }
                if (c2 == '=') {
                    if (virtualCharSequence2.length() > 0) {
                        this.simpleEvent(virtualCharSequence2);
                        this.reset(virtualCharSequence2);
                        continue;
                    }
                    this.extend(virtualCharSequence2);
                    this.endText(virtualCharSequence2);
                    continue;
                }
                if (c2 == '[' || c2 == ']') {
                    VirtualCharSequence virtualCharSequence3 = new VirtualCharSequence();
                    virtualCharSequence3.become(virtualCharSequence, this.linepos - 1, this.linepos);
                    this.endText(virtualCharSequence2);
                    while (this.isIdChar(this.peek())) {
                        this.nextChar();
                        this.extend(virtualCharSequence2);
                        this.extend(virtualCharSequence3);
                    }
                    virtualCharSequence2.toString();
                    if (virtualCharSequence2.length() > 0 && ((c = this.peek()) == ']' || c2 == '[' && c == '[')) {
                        this.nextChar();
                        if (c == '[') {
                            this.beginCompoundEvent(virtualCharSequence2);
                            continue;
                        }
                        if (c2 == '[' && c == ']') {
                            this.sectionEvent(virtualCharSequence2);
                            continue;
                        }
                        this.endCompoundEvent(virtualCharSequence2);
                        continue;
                    }
                    this.endText(virtualCharSequence3);
                    continue;
                }
                if (c2 == '`' && ((c = this.peek()) == '=' || c == '#' || c == '[' || c == ']' || c == '`')) {
                    this.textEvent(virtualCharSequence2);
                    while (this.peek() == c) {
                        this.nextChar();
                        this.extend(virtualCharSequence2);
                    }
                    this.endText(virtualCharSequence2);
                    continue;
                }
                if (!this.isIdChar(c2)) {
                    this.extend(virtualCharSequence2);
                    this.endText(virtualCharSequence2);
                    continue;
                }
                this.extend(virtualCharSequence2);
            }
        }
    }

    private boolean isIdChar(char c) {
        return c > ' ' && !this.isWhitespace(c) && c != '\uffff' && c != '=' && c != '#' && c != '[' && c != ']';
    }

    private void endText(VirtualCharSequence virtualCharSequence) {
        while (this.isWhitespace(this.peek())) {
            this.nextChar();
            this.extend(virtualCharSequence);
        }
        this.textEvent(virtualCharSequence);
    }

    private void extend(VirtualCharSequence virtualCharSequence) {
        virtualCharSequence.setLength(virtualCharSequence.length() + 1);
    }

    private void sectionEvent(VirtualCharSequence virtualCharSequence) {
        this.eventHandler.section(virtualCharSequence);
        this.reset(virtualCharSequence);
    }

    private void commentEvent(VirtualCharSequence virtualCharSequence) {
        this.eventHandler.comment(virtualCharSequence);
        this.reset(virtualCharSequence);
    }

    private void textEvent(VirtualCharSequence virtualCharSequence) {
        if (virtualCharSequence.length() > 0) {
            this.eventHandler.text(virtualCharSequence);
        }
        this.reset(virtualCharSequence);
    }

    private void simpleEvent(VirtualCharSequence virtualCharSequence) {
        this.eventHandler.simpleParameter(virtualCharSequence);
        this.reset(virtualCharSequence);
    }

    private void beginCompoundEvent(VirtualCharSequence virtualCharSequence) {
        this.eventHandler.beginCompoundParameter(virtualCharSequence);
        this.reset(virtualCharSequence);
    }

    private void endCompoundEvent(VirtualCharSequence virtualCharSequence) {
        this.eventHandler.endCompoundParameter(virtualCharSequence);
        this.reset(virtualCharSequence);
    }

    private void reset(VirtualCharSequence virtualCharSequence) {
        virtualCharSequence.become(this.lineSeq, this.linepos, this.linepos);
    }

    private void newLine(VirtualCharSequence virtualCharSequence) {
        this.lineSeq = virtualCharSequence;
        this.linepos = 0;
    }

    private char peek() {
        if (this.linepos < this.lineSeq.length()) {
            return this.lineSeq.charAt(this.linepos);
        }
        return '\uffff';
    }

    private char nextChar() {
        if (this.linepos < this.lineSeq.length()) {
            return this.lineSeq.charAt(this.linepos++);
        }
        return '\uffff';
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    private boolean readLine(VirtualCharSequence virtualCharSequence) {
        boolean bl;
        if (this.buffer == null) {
            this.buffer = new char[1024];
            this.inpos = 0;
            this.top = 0;
        }
        if (this.eofSeen) {
            return false;
        }
        int n = this.inpos;
        do {
            int n2;
            bl = false;
            while (this.inpos < this.top && !this.endLine(this.buffer[this.inpos])) {
                ++this.inpos;
            }
            if (n == this.inpos) {
                bl = true;
            }
            if (this.inpos < this.top) {
                if ((n2 = this.buffer[this.inpos++]) == 13) {
                    if (this.inpos < this.top) {
                        if (this.buffer[this.inpos] == '\n') {
                            ++this.inpos;
                        }
                        bl = false;
                    } else {
                        bl = true;
                    }
                } else {
                    bl = false;
                }
            } else {
                bl = true;
            }
            if (bl) {
                int n3;
                if (n > 0) {
                    System.arraycopy(this.buffer, n, this.buffer, 0, this.inpos - n);
                    this.inpos -= n;
                    n = 0;
                }
                if (this.inpos == this.buffer.length) {
                    char[] cArray = new char[this.buffer.length + 1024];
                    System.arraycopy(this.buffer, 0, cArray, 0, this.buffer.length);
                    this.buffer = cArray;
                }
                n2 = this.buffer.length - this.inpos;
                try {
                    n3 = this.reader.read(this.buffer, this.inpos, n2);
                }
                catch (IOException iOException) {
                    this.error(3, 2, Messages.ioError);
                    n3 = -1;
                }
                if (n3 < 0) {
                    this.eofSeen = true;
                    bl = false;
                    if (n == this.inpos) {
                        return false;
                    }
                } else {
                    this.top = this.inpos + n3;
                }
            }
            if (bl) continue;
            virtualCharSequence.become(this.buffer, n, this.inpos);
        } while (bl);
        return true;
    }

    private boolean endLine(char c) {
        return c == '\r' || c == '\n';
    }
}

