/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.services.impl;

import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.services.IPropertyProvider;

public class PropertyProviderImpl
implements IPropertyProvider {
    public static final String DEFAULT_ODA_CONFIGURATION_ID_PROP_NAME = "OdaPropertyConfigId";
    private String m_propConfigId;

    public Properties getDataSourceProperties(Properties candidateProperties, Object appContext) throws OdaException {
        String configIdPropName = this.getConfigurationIdPropertyName();
        if (candidateProperties == null || !candidateProperties.containsKey(configIdPropName)) {
            this.m_propConfigId = null;
            return candidateProperties;
        }
        this.m_propConfigId = candidateProperties.getProperty(configIdPropName);
        return this.adjustDataSourceProperties(candidateProperties, appContext);
    }

    public String getConfigurationId() {
        return this.m_propConfigId;
    }

    protected String getConfigurationIdPropertyName() {
        return DEFAULT_ODA_CONFIGURATION_ID_PROP_NAME;
    }

    protected Properties adjustDataSourceProperties(Properties candidateProperties, Object appContext) throws OdaException {
        if (this.getConfigurationId() == null) {
            return candidateProperties;
        }
        Properties configProps = this.getExternalizedProperties(this.getConfigurationId(), appContext);
        if (configProps == null || configProps.isEmpty()) {
            return candidateProperties;
        }
        Properties mergedProps = new Properties();
        mergedProps.putAll((Map<?, ?>)candidateProperties);
        mergedProps.putAll((Map<?, ?>)configProps);
        return mergedProps;
    }

    protected Properties getExternalizedProperties(String configId, Object appContext) throws OdaException {
        return null;
    }
}

