/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xml.io;

import com.objfac.util.Misc;
import com.objfac.xml.io.IDocumentStore;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractDocumentStore
implements IDocumentStore {
    protected static final String META = "meta.xml";
    protected boolean fFirst = true;
    private static final String NULPUB = "<pub null='true'/>";
    private static final String BEGPUB = "<pub>";
    private static final String ENDPUB = "</pub>";
    private static final String NULABS = "<abs null='true'/>";
    private static final String BEGABS = "<abs>";
    private static final String ENDABS = "</abs>";
    private static final String BEGREL = "<rel>";
    private static final String ENDREL = "</rel>";
    private static final String BEGFIL = "<file>";
    private static final String ENDFIL = "</file>";
    private LinkedList fMeta = new LinkedList();
    private HashMap fPubToMeta = new HashMap();
    private HashMap fAbsToMeta = new HashMap();
    private int fMaxRel = 0;

    protected void init() throws IOException {
        if (!this.exists(META)) {
            if (!this.create(META)) {
                throw new FileNotFoundException(META);
            }
            this.writeMeta(this.getWriter(this.getOutputStream(META)));
        } else {
            this.readMeta(this.getReader(this.getInputStream(META)));
        }
    }

    protected void checkInit() {
        if (this.fFirst) {
            this.fFirst = false;
            try {
                this.init();
            }
            catch (IOException iOException) {
                System.err.println(String.valueOf(this.getClass().getName()) + " Cache initialization failed");
                iOException.printStackTrace();
            }
        }
    }

    public abstract boolean exists(String var1);

    public abstract InputStream getInputStream(String var1) throws IOException;

    public boolean create(String string) throws IOException {
        return false;
    }

    public boolean remove(String string) throws IOException {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public OutputStream getOutputStream(String string) throws IOException {
        throw new IOException("Cannot create output stream for " + string);
    }

    protected Writer getWriter(OutputStream outputStream) throws IOException {
        return new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
    }

    protected Reader getReader(InputStream inputStream) throws IOException {
        return new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
    }

    protected void clearStore() throws IOException {
        this.fMeta.clear();
        this.writeMeta(this.getWriter(this.getOutputStream(META)));
    }

    public boolean isStored(String string, String string2) {
        this.checkInit();
        return string != null && this.fPubToMeta.containsKey(string) || string2 != null && this.fAbsToMeta.containsKey(string2);
    }

    public String getSysid(String string) {
        this.checkInit();
        Meta meta = (Meta)this.fPubToMeta.get(string);
        return meta != null ? meta.abs : null;
    }

    public List getIds() {
        this.checkInit();
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = this.fMeta.iterator();
        while (iterator.hasNext()) {
            Meta meta = (Meta)iterator.next();
            linkedList.add(meta.pub);
            linkedList.add(meta.abs);
        }
        return linkedList;
    }

    protected String getStoredRel(String string, String string2) throws IOException {
        this.checkInit();
        Meta meta = this.getMeta(string, string2);
        return meta != null ? meta.rel : null;
    }

    private Meta getMeta(String string, String string2) {
        Meta meta;
        return string != null && (meta = (Meta)this.fPubToMeta.get(string)) != null || string2 != null && (meta = (Meta)this.fAbsToMeta.get(string2)) != null ? meta : null;
    }

    public char[] load(String string, String string2) throws IOException {
        char[] cArray;
        this.checkInit();
        Meta meta = this.getMeta(string, string2);
        return meta == null ? null : ((cArray = this.loadFromMemory(meta)) != null ? cArray : this.loadFromStorage(meta));
    }

    protected char[] loadFromMemory(Meta meta) {
        return (char[])meta.ref.get();
    }

    protected char[] loadFromStorage(Meta meta) throws IOException {
        Reader reader = this.getReader(this.getInputStream(meta.rel));
        char[] cArray = Misc.readContents((Reader)reader);
        reader.close();
        meta.ref = new WeakReference<char[]>(cArray);
        return cArray;
    }

    public boolean load(String string, String string2, StringBuffer stringBuffer) throws IOException {
        char[] cArray = this.load(string, string2);
        return cArray != null && stringBuffer.append(cArray) != null;
    }

    public void store(String string, String string2, char[] cArray) throws IOException {
        this.checkInit();
        String string3 = this.getNewRel();
        Writer writer = this.getWriter(this.getOutputStream(string3));
        Misc.write((Writer)writer, (char[])cArray);
        writer.close();
        this.addMeta(string, string2, string3, Misc.copy((char[])cArray));
    }

    public void store(String string, String string2, StringBuffer stringBuffer, int n, int n2) throws IOException {
        this.checkInit();
        String string3 = this.getNewRel();
        Writer writer = this.getWriter(this.getOutputStream(string3));
        Misc.write((Writer)writer, (StringBuffer)stringBuffer, (int)n, (int)n2);
        writer.close();
        this.addMeta(string, string2, string3, Misc.toCharArray((StringBuffer)stringBuffer, (int)n, (int)n2));
    }

    private void addMeta(String string, String string2, String string3, char[] cArray) throws IOException {
        Meta meta = new Meta(string, string2, string3, cArray);
        this.checkRemove(meta);
        this.addMeta(meta);
        this.writeMeta(this.getWriter(this.getOutputStream(META)));
    }

    protected String getNewRel() throws IOException {
        String string;
        while (this.exists(string = "f" + ++this.fMaxRel)) {
        }
        if (!this.create(string)) {
            throw new IOException("Can't create cache resource " + string);
        }
        return string;
    }

    private void checkRemove(Meta meta) throws IOException {
        Meta meta2 = meta.pub != null ? this.fPubToMeta.get(meta.pub) : null;
        if (meta2 != null) {
            if (meta2.abs == null || meta2.abs.equals(meta.abs)) {
                this.remove(meta2);
            } else {
                meta2.pub = null;
            }
        }
        if ((meta2 = (Meta)(meta.abs != null ? this.fAbsToMeta.get(meta.abs) : null)) != null) {
            if (meta2.pub == null || meta2.pub.equals(meta.pub)) {
                this.remove(meta2);
            } else {
                meta2.abs = null;
            }
        }
    }

    protected void remove(Meta meta) throws IOException {
        if (!this.remove(meta.rel)) {
            throw new IOException("Unable to remove " + meta.rel);
        }
        Iterator iterator = this.fMeta.iterator();
        while (iterator.hasNext()) {
            Meta meta2 = (Meta)iterator.next();
            if (meta2 != meta) continue;
            iterator.remove();
            break;
        }
        if (meta.pub != null && meta == this.fPubToMeta.get(meta.pub)) {
            this.fPubToMeta.remove(meta.pub);
        }
        if (meta.abs != null && meta == this.fAbsToMeta.get(meta.abs)) {
            this.fAbsToMeta.remove(meta.abs);
        }
    }

    protected void readMeta(Reader reader) throws IOException {
        char[] cArray = Misc.readContents((Reader)reader);
        this.parseMeta(cArray);
    }

    private void parseMeta(char[] cArray) {
        int n = 0;
        int n2 = cArray.length;
        while ((n = this.skipto('<', cArray, n, n2)) != n2) {
            int n3;
            boolean bl = this.match(BEGPUB, cArray, n, n2);
            if (!bl && !this.match(NULPUB, cArray, n, n2)) {
                ++n;
                continue;
            }
            String string = null;
            if (bl) {
                n3 = n += BEGPUB.length();
                if ((n = this.skipto('<', cArray, n, n2)) == n2 || !this.match(ENDPUB, cArray, n, n2)) {
                    throw new IllegalStateException("Missing </pub> in meta file");
                }
                string = this.decode(new String(cArray, n3, n - n3));
                n += ENDPUB.length();
            } else {
                n += NULPUB.length();
            }
            String string2 = null;
            n = this.skipto('<', cArray, n, n2);
            if (this.match(NULABS, cArray, n, n2)) {
                n += NULABS.length();
            } else {
                if (n == n2 || !this.match(BEGABS, cArray, n, n2)) {
                    throw new IllegalStateException("Missing <abs> in meta file");
                }
                n3 = n += BEGABS.length();
                if ((n = this.skipto('<', cArray, n, n2)) == n2 || !this.match(ENDABS, cArray, n, n2)) {
                    throw new IllegalStateException("Missing </abs> in meta file");
                }
                string2 = this.decode(new String(cArray, n3, n - n3));
                n += ENDABS.length();
            }
            n = this.skipto('<', cArray, n, n2);
            if (n == n2 || !this.match(BEGREL, cArray, n, n2)) {
                throw new IllegalStateException("Missing <rel> in meta file");
            }
            n3 = n += BEGREL.length();
            if ((n = this.skipto('<', cArray, n, n2)) == n2 || !this.match(ENDREL, cArray, n, n2)) {
                throw new IllegalStateException("Missing </rel> in meta file");
            }
            String string3 = new String(cArray, n3, n - n3);
            n += ENDREL.length();
            if (string3.length() < 2) {
                throw new IllegalStateException("rel name must be two or more characters");
            }
            if (string3.startsWith("f") && string3.charAt(1) >= '0' && string3.charAt(1) <= '9') {
                try {
                    int n4 = Integer.parseInt(string3.substring(1));
                    if (this.fMaxRel < n4) {
                        this.fMaxRel = n4;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalStateException("Unknown rel format " + string3);
                }
            }
            Meta meta = new Meta(string, string2, string3, null);
            this.addMeta(meta);
        }
    }

    protected void addMeta(Meta meta) {
        this.fMeta.add(meta);
        if (meta.pub != null) {
            this.fPubToMeta.put(meta.pub, meta);
        }
        if (meta.abs != null) {
            this.fAbsToMeta.put(meta.abs, meta);
        }
    }

    private int skipto(char c, char[] cArray, int n, int n2) {
        while (n < n2 && cArray[n] != c) {
            if (cArray[n] == c) break;
            ++n;
        }
        return n;
    }

    private boolean match(String string, char[] cArray, int n, int n2) {
        int n3 = n + string.length();
        if (n3 > n2) {
            return false;
        }
        int n4 = 0;
        while (n < n3) {
            if (cArray[n] != string.charAt(n4)) {
                return false;
            }
            ++n4;
            ++n;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeMeta(Writer writer) throws IOException {
        try {
            writer.write("<?xml version='1.0' encoding='UTF-8'?>");
            this.writeEOL(writer);
            writer.write("<!-- Cached file directory. Do not edit this file by hand -->");
            this.writeEOL(writer);
            writer.write("<meta>");
            this.writeEOL(writer);
            Iterator iterator = this.fMeta.iterator();
            while (true) {
                block8: {
                    if (iterator.hasNext()) break block8;
                    writer.write("</meta>");
                    this.writeEOL(writer);
                    break;
                }
                Meta meta = (Meta)iterator.next();
                writer.write("  <file>");
                this.writeEOL(writer);
                if (meta.pub != null) {
                    writer.write("    <pub>");
                    writer.write(this.encode(meta.pub));
                    writer.write(ENDPUB);
                } else {
                    writer.write("    <pub null='true'/>");
                }
                this.writeEOL(writer);
                if (meta.abs != null) {
                    writer.write("    <abs>");
                    writer.write(this.encode(meta.abs));
                    writer.write(ENDABS);
                } else {
                    writer.write("    <abs null='true'/>");
                }
                this.writeEOL(writer);
                writer.write("    <rel>");
                writer.write(meta.rel);
                writer.write(ENDREL);
                this.writeEOL(writer);
                writer.write("  </file>");
                this.writeEOL(writer);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            writer.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        writer.close();
    }

    private void writeEOL(Writer writer) throws IOException {
        writer.write(Misc.EOL);
    }

    private String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            if (cArray[n] == '&') {
                if (this.match("&lt;", cArray, n, n2)) {
                    stringBuffer.append('<');
                    n += 3;
                } else if (this.match("&amp;", cArray, n, n2)) {
                    stringBuffer.append('&');
                    n += 4;
                } else {
                    stringBuffer.append('&');
                }
            } else {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected static class Meta {
        public String pub;
        public String abs;
        public String rel;
        public WeakReference ref;

        public Meta(String string, String string2, String string3, char[] cArray) {
            this.pub = string;
            this.abs = string2;
            this.rel = string3;
            this.ref = new WeakReference<char[]>(cArray);
        }
    }
}

