/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xml.io.writers;

import com.objfac.util.Misc;
import com.objfac.xml.schema.IAtom;
import com.objfac.xml.schema.IAttr;
import com.objfac.xml.schema.IComplexType;
import com.objfac.xml.schema.IElement;
import com.objfac.xml.schema.IEntity;
import com.objfac.xml.schema.IEnumFacet;
import com.objfac.xml.schema.IExternalEntity;
import com.objfac.xml.schema.IFacet;
import com.objfac.xml.schema.IModel;
import com.objfac.xml.schema.INotation;
import com.objfac.xml.schema.ISchema;
import com.objfac.xml.schema.ISimpleType;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;

public class CanonicalDTD {
    private static final String EOL = "\r\n";
    private Writer fWriter;
    private ISchema fSchema;

    public CanonicalDTD(ISchema iSchema, Writer writer) {
        this.fSchema = iSchema;
        this.fWriter = writer;
    }

    public void write() throws IOException {
        this.writeNotations();
        this.writeEntities();
        this.writeElementsAndAttrs();
    }

    private void writeNotations() throws IOException {
        INotation[] iNotationArray = this.fSchema.getNotations();
        int n = 0;
        while (n < iNotationArray.length) {
            INotation iNotation = iNotationArray[n];
            this.writeNotation(iNotation);
            ++n;
        }
    }

    private void writeNotation(INotation iNotation) throws IOException {
        this.write("<!NOTATION ");
        this.write(iNotation.getName());
        this.writeSpace();
        String string = iNotation.getPublic();
        String string2 = iNotation.getSystem();
        if (string != null) {
            this.write("PUBLIC ");
            this.writeString(string);
            if (string2 != null) {
                this.writeSpace();
                this.writeString(string2);
            }
        } else {
            this.write("SYSTEM ");
            this.writeString(string2);
        }
        this.write(">");
        this.write(EOL);
    }

    private void writeEntities() throws IOException {
        IEntity[] iEntityArray = this.fSchema.getEntities();
        int n = 0;
        while (n < iEntityArray.length) {
            IEntity iEntity = iEntityArray[n];
            this.writeGE(iEntity);
            ++n;
        }
    }

    private void writeGE(IEntity iEntity) throws IOException {
        this.write("<!ENTITY ");
        this.write(iEntity.getName());
        Object object = iEntity.getValue();
        if (object instanceof String) {
            this.write((String)object);
        } else {
            IExternalEntity iExternalEntity = (IExternalEntity)object;
            String string = iExternalEntity.getPublicId();
            String string2 = iExternalEntity.getSystemId();
            if (string == null) {
                this.write("SYSTEM ");
            } else {
                this.write("PUBLIC ");
                this.writeString(string);
                this.writeSpace();
            }
            this.writeString(string2);
            this.write("\"");
            String string3 = iEntity.getNData();
            if (string3 != null) {
                this.write("NDATA ");
                this.writeString(string3);
            }
        }
        this.write(">");
        this.write(EOL);
    }

    private void writeElementsAndAttrs() throws IOException {
        IElement[] iElementArray = this.fSchema.getElements().toArray(new IElement[this.fSchema.getElements().size()]);
        Arrays.sort(iElementArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((IElement)object).getName().compareTo(((IElement)object2).getName());
            }

            public boolean equals(Object object) {
                return object == this;
            }
        });
        int n = 0;
        while (n < iElementArray.length) {
            IElement iElement = iElementArray[n];
            IComplexType iComplexType = iElement.getComplexType();
            this.writeElement(iElement, iComplexType);
            this.writeAttlist(iElement, iComplexType);
            ++n;
        }
    }

    private void writeElement(IElement iElement, IComplexType iComplexType) throws IOException {
        String string = iElement.getName();
        this.write("<!ELEMENT ");
        this.write(string);
        this.writeSpace();
        if (iElement.isUndefined() || iComplexType.isAny()) {
            this.write("ANY");
        } else if (iComplexType.isEmpty()) {
            this.write("EMPTY");
        } else {
            IModel iModel = iComplexType.getElementModel();
            this.write("(");
            if (iComplexType.isMixed()) {
                this.write("#PCDATA");
                IModel[] iModelArray = iModel.getContents();
                if (iModelArray.length > 0) {
                    this.write("|");
                    this.write(iModel);
                } else {
                    this.write(")");
                }
            } else {
                this.write(iModel);
            }
        }
        this.write(">");
        this.write(EOL);
    }

    private void writeAttlist(IElement iElement, IComplexType iComplexType) throws IOException {
        this.write("<!ATTLIST ");
        this.write(iElement.getName());
        IModel iModel = iComplexType.getAttributeModel();
        Object[] objectArray = iModel.getContents();
        if (objectArray.length > 0) {
            IModel[] iModelArray = (IModel[])Misc.copyArray((Object[])objectArray);
            Arrays.sort(iModelArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((IModel)object).getLeaf().getName().compareTo(((IModel)object2).getLeaf().getName());
                }

                public boolean equals(Object object) {
                    return object == this;
                }
            });
            int n = 0;
            while (n < iModelArray.length) {
                boolean bl;
                int n2;
                Object object;
                this.write(EOL);
                IModel iModel2 = iModelArray[n];
                IAttr iAttr = (IAttr)iModel2.getLeaf();
                this.write(iAttr.getName());
                this.writeSpace();
                ISimpleType iSimpleType = iAttr.getSimpleType();
                ISimpleType iSimpleType2 = iSimpleType.getBaseType();
                IFacet[] iFacetArray = iSimpleType.getFacets();
                if (iSimpleType.getName().equals("CDATA")) {
                    this.write("CDATA");
                } else if (iSimpleType2.getName().equals("NMTOKEN") && !iSimpleType.getName().equals("NMTOKENS")) {
                    if (iFacetArray != null && iFacetArray.length > 0) {
                        this.write("(");
                        object = (IEnumFacet)iFacetArray[0];
                        Object[] objectArray2 = (String[])Misc.copyArray((Object[])object.getEnum());
                        Arrays.sort(objectArray2);
                        n2 = 0;
                        while (n2 < objectArray2.length) {
                            this.write((String)objectArray2[n2]);
                            if (n2 + 1 < objectArray2.length) {
                                this.write("|");
                            }
                            ++n2;
                        }
                        this.write(")");
                    } else {
                        this.write(iSimpleType.getName());
                    }
                } else if (iSimpleType2.getName().equals("NOTATION")) {
                    if (iFacetArray != null && iFacetArray.length > 0) {
                        this.write("NOTATION (");
                        object = (IEnumFacet)iFacetArray[0];
                        Object[] objectArray3 = (String[])Misc.copyArray((Object[])object.getEnum());
                        Arrays.sort(objectArray3);
                        n2 = 0;
                        while (n2 < objectArray3.length) {
                            this.write((String)objectArray3[n2]);
                            if (n2 + 1 < objectArray3.length) {
                                this.write("|");
                            }
                            ++n2;
                        }
                        this.write(")");
                    } else {
                        this.write(iSimpleType.getName());
                    }
                } else {
                    this.write(iSimpleType.getName());
                }
                this.writeSpace();
                object = iAttr.getDefault();
                boolean bl2 = bl = iModel2.getMinOccurs() == 1;
                if (bl) {
                    this.write("#REQUIRED");
                } else if (object != null) {
                    if (iAttr.isFixed()) {
                        this.write("#FIXED ");
                    }
                    this.writeString((String)object);
                } else {
                    this.write("#IMPLIED");
                }
                if (n + 1 < iModelArray.length) {
                    this.write(" ");
                }
                ++n;
            }
        }
        this.write(">");
        this.write(EOL);
    }

    private void writeSpace() throws IOException {
        this.write(" ");
    }

    private void write(IModel iModel) throws IOException {
        String string = iModel.getOperator();
        IModel[] iModelArray = iModel.getContents();
        int n = iModelArray.length - 1;
        int n2 = 0;
        while (n2 <= n) {
            IModel iModel2 = iModelArray[n2];
            IAtom iAtom = iModel2.getLeaf();
            if (iAtom != null) {
                IElement iElement = (IElement)iAtom;
                this.write(iElement.getName());
            } else {
                this.write("(");
                this.write(iModel2);
            }
            if (n2 < n) {
                this.write(string);
            }
            ++n2;
        }
        this.write(")");
        this.write(iModel.getQualifier());
    }

    private void write(String string) throws IOException {
        this.fWriter.write(string);
    }

    private void writeString(String string) throws IOException {
        this.write("\"");
        this.write(string);
        this.write("\"");
    }
}

