/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xml.schema.impl;

import com.objfac.xml.parsers.NfmParser;
import com.objfac.xml.schema.IComplexType;
import com.objfac.xml.schema.IDfm;
import com.objfac.xml.schema.IModel;
import com.objfac.xml.schema.impl.Dfm;
import com.objfac.xml.schema.impl.Markup;
import com.objfac.xml.schema.impl.Nfm;
import com.objfac.xml.schema.impl.Schema;
import com.objfac.xml.schema.impl.SimpleType;
import com.objfac.xml.schema.impl.Type;
import com.objfac.xml.schema.impl.UnorderedDfm;

public class ComplexType
extends Type
implements IComplexType {
    private IComplexType fBase;
    private IModel fElements;
    private IModel fAttrs;
    private boolean fMixed = false;
    private boolean fAny = false;
    private boolean fEmpty = false;
    private boolean fHasChildren = false;
    private Dfm fElementDfm;
    private static final NfmParser fNfmParser = new NfmParser();
    private Dfm fAttrDfm;
    private int fBlock;
    private int fFinal;
    private boolean fAbstract;
    private Markup fDefinition;
    private SimpleType fSimpleContent;

    public IComplexType getBaseType() {
        return this.fBase;
    }

    public IModel getElementModel() {
        return this.fElements;
    }

    public IModel getAttributeModel() {
        return this.fAttrs;
    }

    public boolean isMixed() {
        return this.fMixed;
    }

    public boolean isAny() {
        return this.fAny;
    }

    public boolean isEmpty() {
        return this.fEmpty;
    }

    public ComplexType(String string, Schema schema) {
        super(6, string, schema);
    }

    public ComplexType(Schema schema) {
        super(6, schema);
    }

    public void setBaseType(IComplexType iComplexType) {
        this.fBase = iComplexType;
    }

    public void setElementModel(IModel iModel) {
        this.fElements = iModel;
    }

    public void setAttributeModel(IModel iModel) {
        this.fAttrs = iModel;
    }

    public void setMixed(boolean bl) {
        this.fMixed = bl;
    }

    public void setAny(boolean bl) {
        this.fAny = bl;
    }

    public void setEmpty(boolean bl) {
        this.fEmpty = bl;
    }

    public boolean hasChildren() {
        return this.fHasChildren;
    }

    public void setChildren(boolean bl) {
        this.fHasChildren = bl;
    }

    public IDfm getElementDfm() {
        Dfm dfm = this.fElementDfm;
        if (dfm == null) {
            this.fElementDfm = dfm = this.parseElementDfm();
        }
        if (dfm.unordered) {
            ((UnorderedDfm)dfm).clear();
        }
        return dfm;
    }

    private Dfm parseElementDfm() {
        Dfm dfm;
        if (this.fAny) {
            dfm = Dfm.dfm(true);
            dfm.any = true;
        } else if (this.fEmpty) {
            dfm = Dfm.dfm(true);
            dfm.empty = true;
        } else {
            dfm = this.parseModel(this.getElementModel());
        }
        return dfm;
    }

    private Dfm parseModel(IModel iModel) {
        Dfm dfm;
        Nfm nfm = iModel.toNfm();
        if (nfm != null) {
            fNfmParser.setErrorHandler(null);
            dfm = fNfmParser.parse(nfm, true);
            if (iModel.getKind() == 3) {
                Dfm dfm2 = dfm;
                dfm = new UnorderedDfm(dfm);
                Dfm.free(dfm2);
            }
        } else {
            dfm = Dfm.dfm(false);
        }
        return dfm;
    }

    public IDfm getAttributeDfm() {
        Dfm dfm = this.fAttrDfm;
        if (dfm == null) {
            this.fAttrDfm = dfm = this.parseModel(this.getAttributeModel());
        }
        if (dfm.unordered) {
            ((UnorderedDfm)dfm).clear();
        }
        return dfm;
    }

    public int getBlock() {
        return this.fBlock;
    }

    public int getFinal() {
        return this.fFinal;
    }

    public boolean isAbstract() {
        return this.fAbstract;
    }

    public void setAbstract(boolean bl) {
        this.fAbstract = bl;
    }

    public void setBlock(int n) {
        this.fBlock = n;
    }

    public void setFinal(int n) {
        this.fFinal = n;
    }

    public SimpleType getSimpleContent() {
        return this.fSimpleContent;
    }

    public void setSimpleContent(SimpleType simpleType) {
        this.fSimpleContent = simpleType;
    }
}

