/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.ant_task;

import org.apache.tools.ant.BuildException;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.swt.graphics.Image;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.ant_task.ERMasterAntTaskBase;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.dbexport.image.ExportToImageManager;
import org.insightech.er.editor.view.action.dbexport.ExportToImageAction;

public class ImageAntTask
extends ERMasterAntTaskBase {
    private String outputFile;

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    protected void doTask(ERDiagram diagram) throws Exception {
        if (this.outputFile == null || this.outputFile.trim().equals("")) {
            throw new BuildException("outputFile attribute must be set!");
        }
        this.outputFile = this.getAbsolutePath(this.outputFile);
        this.log("Output to : " + this.outputFile);
        Image img = null;
        GraphicalViewer viewer = null;
        try {
            viewer = Activator.createGraphicalViewer((ERDiagram)diagram);
            int format = ExportToImageAction.getFormatType((String)this.outputFile);
            if (format == -1) {
                throw new BuildException(String.valueOf(ResourceString.getResourceString((String)"dialog.message.export.image.not.supported")) + " : " + this.outputFile);
            }
            img = Activator.createImage((GraphicalViewer)viewer);
            ExportToImageManager exportToImageManager = new ExportToImageManager(img, format, this.outputFile);
            exportToImageManager.doProcess();
        }
        finally {
            if (viewer != null) {
                viewer.getContents().deactivate();
            }
            if (img != null) {
                img.dispose();
            }
        }
    }

    @Override
    protected void logUsage() {
        this.log("<ermaster.image> have these attributes. (the attribute with '*' must be set.) ");
        this.log("    * diagramFile - The path of the input .erm file.");
        this.log("    * outputFile  - The path of the output image file. The png/jpg/jpeg/bmp format are supported.");
    }
}

