/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterators.ReadOnlyCompositeListIterator;
import org.eclipse.jpt.common.utility.internal.iterators.ReadOnlyListIterator;
import org.eclipse.jpt.common.utility.internal.model.value.ListValueModelWrapper;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedListValueModelWrapper<E>
extends ListValueModelWrapper<E>
implements ListValueModel<E> {
    protected List<E> prefix;
    protected List<E> suffix;

    public ExtendedListValueModelWrapper(List<? extends E> prefix, ListValueModel<? extends E> listHolder, List<? extends E> suffix) {
        super(listHolder);
        this.prefix = new ArrayList<E>(prefix);
        this.suffix = new ArrayList<E>(suffix);
    }

    public ExtendedListValueModelWrapper(E prefix, ListValueModel<? extends E> listHolder, E suffix) {
        super(listHolder);
        this.prefix = Collections.singletonList(prefix);
        this.suffix = Collections.singletonList(suffix);
    }

    public ExtendedListValueModelWrapper(List<? extends E> prefix, ListValueModel<? extends E> listHolder) {
        super(listHolder);
        this.prefix = new ArrayList<E>(prefix);
        this.suffix = Collections.emptyList();
    }

    public ExtendedListValueModelWrapper(E prefix, ListValueModel<? extends E> listHolder) {
        super(listHolder);
        this.prefix = Collections.singletonList(prefix);
        this.suffix = Collections.emptyList();
    }

    public ExtendedListValueModelWrapper(ListValueModel<? extends E> listHolder, List<? extends E> suffix) {
        super(listHolder);
        this.prefix = Collections.emptyList();
        this.suffix = new ArrayList<E>(suffix);
    }

    public ExtendedListValueModelWrapper(ListValueModel<? extends E> listHolder, E suffix) {
        super(listHolder);
        this.prefix = Collections.emptyList();
        this.suffix = Collections.singletonList(suffix);
    }

    public ExtendedListValueModelWrapper(ListValueModel<? extends E> listHolder) {
        super(listHolder);
        this.prefix = Collections.singletonList(null);
        this.suffix = Collections.emptyList();
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ReadOnlyListIterator<E>(this.listIterator_());
    }

    protected ListIterator<E> listIterator_() {
        return new ReadOnlyCompositeListIterator(this.prefix.listIterator(), this.listHolder.listIterator(), this.suffix.listIterator());
    }

    @Override
    public E get(int index) {
        int prefixSize = this.prefix.size();
        if (index < prefixSize) {
            return this.prefix.get(index);
        }
        if (index >= prefixSize + this.listHolder.size()) {
            return this.suffix.get(index - (prefixSize + this.listHolder.size()));
        }
        return this.listHolder.get(index - prefixSize);
    }

    @Override
    public int size() {
        return this.prefix.size() + this.listHolder.size() + this.suffix.size();
    }

    @Override
    public Object[] toArray() {
        ArrayList<E> list = new ArrayList<E>(this.size());
        list.addAll(this.prefix);
        CollectionTools.addAll(list, this.listHolder.iterator());
        list.addAll(this.suffix);
        return list.toArray();
    }

    @Override
    protected void itemsAdded(ListAddEvent event) {
        this.fireItemsAdded(event.clone(this, "list values", this.prefix.size()));
    }

    @Override
    protected void itemsRemoved(ListRemoveEvent event) {
        this.fireItemsRemoved(event.clone(this, "list values", this.prefix.size()));
    }

    @Override
    protected void itemsReplaced(ListReplaceEvent event) {
        this.fireItemsReplaced(event.clone(this, "list values", this.prefix.size()));
    }

    @Override
    protected void itemsMoved(ListMoveEvent event) {
        this.fireItemsMoved(event.clone(this, "list values", this.prefix.size()));
    }

    @Override
    protected void listCleared(ListClearEvent event) {
        this.fireListChanged("list values", this.buildList());
    }

    @Override
    protected void listChanged(ListChangeEvent event) {
        this.fireListChanged("list values", this.buildList());
    }

    @Override
    public void toString(StringBuilder sb) {
        StringTools.append(sb, this);
    }

    public void setPrefix(List<E> prefix) {
        this.prefix = prefix;
        this.fireListChanged("list values", this.buildList());
    }

    public void setSuffix(List<E> suffix) {
        this.suffix = suffix;
        this.fireListChanged("list values", this.buildList());
    }

    private List<E> buildList() {
        return CollectionTools.list(this.listIterator_());
    }
}

