/*
 * Decompiled with CFR 0.152.
 */
package com.werken.saxpath;

import com.werken.saxpath.DefaultXPathHandler;
import com.werken.saxpath.Token;
import com.werken.saxpath.TokenTypes;
import com.werken.saxpath.XPathLexer;
import java.util.LinkedList;
import org.saxpath.Axis;
import org.saxpath.SAXPathException;
import org.saxpath.XPathHandler;
import org.saxpath.XPathSyntaxException;

public class XPathReader
implements org.saxpath.XPathReader,
TokenTypes {
    private LinkedList tokens;
    private XPathLexer lexer;
    private XPathHandler handler;

    public XPathReader() {
        this.setXPathHandler(DefaultXPathHandler.getInstance());
    }

    public void setXPathHandler(XPathHandler xPathHandler) {
        this.handler = xPathHandler;
    }

    public XPathHandler getXPathHandler() {
        return this.handler;
    }

    public void parse(String string) throws SAXPathException {
        this.setUpParse(string);
        this.getXPathHandler().startXPath();
        this.expr();
        this.getXPathHandler().endXPath();
        if (this.LA(1) != -1) {
            this.throwUnexpected();
        }
        this.lexer = null;
        this.tokens = null;
    }

    void setUpParse(String string) {
        this.tokens = new LinkedList();
        this.lexer = new XPathLexer(string);
    }

    void pathExpr() throws SAXPathException {
        this.getXPathHandler().startPathExpr();
        switch (this.LA(1)) {
            case 1: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                this.filterExpr();
                if (this.LA(1) != 11 && this.LA(1) != 12) break;
                this.locationPath(false);
                break;
            }
            case 15: {
                if (this.LA(2) == 1 && !this.isNodeTypeName(this.LT(1))) {
                    this.filterExpr();
                    if (this.LA(1) != 11 && this.LA(1) != 12) break;
                    this.locationPath(false);
                    break;
                }
                this.locationPath(false);
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 20: {
                this.locationPath(false);
                break;
            }
            case 11: 
            case 12: {
                this.locationPath(true);
                break;
            }
            default: {
                this.throwUnexpected();
            }
        }
        this.getXPathHandler().endPathExpr();
    }

    void numberDouble() throws SAXPathException {
        Token token = this.match(31);
        this.getXPathHandler().number(Double.parseDouble(token.getTokenText()));
    }

    void numberInteger() throws SAXPathException {
        Token token = this.match(30);
        this.getXPathHandler().number(Integer.parseInt(token.getTokenText()));
    }

    void literal() throws SAXPathException {
        Token token = this.match(27);
        this.getXPathHandler().literal(token.getTokenText());
    }

    void functionCall() throws SAXPathException {
        String string = null;
        String string2 = null;
        if (this.LA(2) == 18) {
            string = this.match(15).getTokenText();
            this.match(18);
        } else {
            string = "";
        }
        string2 = this.match(15).getTokenText();
        this.getXPathHandler().startFunction(string, string2);
        this.match(1);
        this.arguments();
        this.match(2);
        this.getXPathHandler().endFunction();
    }

    void arguments() throws SAXPathException {
        while (this.LA(1) != 2) {
            this.expr();
            if (this.LA(1) != 32) break;
            this.match(32);
        }
    }

    void filterExpr() throws SAXPathException {
        this.getXPathHandler().startFilterExpr();
        switch (this.LA(1)) {
            case 30: {
                this.numberInteger();
                break;
            }
            case 31: {
                this.numberDouble();
                break;
            }
            case 27: {
                this.literal();
                break;
            }
            case 1: {
                this.match(1);
                this.expr();
                this.match(2);
                break;
            }
            case 15: {
                this.functionCall();
                break;
            }
            case 26: {
                this.variableReference();
            }
        }
        this.predicates();
        this.getXPathHandler().endFilterExpr();
    }

    void variableReference() throws SAXPathException {
        this.match(26);
        String string = null;
        String string2 = null;
        if (this.LA(2) == 18) {
            string = this.match(15).getTokenText();
            this.match(18);
        } else {
            string = "";
        }
        string2 = this.match(15).getTokenText();
        this.getXPathHandler().variableReference(string, string2);
    }

    void locationPath(boolean bl) throws SAXPathException {
        switch (this.LA(1)) {
            case 11: 
            case 12: {
                if (bl) {
                    this.absoluteLocationPath();
                    break;
                }
                this.relativeLocationPath();
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: {
                this.relativeLocationPath();
                break;
            }
            default: {
                this.throwUnexpected();
            }
        }
    }

    void absoluteLocationPath() throws SAXPathException {
        this.getXPathHandler().startAbsoluteLocationPath();
        block0 : switch (this.LA(1)) {
            case 11: {
                this.match(11);
                switch (this.LA(1)) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 20: {
                        this.steps();
                        break block0;
                    }
                    case -1: {
                        return;
                    }
                }
                break;
            }
            case 12: {
                this.getXPathHandler().startAllNodeStep(12);
                this.getXPathHandler().endAllNodeStep();
                this.match(12);
                switch (this.LA(1)) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 20: {
                        this.steps();
                    }
                }
            }
        }
        this.getXPathHandler().endAbsoluteLocationPath();
    }

    void relativeLocationPath() throws SAXPathException {
        this.getXPathHandler().startRelativeLocationPath();
        switch (this.LA(1)) {
            case 11: {
                this.match(11);
                break;
            }
            case 12: {
                this.getXPathHandler().startAllNodeStep(12);
                this.getXPathHandler().endAllNodeStep();
                this.match(12);
            }
        }
        this.steps();
        this.getXPathHandler().endRelativeLocationPath();
    }

    void steps() throws SAXPathException {
        switch (this.LA(1)) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: {
                this.step(true);
                break;
            }
            case -1: {
                return;
            }
            default: {
                this.throwSyntaxException("Expected one of '.', '..', '@', '*', <QName>");
            }
        }
        block11: while (true) {
            if (this.LA(1) == 11 || this.LA(1) == 12) {
                switch (this.LA(1)) {
                    case 11: {
                        this.match(11);
                        break;
                    }
                    case 12: {
                        this.getXPathHandler().startAllNodeStep(12);
                        this.getXPathHandler().endAllNodeStep();
                        this.match(12);
                    }
                }
            } else {
                return;
            }
            switch (this.LA(1)) {
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 20: {
                    this.step(false);
                    continue block11;
                }
            }
            this.throwSyntaxException("Expected one of '.', '..', '@', '*', <QName>");
        }
    }

    void step(boolean bl) throws SAXPathException {
        int n = 0;
        switch (this.LA(1)) {
            case 13: 
            case 14: {
                this.abbrStep();
                return;
            }
            case 16: {
                n = this.axisSpecifier();
                break;
            }
            case 15: {
                if (this.LA(2) == 19) {
                    n = this.axisSpecifier();
                    break;
                }
                n = 1;
                break;
            }
            case 20: {
                n = 1;
            }
        }
        this.nodeTest(n);
    }

    int axisSpecifier() throws SAXPathException {
        int n = 0;
        switch (this.LA(1)) {
            case 16: {
                this.match(16);
                n = 9;
                break;
            }
            case 15: {
                Token token = this.LT(1);
                n = Axis.lookup(token.getTokenText());
                if (n == 0) {
                    this.throwInvalidAxis(token.getTokenText());
                }
                this.match(15);
                this.match(19);
            }
        }
        return n;
    }

    void nodeTest(int n) throws SAXPathException {
        block0 : switch (this.LA(1)) {
            case 15: {
                switch (this.LA(2)) {
                    case 1: {
                        this.nodeTypeTest(n);
                        break block0;
                    }
                }
                this.nameTest(n);
                break;
            }
            case 20: {
                this.nameTest(n);
            }
        }
    }

    void nodeTypeTest(int n) throws SAXPathException {
        Token token = this.match(15);
        String string = token.getTokenText();
        this.match(1);
        if ("processing-instruction".equals(string)) {
            String string2 = "";
            if (this.LA(1) == 27) {
                string2 = this.match(27).getTokenText();
            }
            this.match(2);
            this.getXPathHandler().startProcessingInstructionNodeStep(n, string2);
            this.predicates();
            this.getXPathHandler().endProcessingInstructionNodeStep();
        } else if ("node".equals(string)) {
            this.match(2);
            this.getXPathHandler().startAllNodeStep(n);
            this.predicates();
            this.getXPathHandler().endAllNodeStep();
        } else if ("text".equals(string)) {
            this.match(2);
            this.getXPathHandler().startTextNodeStep(n);
            this.predicates();
            this.getXPathHandler().endTextNodeStep();
        } else if ("comment".equals(string)) {
            this.match(2);
            this.getXPathHandler().startCommentNodeStep(n);
            this.predicates();
            this.getXPathHandler().endCommentNodeStep();
        } else {
            this.throwSyntaxException("Expected node-type");
        }
    }

    void nameTest(int n) throws SAXPathException {
        String string = null;
        String string2 = null;
        switch (this.LA(2)) {
            case 18: {
                switch (this.LA(1)) {
                    case 15: {
                        string = this.match(15).getTokenText();
                        this.match(18);
                    }
                }
            }
        }
        switch (this.LA(1)) {
            case 15: {
                string2 = this.match(15).getTokenText();
                break;
            }
            case 20: {
                this.match(20);
                string2 = "*";
            }
        }
        if (string == null) {
            string = "";
        }
        this.getXPathHandler().startNameStep(n, string, string2);
        this.predicates();
        this.getXPathHandler().endNameStep();
    }

    void abbrStep() throws SAXPathException {
        switch (this.LA(1)) {
            case 13: {
                this.match(13);
                this.getXPathHandler().startAllNodeStep(11);
                this.predicates();
                this.getXPathHandler().endAllNodeStep();
                break;
            }
            case 14: {
                this.match(14);
                this.getXPathHandler().startAllNodeStep(3);
                this.predicates();
                this.getXPathHandler().endAllNodeStep();
            }
        }
    }

    void predicates() throws SAXPathException {
        while (this.LA(1) == 3) {
            this.predicate();
        }
    }

    void predicate() throws SAXPathException {
        this.getXPathHandler().startPredicate();
        this.match(3);
        this.predicateExpr();
        this.match(4);
        this.getXPathHandler().endPredicate();
    }

    void predicateExpr() throws SAXPathException {
        this.expr();
    }

    void expr() throws SAXPathException {
        this.orExpr();
    }

    void orExpr() throws SAXPathException {
        this.getXPathHandler().startOrExpr();
        this.andExpr();
        boolean bl = false;
        switch (this.LA(1)) {
            case 29: {
                bl = true;
                this.match(29);
                this.orExpr();
            }
        }
        this.getXPathHandler().endOrExpr(bl);
    }

    void andExpr() throws SAXPathException {
        this.getXPathHandler().startAndExpr();
        this.equalityExpr();
        boolean bl = false;
        switch (this.LA(1)) {
            case 28: {
                bl = true;
                this.match(28);
                this.andExpr();
            }
        }
        this.getXPathHandler().endAndExpr(bl);
    }

    void equalityExpr() throws SAXPathException {
        this.getXPathHandler().startEqualityExpr();
        this.relationalExpr();
        int n = 0;
        switch (this.LA(1)) {
            case 21: {
                this.match(21);
                this.equalityExpr();
                n = 1;
                break;
            }
            case 22: {
                this.match(22);
                this.equalityExpr();
                n = 2;
            }
        }
        this.getXPathHandler().endEqualityExpr(n);
    }

    void relationalExpr() throws SAXPathException {
        this.getXPathHandler().startRelationalExpr();
        this.additiveExpr();
        int n = 0;
        switch (this.LA(1)) {
            case 7: {
                this.match(7);
                this.relationalExpr();
                n = 3;
                break;
            }
            case 9: {
                this.match(9);
                this.relationalExpr();
                n = 5;
                break;
            }
            case 8: {
                this.match(8);
                this.relationalExpr();
                n = 4;
                break;
            }
            case 10: {
                this.match(10);
                this.relationalExpr();
                n = 6;
            }
        }
        this.getXPathHandler().endRelationalExpr(n);
    }

    void additiveExpr() throws SAXPathException {
        this.getXPathHandler().startAdditiveExpr();
        this.multiplicativeExpr();
        int n = 0;
        switch (this.LA(1)) {
            case 5: {
                this.match(5);
                n = 7;
                this.additiveExpr();
                break;
            }
            case 6: {
                this.match(6);
                n = 8;
                this.additiveExpr();
            }
        }
        this.getXPathHandler().endAdditiveExpr(n);
    }

    void multiplicativeExpr() throws SAXPathException {
        this.getXPathHandler().startMultiplicativeExpr();
        this.unaryExpr();
        int n = 0;
        switch (this.LA(1)) {
            case 20: {
                this.match(20);
                this.multiplicativeExpr();
                n = 9;
                break;
            }
            case 24: {
                this.match(24);
                this.multiplicativeExpr();
                n = 11;
                break;
            }
            case 25: {
                this.match(25);
                this.multiplicativeExpr();
                n = 10;
            }
        }
        this.getXPathHandler().endMultiplicativeExpr(n);
    }

    void unaryExpr() throws SAXPathException {
        this.getXPathHandler().startUnaryExpr();
        int n = 0;
        switch (this.LA(1)) {
            case 6: {
                this.match(6);
                n = 12;
                this.unaryExpr();
                break;
            }
            default: {
                this.unionExpr();
            }
        }
        this.getXPathHandler().endUnaryExpr(n);
    }

    void unionExpr() throws SAXPathException {
        this.getXPathHandler().startUnionExpr();
        this.pathExpr();
        boolean bl = false;
        switch (this.LA(1)) {
            case 17: {
                this.match(17);
                bl = true;
                this.expr();
            }
        }
        this.getXPathHandler().endUnionExpr(bl);
    }

    Token match(int n) {
        this.LT(1);
        Token token = (Token)this.tokens.get(0);
        if (token.getTokenType() == n) {
            this.tokens.removeFirst();
            return token;
        }
        return null;
    }

    int LA(int n) {
        return this.LT(n).getTokenType();
    }

    Token LT(int n) {
        if (this.tokens.size() <= n - 1) {
            int n2 = 0;
            while (n2 < n) {
                this.tokens.add(this.lexer.nextToken());
                ++n2;
            }
        }
        return (Token)this.tokens.get(n - 1);
    }

    boolean isNodeTypeName(Token token) {
        String string = token.getTokenText();
        return "node".equals(string) || "comment".equals(string) || "text".equals(string) || "processing-instruction".equals(string);
    }

    void throwSyntaxException(String string) throws SAXPathException {
        String string2 = this.lexer.getXPath();
        int n = this.LT(1).getTokenBegin();
        throw new XPathSyntaxException(string2, n, string);
    }

    void throwInvalidAxis(String string) throws SAXPathException {
        String string2 = this.lexer.getXPath();
        int n = this.LT(1).getTokenBegin();
        String string3 = "Expected valid axis name instead of [" + string + "]";
        throw new XPathSyntaxException(string2, n, string3);
    }

    void throwUnexpected() throws SAXPathException {
        this.throwSyntaxException("Unexpected '" + this.LT(1).getTokenText() + "'");
    }
}

