/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ui;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.ui.ExternalToolsUIMessages;

public class ExternalToolsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button promptForToolMigrationButton;
    private Button promptForProjectMigrationButton;

    public ExternalToolsPreferencePage() {
        this.setPreferenceStore(ExternalToolsPlugin.getDefault().getPreferenceStore());
        this.setDescription(ExternalToolsUIMessages.ExternalToolsPreferencePage_External_tool_project_builders_migration_2);
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.externaltools.preference_page_context");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        this.promptForToolMigrationButton = this.createCheckButton(composite, ExternalToolsUIMessages.ExternalToolsPreferencePage_Prompt_before_migrating_3, "externaltools.builders.promptForMigration");
        this.promptForProjectMigrationButton = this.createCheckButton(composite, ExternalToolsUIMessages.ExternalToolsPreferencePage_1, "externaltools.builders.promptForProjectMigration");
        this.applyDialogFont(composite);
        return composite;
    }

    private Button createCheckButton(Composite parent, String label, String preferenceKey) {
        Button button = new Button(parent, 16416);
        button.setLayoutData((Object)new GridData(32));
        button.setFont(parent.getFont());
        button.setText(label);
        button.setSelection(this.getPreferenceStore().getBoolean(preferenceKey));
        return button;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("externaltools.builders.promptForMigration", this.promptForToolMigrationButton.getSelection());
        this.getPreferenceStore().setValue("externaltools.builders.promptForProjectMigration", this.promptForProjectMigrationButton.getSelection());
        return super.performOk();
    }

    protected void performDefaults() {
        this.promptForToolMigrationButton.setSelection(this.getPreferenceStore().getDefaultBoolean("externaltools.builders.promptForMigration"));
        this.promptForToolMigrationButton.setSelection(this.getPreferenceStore().getDefaultBoolean("externaltools.builders.promptForProjectMigration"));
        super.performDefaults();
    }
}

