/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.xerces.util.SecuritySupport;

public class ObjectFactory {
    private static final String DEFAULT_PROPERTIES_FILENAME = "xerces.properties";
    private static final boolean DEBUG = false;
    private static Properties fXercesProperties = null;
    private static long fLastModified = -1L;
    static /* synthetic */ Class class$0;

    public static Object createObject(String string, String string2) throws ConfigurationError {
        return ObjectFactory.createObject(string, null, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object createObject(String string, String string2, String string3) throws ConfigurationError {
        Object object;
        String string4;
        ObjectFactory.debugPrintln("debug is on");
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        ClassLoader classLoader = ObjectFactory.findClassLoader();
        try {
            string4 = securitySupport.getSystemProperty(string);
            if (string4 != null) {
                ObjectFactory.debugPrintln("found system property, value=" + string4);
                return ObjectFactory.newInstance(string4, classLoader, true);
            }
        }
        catch (SecurityException securityException) {}
        string4 = null;
        if (string2 == null) {
            Class<?> clazz;
            Object object2;
            object = null;
            boolean bl = false;
            try {
                object2 = securitySupport.getSystemProperty("java.home");
                string2 = String.valueOf(object2) + File.separator + "lib" + File.separator + DEFAULT_PROPERTIES_FILENAME;
                object = new File(string2);
                bl = securitySupport.getFileExists((File)object);
            }
            catch (SecurityException securityException) {
                fLastModified = -1L;
                fXercesProperties = null;
            }
            if ((clazz = class$0) == null) {
                try {
                    clazz = class$0 = Class.forName("org.apache.xerces.util.ObjectFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            object2 = clazz;
            synchronized (clazz) {
                boolean bl2 = false;
                try {
                    if (fLastModified >= 0L) {
                        if (bl && fLastModified < (fLastModified = securitySupport.getLastModified((File)object))) {
                            bl2 = true;
                        } else if (!bl) {
                            fLastModified = -1L;
                            fXercesProperties = null;
                        }
                    } else if (bl) {
                        bl2 = true;
                        fLastModified = securitySupport.getLastModified((File)object);
                    }
                    if (bl2) {
                        fXercesProperties = new Properties();
                        FileInputStream fileInputStream = securitySupport.getFileInputStream((File)object);
                        fXercesProperties.load(fileInputStream);
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    fXercesProperties = null;
                    fLastModified = -1L;
                }
                if (fXercesProperties != null) {
                    string4 = fXercesProperties.getProperty(string);
                }
            }
        } else {
            try {
                object = securitySupport.getFileInputStream(new File(string2));
                Properties properties = new Properties();
                properties.load((InputStream)object);
                ((FileInputStream)object).close();
                string4 = properties.getProperty(string);
            }
            catch (Exception exception) {}
        }
        {
            if (string4 != null) {
                ObjectFactory.debugPrintln("found in " + string2 + ", value=" + string4);
                return ObjectFactory.newInstance(string4, classLoader, true);
            }
            object = ObjectFactory.findJarServiceProvider(string);
            if (object != null) {
                return object;
            }
            if (string3 == null) {
                throw new ConfigurationError("Provider for " + string + " cannot be found", null);
            }
            ObjectFactory.debugPrintln("using fallback, value=" + string3);
            return ObjectFactory.newInstance(string3, classLoader, true);
        }
    }

    private static void debugPrintln(String string) {
    }

    public static ClassLoader findClassLoader() throws ConfigurationError {
        ClassLoader classLoader;
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        ClassLoader classLoader2 = securitySupport.getContextClassLoader();
        ClassLoader classLoader3 = classLoader = securitySupport.getSystemClassLoader();
        while (true) {
            if (classLoader2 == classLoader3) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.apache.xerces.util.ObjectFactory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ClassLoader classLoader4 = clazz.getClassLoader();
                classLoader3 = classLoader;
                while (true) {
                    if (classLoader4 == classLoader3) {
                        return classLoader;
                    }
                    if (classLoader3 == null) break;
                    classLoader3 = securitySupport.getParentClassLoader(classLoader3);
                }
                return classLoader4;
            }
            if (classLoader3 == null) break;
            classLoader3 = securitySupport.getParentClassLoader(classLoader3);
        }
        return classLoader2;
    }

    public static Object newInstance(String string, ClassLoader classLoader, boolean bl) throws ConfigurationError {
        try {
            Class clazz = ObjectFactory.findProviderClass(string, classLoader, bl);
            Object t = clazz.newInstance();
            ObjectFactory.debugPrintln("created new instance of " + clazz + " using ClassLoader: " + classLoader);
            return t;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    public static Class findProviderClass(String string, ClassLoader classLoader, boolean bl) throws ClassNotFoundException, ConfigurationError {
        Class<?> clazz;
        if (classLoader == null) {
            clazz = Class.forName(string);
        } else {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl) {
                    ClassLoader classLoader2;
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.apache.xerces.util.ObjectFactory");
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            throw new NoClassDefFoundError(classNotFoundException2.getMessage());
                        }
                    }
                    if ((classLoader2 = clazz2.getClassLoader()) == null) {
                        clazz = Class.forName(string);
                    }
                    if (classLoader != classLoader2) {
                        classLoader = classLoader2;
                        clazz = classLoader.loadClass(string);
                    }
                    throw classNotFoundException;
                }
                throw classNotFoundException;
            }
        }
        return clazz;
    }

    private static Object findJarServiceProvider(String string) throws ConfigurationError {
        Object object;
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        String string2 = "META-INF/services/" + string;
        InputStream inputStream = null;
        ClassLoader classLoader = ObjectFactory.findClassLoader();
        inputStream = securitySupport.getResourceAsStream(classLoader, string2);
        if (inputStream == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.apache.xerces.util.ObjectFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (classLoader != (object = clazz.getClassLoader())) {
                classLoader = object;
                inputStream = securitySupport.getResourceAsStream(classLoader, string2);
            }
        }
        if (inputStream == null) {
            return null;
        }
        ObjectFactory.debugPrintln("found jar resource=" + string2 + " using ClassLoader: " + classLoader);
        try {
            object = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new BufferedReader(new InputStreamReader(inputStream));
        }
        String string3 = null;
        try {
            string3 = ((BufferedReader)object).readLine();
            ((BufferedReader)object).close();
        }
        catch (IOException iOException) {
            return null;
        }
        if (string3 != null && !"".equals(string3)) {
            ObjectFactory.debugPrintln("found in resource, value=" + string3);
            return ObjectFactory.newInstance(string3, classLoader, false);
        }
        return null;
    }

    public static class ConfigurationError
    extends Error {
        private Exception exception;

        public ConfigurationError(String string, Exception exception) {
            super(string);
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

