/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.internal.ccvs.core.EditorsInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class EditorsView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipse.team.ccvs.ui.EditorsView";
    private Table table;
    private TableViewer tableViewer;

    public void createPartControl(Composite parent) {
        this.table = new Table(parent, 66304);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 500;
        gridData.heightHint = 100;
        this.table.setLayoutData((Object)gridData);
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(this.table);
        this.createColumns(this.table, layout);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new EditorsLabelProvider());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.tableViewer.getControl(), "org.eclipse.team.cvs.ui.cvs_editors_view_context");
    }

    public void setInput(EditorsInfo[] infos) {
        this.tableViewer.setInput((Object)infos);
    }

    private void createColumns(Table table, TableLayout layout) {
        SelectionListener headerListener = this.getColumnListener(this.tableViewer);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(CVSUIMessages.EditorsView_file);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        col.addSelectionListener(headerListener);
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(CVSUIMessages.EditorsView_user);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col.addSelectionListener(headerListener);
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(CVSUIMessages.EditorsView_date);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        col.addSelectionListener(headerListener);
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(CVSUIMessages.EditorsView_computer);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col.addSelectionListener(headerListener);
    }

    private SelectionListener getColumnListener(final TableViewer tableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableColumn tableColumn = (TableColumn)e.widget;
                int column = tableViewer.getTable().indexOf(tableColumn);
                EditorsComparator oldSorter = (EditorsComparator)tableViewer.getComparator();
                if (oldSorter != null && column == oldSorter.getColumnNumber()) {
                    oldSorter.setReversed(!oldSorter.isReversed());
                    tableViewer.getTable().setSortColumn(tableColumn);
                    tableViewer.getTable().setSortDirection(oldSorter.isReversed() ? 1024 : 128);
                    tableViewer.refresh();
                } else {
                    tableViewer.getTable().setSortColumn(tableColumn);
                    tableViewer.getTable().setSortDirection(128);
                    tableViewer.setComparator((ViewerComparator)new EditorsComparator(column));
                }
            }
        };
    }

    public void setFocus() {
        if (this.table != null) {
            this.table.setFocus();
        }
    }

    public Table getTable() {
        return this.table;
    }

    class EditorsComparator
    extends ViewerComparator {
        private int column;
        private boolean reversed;
        private DateFormat[] dateFormats = new DateFormat[]{new SimpleDateFormat("dd MMM yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("dd MMM yyyy HH:mm:ss z"), new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy z")};

        public EditorsComparator(int column) {
            this.column = column;
        }

        public int getColumnNumber() {
            return this.column;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public void setReversed(boolean reversed) {
            this.reversed = reversed;
        }

        public int compare(Viewer compareViewer, Object o1, Object o2) {
            int result = 0;
            if (o1 instanceof EditorsInfo && o2 instanceof EditorsInfo) {
                EditorsInfo ei1 = (EditorsInfo)o1;
                EditorsInfo ei2 = (EditorsInfo)o2;
                switch (this.column) {
                    case 0: {
                        result = this.compareStrings(ei1.getFileName(), ei2.getFileName());
                        break;
                    }
                    case 1: {
                        result = this.compareStrings(ei1.getUserName(), ei2.getUserName());
                        break;
                    }
                    case 2: {
                        result = this.compareDates(ei1.getDateString(), ei2.getDateString());
                        break;
                    }
                    case 3: {
                        result = this.compareStrings(ei1.getComputerName(), ei2.getComputerName());
                    }
                }
                if (this.reversed) {
                    result = -result;
                }
            }
            return result;
        }

        private int compareStrings(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            return this.getComparator().compare(s1, s2);
        }

        private int compareDates(String s1, String s2) {
            long date2;
            long date1 = this.extractDate(s1);
            if (date1 == (date2 = this.extractDate(s2))) {
                return 0;
            }
            if (date1 == -1L) {
                return -1;
            }
            if (date2 == -1L) {
                return 1;
            }
            return date1 > date2 ? 1 : -1;
        }

        private long extractDate(String dateString) {
            if (dateString != null) {
                int i = 0;
                while (i < this.dateFormats.length) {
                    this.dateFormats[i].setLenient(true);
                    try {
                        return this.dateFormats[i].parse(dateString).getTime();
                    }
                    catch (ParseException parseException) {
                        ++i;
                    }
                }
            }
            return -1L;
        }
    }

    class EditorsLabelProvider
    implements ITableLabelProvider {
        EditorsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == null) {
                return "";
            }
            EditorsInfo info = (EditorsInfo)element;
            String result = null;
            switch (columnIndex) {
                case 0: {
                    result = info.getFileName();
                    break;
                }
                case 1: {
                    result = info.getUserName();
                    break;
                }
                case 2: {
                    result = info.getDateString();
                    break;
                }
                case 3: {
                    result = info.getComputerName();
                }
            }
            if (result == null) {
                result = "";
            }
            return result;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

