/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench.integration;

import java.io.FileNotFoundException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;
import org.eclipse.wst.common.internal.emfworkbench.PassthruResourceSet;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class EMFWorkbenchEditPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.wst.common.emfworkbench.integration";
    public static final String ID = "org.eclipse.wst.common.emfworkbench.integration";
    public static final String EDIT_MODEL_FACTORIES_EXTENSION_POINT = "editModel";
    public static final String EDIT_MODEL_EXTENSION_REGISTRY_EXTENSION_POINT = "editModelExtension";
    public static final String ADAPTER_FACTORY_REGISTRY_EXTENSION_POINT = "adapterFactory";
    private static EMFWorkbenchEditPlugin plugin;

    public EMFWorkbenchEditPlugin() {
        plugin = this;
    }

    public static EMFWorkbenchEditPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ExtendedEcoreUtil.setFileNotFoundDetector((ExtendedEcoreUtil.FileNotFoundDetector)new ExtendedEcoreUtil.FileNotFoundDetector(){

            public boolean isFileNotFound(WrappedException wrappedEx) {
                return WorkbenchResourceHelperBase.isResourceNotFound((WrappedException)wrappedEx) || wrappedEx.exception() instanceof FileNotFoundException;
            }
        });
        WorkbenchResourceHelper.initializeFileAdapterFactory();
    }

    public static ResourceSet createIsolatedResourceSet(IProject project) {
        return new PassthruResourceSet(project);
    }

    public static ResourceSet createWorkspacePassthruResourceSet() {
        return new PassthruResourceSet();
    }

    public static IStatus createStatus(int severity, String message, Throwable exception) {
        return new Status(severity, "org.eclipse.wst.common.emfworkbench.integration", message, exception);
    }

    public static IStatus createStatus(int severity, String message) {
        return EMFWorkbenchEditPlugin.createStatus(severity, message, null);
    }

    public static void logError(Throwable exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.wst.common.emfworkbench.integration")).log(EMFWorkbenchEditPlugin.createStatus(4, exception.getMessage(), exception));
    }

    public static void logError(CoreException exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.wst.common.emfworkbench.integration")).log(exception.getStatus());
    }

    public static void logWarning(String message) {
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.wst.common.emfworkbench.integration")).log(EMFWorkbenchEditPlugin.createStatus(2, message));
    }

    public static void logWarning(Throwable exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.wst.common.emfworkbench.integration")).log(EMFWorkbenchEditPlugin.createStatus(2, exception.getMessage(), exception));
    }

    public static void logError(String message) {
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.wst.common.emfworkbench.integration")).log(EMFWorkbenchEditPlugin.createStatus(4, message));
    }
}

