/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer.editor;

import aurora.ide.meta.gef.designer.DataType;
import aurora.ide.meta.gef.designer.DesignerMessages;
import aurora.ide.meta.gef.designer.IDesignerConst;
import aurora.ide.meta.gef.designer.editor.BMModelCellModifier;
import aurora.ide.meta.gef.designer.editor.BMModelContentProvider;
import aurora.ide.meta.gef.designer.editor.BMModelLabelProvider;
import aurora.ide.meta.gef.designer.editor.ComboBoxCellEditor;
import aurora.ide.meta.gef.designer.editor.RecordCellEditorListener;
import aurora.ide.meta.gef.designer.model.Record;
import aurora.ide.meta.gef.editors.property.BooleanCellEditor;
import aurora.ide.meta.gef.editors.property.StringCellEditor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBMModelViewer
extends TableViewer
implements IDesignerConst {
    String[] properties = new String[]{"", "no.", "prompt", "name"};
    CellEditor[] editors = new CellEditor[4];
    private Table table;
    private String mode = null;
    private HashMap<String, String[]> operatorsMap = new HashMap();

    public SimpleBMModelViewer(Composite parent, int style) {
        super(parent, style);
        this.table = this.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn zColumn = new TableColumn(this.table, 0);
        zColumn.setResizable(false);
        zColumn.setWidth(0);
        zColumn.setMoveable(false);
        TableColumn column = new TableColumn(this.table, 0x1000000);
        column.setText("NO.");
        column.pack();
        column.setMoveable(false);
        column.setResizable(false);
        column = new TableColumn(this.table, 0x1000000);
        column.setText("Prompt");
        column.pack();
        column = new TableColumn(this.table, 0x1000000);
        column.setText("Name");
        column.setWidth(80);
        this.setColumnProperties(this.properties);
        this.setContentProvider((IContentProvider)new BMModelContentProvider(0));
        this.setLabelProvider((IBaseLabelProvider)new BMModelLabelProvider(0, this.properties));
        this.setCellModifier(new BMModelCellModifier(this, 0));
        this.setCellEditors(this.editors);
    }

    public void setDisplayMode(String mode) {
        if (this.mode != null) {
            return;
        }
        this.mode = mode;
        if ("lov".equals(mode)) {
            TableColumn column = new TableColumn(this.table, 0x1000000);
            column.setText("Use in Lov");
            column.pack();
            column = new TableColumn(this.table, 0x1000000);
            column.setText("For Query");
            column.pack();
            column = new TableColumn(this.table, 0x1000000);
            column.setText("For Display");
            column.pack();
            this.properties = this.expand(this.properties, "forLov", "forQuery", "forDisplay");
            this.editors = this.expand(this.editors, new CellEditor[]{new BooleanCellEditor((Composite)this.table), new BooleanCellEditor((Composite)this.table), new BooleanCellEditor((Composite)this.table)});
        } else if ("maintain".equals(mode)) {
            TableColumn column = new TableColumn(this.table, 0x1000000);
            column.setText("For Insert");
            column.pack();
            column = new TableColumn(this.table, 0x1000000);
            column.setText("For Update");
            column.pack();
            column = new TableColumn(this.table, 0x1000000);
            column.setText("Insert Expression");
            column.pack();
            column = new TableColumn(this.table, 0x1000000);
            column.setText("Update Expression");
            column.pack();
            this.properties = this.expand(this.properties, "forInsert", "forUpdate", "insertExpression", "updateExpression");
            this.editors = this.expand(this.editors, new CellEditor[]{new BooleanCellEditor((Composite)this.table), new BooleanCellEditor((Composite)this.table), new StringCellEditor((Composite)this.table), new StringCellEditor((Composite)this.table)});
        } else if ("query".equals(mode)) {
            TableColumn column = new TableColumn(this.table, 0x1000000);
            column.setText(DesignerMessages.BMModelViewer_5);
            column.pack();
            column = new TableColumn(this.table, 0x1000000);
            column.setText(DesignerMessages.BMModelViewer_6);
            column.setWidth(110);
            this.properties = this.expand(this.properties, "queryfield", "query_op");
            this.editors = this.expand(this.editors, new CellEditor[]{new BooleanCellEditor((Composite)this.table), new ComboBoxCellEditor((Composite)this.table, OPERATORS)});
        }
        this.setColumnProperties(this.properties);
        this.setLabelProvider((IBaseLabelProvider)new BMModelLabelProvider(0, this.properties));
        this.setCellEditors(this.editors);
        this.refresh();
    }

    private <T> T[] expand(T[] arr, T ... values) {
        Object[] newArr = (Object[])Array.newInstance(arr.getClass().getComponentType(), arr.length + values.length);
        System.arraycopy(arr, 0, newArr, 0, arr.length);
        System.arraycopy(values, 0, newArr, arr.length, values.length);
        return newArr;
    }

    public void refresh() {
        super.refresh();
        int i = 0;
        while (i < this.table.getItemCount()) {
            TableItem item = this.table.getItem(i);
            Record rec = (Record)item.getData();
            int j = 0;
            while (j < this.editors.length) {
                CellEditor ce;
                if (this.editors[j] != null && (ce = this.createCellEditor((Composite)this.table, rec, this.properties[j], this.editors[j].getClass())) != null) {
                    TableEditor te = new TableEditor(this.table);
                    te.horizontalAlignment = 16384;
                    te.grabHorizontal = true;
                    te.setEditor(ce.getControl(), item, j);
                    ce.setValue(rec.get(this.properties[j]));
                }
                ++j;
            }
            ++i;
        }
    }

    private CellEditor createCellEditor(Composite parent, Record record, String property, Class<? extends CellEditor> type) {
        CellEditor ce = null;
        if (type.equals(StringCellEditor.class)) {
            ce = new StringCellEditor(parent);
        } else if (type.equals(BooleanCellEditor.class)) {
            ce = new BooleanCellEditor(parent);
        } else if (type.equals(ComboBoxCellEditor.class) && property.equals("query_op")) {
            String[] ss = this.getOperators(record == null ? "" : record.getType());
            ce = new ComboBoxCellEditor(parent, ss);
        }
        if (ce != null) {
            ce.addListener((ICellEditorListener)new RecordCellEditorListener(record, property, ce));
        }
        return ce;
    }

    private String[] getOperators(String displayType) {
        String[] ss = this.operatorsMap.get(displayType);
        if (ss == null) {
            DataType dt = DataType.fromString(displayType);
            if (dt == null) {
                return new String[0];
            }
            ArrayList<String> ops = new ArrayList<String>();
            ops.add("=");
            switch (dt) {
                case INTEGER: 
                case FLOAT: {
                    ops.add(">");
                    ops.add("<");
                    ops.add(">=");
                    ops.add("<=");
                }
                case DATE: 
                case DATE_TIME: {
                    ops.add(OP_INTERVAL);
                    break;
                }
                case TEXT: 
                case LONG_TEXT: {
                    ops.add("like");
                    ops.add(OP_PRE_MATCH);
                    ops.add(OP_END_MATCH);
                    ops.add(OP_ANY_MATCH);
                }
            }
            ss = new String[ops.size()];
            ops.toArray(ss);
            this.operatorsMap.put(displayType, ss);
        }
        return ss;
    }
}

