/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.figures;

import aurora.ide.meta.gef.editors.ImagesUtils;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.figures.DummyLayout;
import aurora.ide.meta.gef.editors.figures.FigureUtil;
import aurora.ide.meta.gef.editors.figures.GridColumnBorder;
import aurora.ide.meta.gef.editors.models.GridColumn;
import aurora.ide.meta.gef.editors.models.Renderer;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class GridColumnFigure
extends Figure {
    private static Image checkImg = ImagesUtils.getImage("palette/checkbox_01.png");
    private int labelWidth;
    private int columnHight = 25;
    private GridColumn gridColumn;

    public GridColumnFigure() {
        this.setLayoutManager((LayoutManager)new DummyLayout());
        this.setBorder((Border)new GridColumnBorder("prompt", "grid_bg", this));
    }

    public int getLabelWidth() {
        return this.labelWidth;
    }

    public void setLabelWidth(int labelWidth) {
        this.labelWidth = labelWidth;
    }

    public void handleFocusGained(FocusEvent event) {
        super.handleFocusGained(event);
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle copy = this.getBounds().getCopy();
        Rectangle firstCellRect = copy.getTranslated(0, this.columnHight).setHeight(this.gridColumn.getRowHight());
        if (this.getChildren().size() > 0) {
            return;
        }
        int k = 1;
        int i = copy.y + this.columnHight;
        while (i < copy.y + copy.height) {
            if (k % 2 == 0) {
                graphics.setBackgroundColor(ColorConstants.GRID_ROW);
                graphics.fillRectangle(copy.x, i, copy.width, 25);
            }
            graphics.setForegroundColor(ColorConstants.GRID_COLUMN_GRAY);
            graphics.drawLine(copy.x, i, copy.x + copy.width, i);
            ++k;
            i += 25;
        }
        String editor = this.gridColumn.getEditor();
        if (editor == null || editor.length() == 0) {
            this.paintEffectForRenderer(graphics, this.gridColumn.getRenderer(), firstCellRect);
            return;
        }
        if ("checkBox".equals(editor)) {
            FigureUtil.paintImageAtCenter(graphics, firstCellRect, checkImg);
            return;
        }
        graphics.setBackgroundColor(ColorConstants.WHITE);
        if (this.gridColumn.getDatasetField().isRequired()) {
            graphics.setBackgroundColor(ColorConstants.REQUIRED_BG);
        }
        if (this.gridColumn.getDatasetField().isReadOnly()) {
            graphics.setBackgroundColor(ColorConstants.READONLY_BG);
        }
        Rectangle rect = firstCellRect.getShrinked(2, 2).translate(-1, 0);
        graphics.fillRectangle(rect);
        graphics.setForegroundColor(ColorConstants.GRID_COLUMN_GRAY);
        graphics.drawRectangle(rect);
        Image img = this.getImageOfEditor(editor);
        if (img != null) {
            rect.x += rect.width - rect.height;
            rect.width = rect.height;
            FigureUtil.paintImageAtCenter(graphics, rect, img);
        }
    }

    private Image getImageOfEditor(String editor) {
        if ("comboBox".equals(editor)) {
            return ImagesUtils.getImage("palette/itembar_01.png");
        }
        if ("datePicker".equals(editor) || "dateTimePicker".equals(editor)) {
            return ImagesUtils.getImage("palette/itembar_02.png");
        }
        if ("lov".equals(editor)) {
            return ImagesUtils.getImage("palette/itembar_03.png");
        }
        if ("textField".equals(editor)) {
            return ImagesUtils.getImage("palette/itembar_04.png");
        }
        if ("numberField".equals(editor)) {
            return ImagesUtils.getImage("palette/itembar_05.png");
        }
        return null;
    }

    private void paintEffectForRenderer(Graphics g, Renderer renderer, Rectangle rect) {
        if (renderer == null) {
            return;
        }
        String rendererType = renderer.getRendererType();
        if ("PAGE_REDIRECT".equals(rendererType)) {
            boolean u;
            String text = renderer.getDescripition();
            g.setForegroundColor(ColorConstants.LINK_COLOR);
            String lt = text.toLowerCase();
            int idx1 = lt.indexOf("<u>");
            int idx2 = lt.indexOf("</u>");
            boolean bl = u = idx1 + idx2 > 0;
            if (u) {
                text = text.substring(idx1 + 3, idx2);
            }
            FigureUtil.paintTextAtCenter(g, rect, text, u);
        } else if ("USER_FUNCTION".equals(rendererType)) {
            Image fxImg = ImagesUtils.getImage("palette/fx.png");
            FigureUtil.paintImageAtCenter(g, rect, fxImg);
        }
    }

    public void setModel(GridColumn component) {
        this.gridColumn = component;
    }

    public String getPrompt() {
        return this.gridColumn.getPrompt();
    }

    public int getColumnHight() {
        return this.columnHight;
    }

    public void setColumnHight(int columnHight) {
        this.columnHight = columnHight;
        if (this.gridColumn != null) {
            this.gridColumn.setHeadHight(columnHight);
        }
    }
}

