/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.figures;

import aurora.ide.meta.gef.editors.ImagesUtils;
import aurora.ide.meta.gef.editors.figures.BoxFigure;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.models.Input;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class InputField
extends Figure {
    private Input model = null;

    public void setModel(Input model) {
        this.model = model;
        this.setToolTip((IFigure)new Label(model.getType()));
    }

    public int getLabelWidth() {
        IFigure parent = this.getParent();
        if (parent instanceof BoxFigure) {
            return ((BoxFigure)parent).getLabelWidth();
        }
        return 80;
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
    }

    public void handleFocusGained(FocusEvent event) {
        super.handleFocusGained(event);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        String prompt = String.valueOf(this.model.getPrompt()) + " : ";
        Dimension textExtents = FigureUtilities.getTextExtents((String)prompt, (Font)this.getFont());
        Rectangle textRectangle = new Rectangle();
        int pWidth = this.getLabelWidth() - textExtents.width;
        textRectangle.x = pWidth + this.getBounds().x;
        int i = this.getBounds().height - textExtents.height;
        textRectangle.y = i <= 0 ? this.getBounds().y : this.getBounds().y + i / 2;
        textRectangle.setSize(textExtents);
        graphics.drawText(prompt, textRectangle.getLocation());
        Rectangle inputRectangle = new Rectangle();
        inputRectangle.x = textRectangle.getTopRight().x + 1;
        inputRectangle.y = this.getBounds().y + 1;
        int j = this.getBounds().width - this.getLabelWidth() - 1;
        inputRectangle.width = j <= 0 ? 0 : j;
        inputRectangle.height = this.getBounds().height - 1;
        graphics.setForegroundColor(ColorConstants.EDITOR_BORDER);
        graphics.drawRectangle(inputRectangle.getResized(-1, -1));
        Rectangle r = inputRectangle.getTranslated(1, 1).getResized(-2, -2);
        Color bgColor = ColorConstants.WHITE;
        if (this.model.isRequired()) {
            bgColor = ColorConstants.REQUIRED_BG;
        }
        if (this.model.isReadOnly()) {
            bgColor = ColorConstants.READONLY_BG;
        }
        graphics.setBackgroundColor(bgColor);
        graphics.fillRectangle(r);
        this.paintEmptyText(graphics, this.model.getEmptyText(), r);
        Image image = this.getImage();
        if (image != null) {
            Rectangle imageR = inputRectangle.getCopy();
            graphics.drawImage(image, this.getImageLocation().x, this.getImageLocation().y, 16, 16, imageR.getTopRight().x - 18, imageR.getTopRight().y, 16, 16);
        }
    }

    private void paintEmptyText(Graphics g, String emptyText, Rectangle r) {
        g.pushState();
        g.setForegroundColor(ColorConstants.EDITOR_BORDER);
        Dimension dim = FigureUtilities.getTextExtents((String)emptyText, (Font)this.getFont());
        g.setClip(r.getResized(-16, 0));
        g.drawString(emptyText, r.x + 2, r.y + (r.height - dim.height) / 2);
        g.popState();
    }

    private Image getImage() {
        String type = this.model.getType();
        if ("comboBox".equals(type)) {
            return ImagesUtils.getImage("palette/itembar_01.png");
        }
        if ("datePicker".equals(type) || "dateTimePicker".equals(type)) {
            return ImagesUtils.getImage("palette/itembar_02.png");
        }
        if ("lov".equals(type)) {
            return ImagesUtils.getImage("palette/itembar_03.png");
        }
        if ("textField".equals(type)) {
            return ImagesUtils.getImage("palette/itembar_04.png");
        }
        if ("numberField".equals(type)) {
            return ImagesUtils.getImage("palette/itembar_05.png");
        }
        return null;
    }

    private Point getImageLocation() {
        Point p = new Point(0, 0);
        return p;
    }
}

