/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.figures;

import aurora.ide.meta.gef.editors.ImagesUtils;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.figures.Messages;
import aurora.ide.meta.gef.editors.models.Navbar;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class NavbarFigure
extends Figure {
    private String[] texts = new String[]{Messages.NavbarFigure_0, Messages.NavbarFigure_1, Messages.NavbarFigure_2, Messages.NavbarFigure_3, Messages.NavbarFigure_4};
    private static String simpleText = Messages.NavbarFigure_5;
    private Navbar model;
    private static Image bgImg = ImagesUtils.getImage("toolbar_bg.gif");
    private static Image navImg = ImagesUtils.getImage("navigation.gif");
    private static Image sepImg = ImagesUtils.getImage("toolbar_sep.gif");
    private static Image combImg = ImagesUtils.getImage("palette/itembar_01.png");

    public NavbarFigure() {
        this.setBorder(null);
    }

    public void handleFocusGained(FocusEvent event) {
        super.handleFocusGained(event);
    }

    protected void paintFigure(Graphics g) {
        String type = this.model.getType();
        if (type.equals("")) {
            return;
        }
        super.paintFigure(g);
        if (type.equals("complex")) {
            this.paintComplex(g);
        } else {
            this.paintSimple(g);
        }
    }

    private void paintSimple(Graphics g) {
        Rectangle bounds = this.getBounds().getCopy();
        g.setForegroundColor(ColorConstants.GRID_COLUMN_GRAY);
        g.drawLine(bounds.getTopLeft(), bounds.getTopRight());
        Dimension dim = FigureUtilities.getTextExtents((String)simpleText, (Font)this.getFont());
        g.setForegroundColor(ColorConstants.BLACK);
        g.drawString(simpleText, bounds.x + bounds.width - dim.width - 3, bounds.y + (bounds.height - dim.height) / 2);
    }

    private void paintComplex(Graphics g) {
        Rectangle bounds = this.getBounds().getCopy();
        g.drawImage(bgImg, new Rectangle(bgImg.getBounds()), bounds);
        Rectangle r1 = new Rectangle(0, 0, 16, 16);
        Rectangle r2 = new Rectangle(bounds.x + 4, bounds.y + 4, 16, 16);
        g.drawImage(navImg, r1, r2);
        r1.y = 32;
        r2.x += bounds.height;
        g.drawImage(navImg, r1, r2);
        Rectangle r3 = new Rectangle(r2.x + bounds.height, bounds.y, 2, bounds.height);
        g.drawImage(sepImg, new Rectangle(sepImg.getBounds()), r3);
        g.setForegroundColor(ColorConstants.BLACK);
        Dimension dim = FigureUtilities.getTextExtents((String)this.texts[0], (Font)this.getFont());
        int nextX = r3.x + r3.width + 2;
        g.drawString(this.texts[0], nextX, bounds.y + (bounds.height - dim.height) / 2);
        g.setForegroundColor(ColorConstants.GRID_COLUMN_GRAY);
        g.setBackgroundColor(ColorConstants.WHITE);
        Rectangle r4 = new Rectangle(nextX += dim.width + 2, bounds.y + 3, 30, bounds.height - 6);
        g.fillRectangle(r4);
        g.drawRectangle(r4);
        g.setForegroundColor(ColorConstants.BLACK);
        dim = FigureUtilities.getTextExtents((String)this.texts[1], (Font)this.getFont());
        g.drawString(this.texts[1], nextX += r4.width + 5, bounds.y + (bounds.height - dim.height) / 2);
        r3 = new Rectangle(nextX += dim.width + 2, bounds.y, 2, bounds.height);
        g.drawImage(sepImg, new Rectangle(sepImg.getBounds()), r3);
        r1.y = 48;
        r2.x = nextX + 4;
        g.drawImage(navImg, r1, r2);
        r1.y = 16;
        r2.x += bounds.height;
        g.drawImage(navImg, r1, r2);
        r1.y = 64;
        r2.x += bounds.height;
        g.drawImage(navImg, r1, r2);
        nextX = r2.x + bounds.height + 2;
        r3 = new Rectangle(nextX, bounds.y, 2, bounds.height);
        g.drawImage(sepImg, new Rectangle(sepImg.getBounds()), r3);
        g.setForegroundColor(ColorConstants.BLACK);
        dim = FigureUtilities.getTextExtents((String)this.texts[2], (Font)this.getFont());
        g.drawString(this.texts[2], nextX += 5, bounds.y + (bounds.height - dim.height) / 2);
        g.setForegroundColor(ColorConstants.GRID_COLUMN_GRAY);
        g.setBackgroundColor(ColorConstants.WHITE);
        r4 = new Rectangle(nextX += dim.width + 2, bounds.y + 3, 46, bounds.height - 6);
        g.fillRectangle(r4);
        g.drawImage(combImg, new Rectangle(combImg.getBounds()), new Rectangle(r4.x + 29, r4.y + 1, 16, 16));
        g.drawRectangle(r4);
        nextX = r4.x + r4.width + 5;
        g.setForegroundColor(ColorConstants.BLACK);
        dim = FigureUtilities.getTextExtents((String)this.texts[3], (Font)this.getFont());
        g.drawString(this.texts[3], nextX, bounds.y + (bounds.height - dim.height) / 2);
        r3 = new Rectangle(nextX += dim.width + 5, bounds.y, 2, bounds.height);
        g.drawImage(sepImg, new Rectangle(sepImg.getBounds()), r3);
        dim = FigureUtilities.getTextExtents((String)this.texts[4], (Font)this.getFont());
        if (bounds.width - (nextX += 3) < dim.width) {
            return;
        }
        g.drawString(this.texts[4], bounds.x + bounds.width - dim.width - 3, bounds.y + (bounds.height - dim.height) / 2);
        g.setForegroundColor(ColorConstants.GRID_COLUMN_GRAY);
        g.drawLine(bounds.getTopLeft(), bounds.getTopRight());
    }

    public void setModel(Navbar model) {
        this.model = model;
    }

    private Image getImage(String key) {
        return ImagesUtils.getImage(key);
    }
}

