/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.layout;

import aurora.ide.meta.gef.editors.figures.GridColumnFigure;
import aurora.ide.meta.gef.editors.layout.GraphLayoutManager;
import aurora.ide.meta.gef.editors.layout.RowColBackLayout;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.meta.gef.editors.parts.GridPart;
import aurora.ide.meta.gef.editors.parts.NavbarPart;
import aurora.ide.meta.gef.editors.parts.ToolbarPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class GridBackLayout2
extends RowColBackLayout {
    private int maxDepth = 0;
    private Map<ComponentPart, Integer> depthMap = new HashMap<ComponentPart, Integer>();
    private static final Insets padding = new Insets(-1, 0, 0, 0);
    private GridPart gridPart;
    private ToolbarPart toolbarPart;
    private NavbarPart navbarPart;
    private int navbarHight;

    public GridBackLayout2() {
        this.location.x = 1;
        this.setPadding(padding);
    }

    public Rectangle layout(ComponentPart parent) {
        this.init(parent);
        this.gridPart = (GridPart)this.host;
        this.navbarPart = this.getNavbarPart();
        this.toolbarPart = this.getToolbarPart();
        if (!this.hasToolbar()) {
            this.location.y -= 25;
        }
        this.titleHight = this.hasToolbar() ? 25 : 0;
        int n = this.navbarHight = this.navbarPart == null ? 0 : 25;
        if (this.getRealRow() == 0) {
            Rectangle calculateRectangle = this.calculateRectangle(parent);
            this.layoutToolbar(calculateRectangle);
            this.layoutNavbar(calculateRectangle);
            return calculateRectangle;
        }
        this.calculateMaxWidthHight();
        this.calculateChildLocation();
        this.applyToChildren();
        this.calculateChildDepth(parent, 1);
        this.applyToALlChildCH(parent);
        Rectangle calculateRectangle = this.calculateRectangle(parent);
        this.layoutToolbar(calculateRectangle);
        this.layoutNavbar(calculateRectangle);
        return calculateRectangle;
    }

    private void layoutToolbar(Rectangle calculateRectangle) {
        Point location = new Point();
        location.translate(this.selfRectangle.getTopLeft());
        if (this.toolbarPart != null) {
            Rectangle layout = GraphLayoutManager.layout(this.toolbarPart);
            Rectangle setLocation = layout.getCopy().setLocation(location);
            setLocation.setWidth(calculateRectangle.width);
            this.applyToFigure(this.toolbarPart, setLocation);
        }
    }

    private void layoutNavbar(Rectangle calculateRectangle) {
        Point bottomLeft = this.selfRectangle.getBottomLeft();
        Point setY = bottomLeft.getCopy().setY(bottomLeft.y - 25);
        if (this.navbarPart != null) {
            Rectangle layout = GraphLayoutManager.layout(this.navbarPart);
            Rectangle setLocation = layout.getCopy().setLocation(setY);
            setLocation.setWidth(calculateRectangle.width);
            this.applyToFigure(this.navbarPart, setLocation);
        }
    }

    private ToolbarPart getToolbarPart() {
        List children = this.gridPart.getChildren();
        for (Object object : children) {
            if (!(object instanceof ToolbarPart)) continue;
            return (ToolbarPart)object;
        }
        return null;
    }

    private NavbarPart getNavbarPart() {
        List children = this.gridPart.getChildren();
        for (Object object : children) {
            if (!(object instanceof NavbarPart)) continue;
            return (NavbarPart)object;
        }
        return null;
    }

    public List getChildren() {
        return this.getColumns(this.getHost());
    }

    private List getColumns(ComponentPart parent) {
        ArrayList<ComponentPart> columns = new ArrayList<ComponentPart>();
        List children = parent.getChildren();
        for (Object object : children) {
            if (object instanceof NavbarPart || object instanceof ToolbarPart) continue;
            columns.add((ComponentPart)object);
        }
        return columns;
    }

    private void applyToALlChildCH(ComponentPart parent) {
        List children = this.getColumns(parent);
        int columnHight = 25;
        int i = 0;
        while (i < children.size()) {
            ComponentPart cp = (ComponentPart)children.get(i);
            if (this.getColumns(cp).size() > 0) {
                ((GridColumnFigure)cp.getFigure()).setColumnHight(columnHight);
            } else {
                Integer depth = this.depthMap.get(cp);
                int l = this.maxDepth - depth + 1;
                ((GridColumnFigure)cp.getFigure()).setColumnHight(columnHight * l);
            }
            this.applyToALlChildCH(cp);
            ++i;
        }
    }

    private boolean hasToolbar() {
        return this.getToolbarPart() != null;
    }

    private boolean hasNavbar() {
        return this.getNavbarPart() != null;
    }

    private void calculateChildDepth(ComponentPart parent, int depth) {
        List children = this.getColumns(parent);
        int i = 0;
        while (i < children.size()) {
            this.maxDepth = Math.max(this.maxDepth, depth);
            this.depthMap.put((ComponentPart)children.get(i), depth);
            int t = depth;
            this.calculateChildDepth((ComponentPart)children.get(i), ++t);
            ++i;
        }
    }

    protected void calculateChildLocation() {
        int i = 0;
        while (i < this.realRow) {
            int j = 0;
            while (j < this.col) {
                ComponentPart rp = this.childs[i][j];
                if (rp == null) {
                    return;
                }
                Rectangle rr = (Rectangle)this.partMap.get(rp);
                rr.setLocation(this.location);
                rr.setHeight(this.selfRectangle.height - this.titleHight - this.navbarHight);
                this.location.x += this.maxColWidths[j] + 0 - 1;
                ++j;
            }
            this.location.x = 0 + this.selfRectangle.getTopLeft().x;
            this.location.y = this.location.y + this.maxRowHights[i] + 0;
            ++i;
        }
    }

    protected Rectangle calculateRectangle(ComponentPart parent) {
        Rectangle selfRectangle = this.zero.getCopy().setLocation(parent.getFigure().getBounds().getLocation());
        List children = this.getColumns(parent);
        int i = 0;
        while (i < children.size()) {
            ComponentPart cp = (ComponentPart)children.get(i);
            selfRectangle.union(cp.getFigure().getBounds().getCopy());
            ++i;
        }
        if (selfRectangle.width > this.selfRectangle.width) {
            return this.selfRectangle.getCopy().setWidth(selfRectangle.width + 50);
        }
        selfRectangle = parent.getComponent().getBoundsCopy();
        return this.selfRectangle.setWidth(selfRectangle.width);
    }
}

