/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.layout;

import aurora.ide.meta.gef.editors.layout.BackLayout;
import aurora.ide.meta.gef.editors.layout.GraphLayoutManager;
import aurora.ide.meta.gef.editors.models.RowCol;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class RowColBackLayout
extends BackLayout {
    private Insets padding = new Insets(0, 0, 0, 0);
    protected Rectangle zero = new Rectangle(0, 0, 0, 0);
    protected Rectangle selfRectangle = new Rectangle();
    protected Point location = new Point();
    protected RowCol rowCol;
    protected int col;
    protected int row;
    protected int titleHight;
    protected ComponentPart host;
    protected int t_col = 0;
    protected int t_row = 0;
    protected ComponentPart[][] childs;
    protected int[] maxColWidths;
    protected int[] maxRowHights;
    protected int realRow;
    protected Map<ComponentPart, Rectangle> partMap;

    protected void init(ComponentPart parent) {
        if (parent.getComponent() instanceof RowCol) {
            this.host = parent;
            this.rowCol = (RowCol)parent.getComponent();
            this.col = this.rowCol.getCol();
            if (this.col == 0) {
                return;
            }
            this.row = this.rowCol.getRow();
            Rectangle fBounds = parent.getFigure().getBounds();
            this.selfRectangle = fBounds.isEmpty() ? this.rowCol.getBoundsCopy() : fBounds;
            this.titleHight = this.rowCol.getHeadHight();
            this.location.x += this.getPadding().left;
            this.location.y = this.location.y + this.titleHight + this.getPadding().top;
            this.location.translate(this.selfRectangle.getTopLeft());
            this.t_col = 0;
            this.t_row = 0;
            this.maxColWidths = new int[this.col];
            int i = 0;
            while (i < this.col) {
                this.maxColWidths[i] = 0;
                ++i;
            }
            this.partMap = new HashMap<ComponentPart, Rectangle>();
            List children = this.getChildren();
            this.realRow = children.size() / this.col + (children.size() % this.col == 0 ? 0 : 1);
            if (this.realRow == 0) {
                return;
            }
            this.childs = new ComponentPart[this.realRow][this.col];
            this.maxRowHights = new int[this.realRow];
            int i2 = 0;
            while (i2 < this.realRow) {
                this.maxRowHights[i2] = 0;
                ++i2;
            }
            i2 = 0;
            while (i2 < children.size()) {
                ComponentPart ep = (ComponentPart)children.get(i2);
                if (this.t_col == this.col) {
                    ++this.t_row;
                    this.t_col = 0;
                }
                this.childs[this.t_row][this.t_col] = ep;
                Rectangle layout = GraphLayoutManager.layout(ep);
                this.partMap.put(ep, layout);
                ++this.t_col;
                ++i2;
            }
        }
    }

    public Rectangle layout(ComponentPart parent) {
        this.init(parent);
        if (this.getRealRow() == 0 || this.col == 0) {
            return this.calculateRectangle(parent);
        }
        this.calculateMaxWidthHight();
        this.calculateChildLocation();
        this.applyToChildren();
        Rectangle calculateRectangle = this.calculateRectangle(parent);
        return calculateRectangle;
    }

    protected void applyToChildren() {
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            ComponentPart ep = (ComponentPart)children.get(i);
            Rectangle layout = this.partMap.get(ep);
            this.applyToFigure(ep, layout);
            ++i;
        }
    }

    public List getChildren() {
        return this.getHost().getChildren();
    }

    protected void calculateMaxWidthHight() {
        int i = 0;
        while (i < this.realRow) {
            int j = 0;
            while (j < this.col) {
                ComponentPart rp = this.childs[i][j];
                if (rp == null) break;
                Rectangle rr = this.partMap.get(rp);
                this.maxRowHights[i] = Math.max(this.maxRowHights[i], rr.height);
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < this.col) {
            int k = 0;
            while (k < this.realRow) {
                ComponentPart cp = this.childs[k][j];
                if (cp == null) break;
                Rectangle cr = this.partMap.get(cp);
                this.maxColWidths[j] = Math.max(this.maxColWidths[j], cr.width);
                ++k;
            }
            ++j;
        }
    }

    protected void calculateChildLocation() {
        int i = 0;
        while (i < this.realRow) {
            int j = 0;
            while (j < this.col) {
                ComponentPart rp = this.childs[i][j];
                if (rp == null) {
                    return;
                }
                Rectangle rr = this.partMap.get(rp);
                rr.setLocation(this.location);
                this.location.x += this.maxColWidths[j] + this.getPadding().left;
                ++j;
            }
            this.location.x = this.getPadding().left + this.selfRectangle.getTopLeft().x;
            this.location.y = this.location.y + this.maxRowHights[i] + this.getPadding().top;
            ++i;
        }
    }

    protected Rectangle calculateRectangle(ComponentPart parent) {
        Rectangle selfRectangle = this.zero.getCopy().setLocation(parent.getFigure().getBounds().getLocation());
        List children = parent.getChildren();
        Rectangle modelRectangle = parent.getComponent().getBoundsCopy();
        if (children.size() == 0 || selfRectangle.equals((Object)this.zero)) {
            return modelRectangle;
        }
        int i = 0;
        while (i < children.size()) {
            ComponentPart cp = (ComponentPart)children.get(i);
            selfRectangle.union(this.partMap.get(cp).getCopy());
            ++i;
        }
        Rectangle expand = selfRectangle.expand(5, 5);
        return new Rectangle(expand.x, expand.y, Math.max(expand.width, modelRectangle.width), Math.max(expand.height, modelRectangle.height));
    }

    private Rectangle calculateFormRectangle(ComponentPart parent) {
        Rectangle selfRectangle = this.zero.getCopy().setLocation(parent.getFigure().getBounds().getLocation());
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            ComponentPart cp = (ComponentPart)children.get(i);
            selfRectangle.union(cp.getFigure().getBounds().getCopy());
            ++i;
        }
        if (selfRectangle.width > this.rowCol.getBoundsCopy().width) {
            return selfRectangle.expand(5, 5);
        }
        int nw = Math.max(selfRectangle.width, this.rowCol.getBoundsCopy().width);
        int nh = Math.max(selfRectangle.height, this.rowCol.getBoundsCopy().height);
        return this.selfRectangle.getCopy().setSize(nw, nh).expand(0, 5);
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        this.padding = padding;
    }

    public ComponentPart getHost() {
        return this.host;
    }

    public void setHost(ComponentPart host) {
        this.host = host;
    }

    protected int getRealRow() {
        return this.realRow;
    }

    protected Rectangle getSelfRectangle() {
        return this.selfRectangle;
    }
}

