/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.layout;

import aurora.ide.meta.gef.editors.layout.BackLayout;
import aurora.ide.meta.gef.editors.layout.GraphLayoutManager;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.meta.gef.editors.parts.ContainerPart;
import java.util.List;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class ScreenGraphLayout
extends BackLayout {
    private static final Insets PADDING = new Insets(8, 16, 8, 6);
    private ContainerPart diagram;
    private Rectangle last = new Rectangle(0, 0, 0, 0);

    public ScreenGraphLayout(ContainerPart diagram) {
        this.diagram = diagram;
        this.last = diagram.getFigure().getBounds().getCopy().setSize(0, 0);
        ScreenGraphLayout.PADDING.left = this.last.x + 16;
    }

    public void layout() {
        List children = this.getSortChildren();
        int i = 0;
        while (i < children.size()) {
            ComponentPart ep = (ComponentPart)children.get(i);
            Rectangle layout = GraphLayoutManager.layout(ep);
            layout = this.newChildLocation(ep, layout);
            this.applyToFigure(ep, layout);
            ++i;
        }
        this.diagram.applyToModel();
    }

    private List getSortChildren() {
        List children = this.diagram.getChildren();
        return children;
    }

    public Rectangle layout(ComponentPart ep) {
        return null;
    }

    protected Rectangle newChildLocation(ComponentPart ep, Rectangle layout) {
        layout.x = ScreenGraphLayout.PADDING.left;
        layout.y = this.last.y + this.last.height + ScreenGraphLayout.PADDING.top;
        this.last = layout.getCopy();
        return layout.getCopy();
    }
}

