/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models;

import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.IProperties;
import aurora.ide.meta.gef.editors.property.IPropertySource2;
import aurora.ide.meta.gef.editors.property.IntegerPropertyDescriptor;
import aurora.ide.meta.gef.editors.property.StringPropertyDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class AuroraComponent
implements Cloneable,
Serializable,
IProperties,
IPropertySource2 {
    public transient String markid = Integer.toHexString(this.hashCode());
    protected transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    static final long serialVersionUID = 1L;
    private Rectangle bounds = new Rectangle();
    private String name = "";
    private String type = "";
    private String prompt = "prompt";
    private Container parent;
    protected static final IPropertyDescriptor PD_PROMPT = new StringPropertyDescriptor("prompt", "Prompt");
    protected static final IPropertyDescriptor PD_WIDTH = new IntegerPropertyDescriptor("width", "Width");
    protected static final IPropertyDescriptor PD_HEIGHT = new IntegerPropertyDescriptor("height", "Height");
    protected static final IPropertyDescriptor PD_NAME = new StringPropertyDescriptor("name", "Name");
    private static final IPropertyDescriptor[] pds = new IPropertyDescriptor[]{PD_PROMPT};
    protected static final IPropertyDescriptor[] NONE_PROPS = new IPropertyDescriptor[0];

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    protected void firePropertyChange(String prop, Object old, Object newValue) {
        this.listeners.firePropertyChange(prop, old, newValue);
    }

    protected void fireStructureChange(String prop, Object child) {
        this.listeners.firePropertyChange(prop, null, child);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new PropertyChangeSupport(this);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    public void setLocation(Point p) {
        Point oldLoc = this.getLocation();
        if (this.eq(oldLoc, p)) {
            return;
        }
        this.bounds.setLocation(p);
        this.firePropertyChange("location", oldLoc, p);
    }

    public Point getLocation() {
        return this.bounds.getLocation();
    }

    public Dimension getSize() {
        return this.bounds.getSize();
    }

    public void setSize(Dimension size) {
        Dimension oldSize = this.getSize();
        if (this.eq(oldSize, size)) {
            return;
        }
        this.bounds.setSize(size);
        this.firePropertyChange("size", oldSize, size);
    }

    public Rectangle getBoundsCopy() {
        return this.bounds.getCopy();
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void applyToModel(Rectangle bounds) {
        this.bounds.setBounds(bounds);
    }

    public void setBounds(Rectangle bounds) {
        if (this.eq(this.bounds, bounds)) {
            return;
        }
        Rectangle old = this.bounds;
        this.bounds = bounds;
        this.firePropertyChange("bounds", old, bounds);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.eq(this.name, name)) {
            return;
        }
        String old = this.name;
        this.name = name;
        this.firePropertyChange("name", old, name);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (this.eq(this.type, type)) {
            return;
        }
        String old = this.type;
        this.type = type;
        this.firePropertyChange("type", old, type);
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        if (this.eq(this.prompt, prompt)) {
            return;
        }
        String old = this.prompt;
        this.prompt = prompt;
        this.firePropertyChange("prompt", old, prompt);
    }

    protected boolean eq(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return pds;
    }

    public Object getPropertyValue(Object propName) {
        if ("prompt".equals(propName)) {
            return this.getPrompt();
        }
        if ("width".equals(propName)) {
            return this.getSize().width;
        }
        if ("height".equals(propName)) {
            return this.getSize().height;
        }
        if ("name".equals(propName)) {
            return this.getName();
        }
        return null;
    }

    public boolean isPropertySet(Object propName) {
        if ("prompt".equals(propName)) {
            return true;
        }
        if ("width".equals(propName)) {
            return true;
        }
        if ("height".equals(propName)) {
            return true;
        }
        return "name".equals(propName);
    }

    public void resetPropertyValue(Object propName) {
    }

    public void setPropertyValue(Object propName, Object val) {
        if ("prompt".equals(propName)) {
            this.setPrompt((String)val);
        } else if ("width".equals(propName)) {
            this.setSize(new Dimension(((Integer)val).intValue(), this.getSize().height));
        } else if ("height".equals(propName)) {
            this.setSize(new Dimension(this.getSize().width, ((Integer)val).intValue()));
        } else if ("name".equals(propName)) {
            this.setName((String)val);
        }
    }

    public Container getParent() {
        return this.parent;
    }

    public void setParent(Container parent) {
        this.parent = parent;
    }

    public IPropertyDescriptor[] mergePropertyDescriptor(IPropertyDescriptor[] pd1, IPropertyDescriptor[] pd2) {
        IPropertyDescriptor[] descs = new IPropertyDescriptor[pd1.length + pd2.length];
        System.arraycopy(pd1, 0, descs, 0, pd1.length);
        System.arraycopy(pd2, 0, descs, pd1.length, pd2.length);
        return descs;
    }
}

