/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models;

import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.ButtonClicker;
import aurora.ide.meta.gef.editors.models.Messages;
import aurora.ide.meta.gef.editors.models.Toolbar;
import aurora.ide.meta.gef.editors.property.ButtonClickEditDialog;
import aurora.ide.meta.gef.editors.property.ComboPropertyDescriptor;
import aurora.ide.meta.gef.editors.property.DialogPropertyDescriptor;
import aurora.ide.meta.gef.editors.property.IntegerPropertyDescriptor;
import aurora.ide.meta.gef.editors.property.StringPropertyDescriptor;
import java.util.Arrays;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class Button
extends AuroraComponent {
    private static final long serialVersionUID = 1177281488586303137L;
    public static final String ADD = "add";
    public static final String SAVE = "save";
    public static final String DELETE = "delete";
    public static final String CLEAR = "clear";
    public static final String EXCEL = "excel";
    public static final String DEFAULT = "";
    public static final String[] std_types = new String[]{"", "add", "save", "delete", "clear", "excel"};
    private static final String[] std_type_names = new String[]{"", Messages.Button_7, Messages.Button_8, Messages.Button_9, Messages.Button_10, Messages.Button_11};
    public static final String BUTTON_TYPE = "type";
    public static final String BUTTON_TEXT = "text";
    public static final String BUTTON_CLICKER = "click";
    public static final String TOOLTIP = "title";
    private static final IPropertyDescriptor[] std_pds = new IPropertyDescriptor[]{new StringPropertyDescriptor("text", "Text"), PD_NAME, new IntegerPropertyDescriptor("width", "Width"), new IntegerPropertyDescriptor("height", "Height"), new StringPropertyDescriptor("title", "Title"), new ComboPropertyDescriptor("type", "Type", std_type_names)};
    private static final IPropertyDescriptor[] inner_pds = new IPropertyDescriptor[]{new StringPropertyDescriptor("text", "Text"), PD_NAME, new IntegerPropertyDescriptor("width", "Width"), new IntegerPropertyDescriptor("height", "Height"), new StringPropertyDescriptor("title", "Title"), new DialogPropertyDescriptor("click", "Click", ButtonClickEditDialog.class)};
    private String buttonType = "";
    private String text = "button";
    private String icon = "";
    private String title = "";
    private AuroraComponent targetComponent;
    private ButtonClicker buttonClicker = new ButtonClicker();

    public Button() {
        this.setSize(new Dimension(80, 20));
        this.setType("button");
        this.buttonClicker.setButton(this);
    }

    public void setSize(Dimension dim) {
        if (this.isOnToolBar()) {
            dim.height = 20;
            if (this.isStdButton()) {
                dim.width = 48;
            }
        }
        super.setSize(dim);
    }

    public void setBounds(Rectangle bounds) {
        if (this.isOnToolBar()) {
            bounds.height = 20;
            if (this.isStdButton()) {
                bounds.width = 48;
            }
        }
        super.setBounds(bounds);
    }

    public boolean isStdButton() {
        return Arrays.asList(std_types).indexOf(this.buttonType) > 0;
    }

    public String getButtonType() {
        return this.buttonType;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getText() {
        if (CLEAR.equals(this.buttonType)) {
            return Messages.Button_30;
        }
        if (ADD.equals(this.buttonType)) {
            return Messages.Button_31;
        }
        if (DELETE.equals(this.buttonType)) {
            return Messages.Button_32;
        }
        if (SAVE.equals(this.buttonType)) {
            return Messages.Button_33;
        }
        if (EXCEL.equals(this.buttonType)) {
            return Messages.Button_34;
        }
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    public AuroraComponent getTargetComponent() {
        return this.targetComponent;
    }

    public void setButtonType(String buttonType) {
        if (this.eq(this.buttonType, buttonType)) {
            return;
        }
        String oldV = this.buttonType;
        this.buttonType = buttonType;
        this.firePropertyChange(BUTTON_TYPE, oldV, buttonType);
        if (this.isStdButton()) {
            super.setSize(new Dimension(48, 20));
        }
    }

    public void setIcon(String icon) {
        if (this.eq(this.icon, icon)) {
            return;
        }
        String oldV = this.icon;
        this.icon = icon;
        this.firePropertyChange("ICON", oldV, icon);
    }

    public void setText(String text) {
        if (this.eq(this.text, text)) {
            return;
        }
        String oldV = this.text;
        this.text = text;
        this.firePropertyChange(BUTTON_TEXT, oldV, text);
    }

    public void setTitle(String title) {
        if (this.eq(this.title, title)) {
            return;
        }
        String oldV = this.title;
        this.title = title;
        this.firePropertyChange(TOOLTIP, oldV, title);
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.isOnToolBar()) {
            return std_pds;
        }
        return inner_pds;
    }

    public Object getPropertyValue(Object propName) {
        if (TOOLTIP.equals(propName)) {
            return this.getTitle();
        }
        if (BUTTON_TEXT.equals(propName)) {
            return this.getText();
        }
        if (BUTTON_CLICKER.equals(propName)) {
            return this.buttonClicker;
        }
        if (BUTTON_TYPE.equals(propName)) {
            return Arrays.asList(std_types).indexOf(this.getButtonType());
        }
        return super.getPropertyValue(propName);
    }

    public void setPropertyValue(Object propName, Object val) {
        if (TOOLTIP.equals(propName)) {
            this.setTitle((String)val);
        } else if (BUTTON_TEXT.equals(propName)) {
            this.setText((String)val);
        } else if (BUTTON_CLICKER.equals(propName)) {
            this.buttonClicker = (ButtonClicker)val;
        } else if (BUTTON_TYPE.equals(propName)) {
            this.setButtonType(std_types[(Integer)val]);
        }
        super.setPropertyValue(propName, val);
    }

    public boolean isOnToolBar() {
        return this.getParent() instanceof Toolbar;
    }

    public ButtonClicker getButtonClicker() {
        return this.buttonClicker;
    }

    public void setButtonClicker(ButtonClicker buttonClicker) {
        this.buttonClicker = buttonClicker;
    }
}

