/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models;

import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.DatasetField;
import aurora.ide.meta.gef.editors.models.FootRenderer;
import aurora.ide.meta.gef.editors.models.IDatasetFieldDelegate;
import aurora.ide.meta.gef.editors.models.Renderer;
import aurora.ide.meta.gef.editors.models.RowCol;
import aurora.ide.meta.gef.editors.property.BooleanPropertyDescriptor;
import aurora.ide.meta.gef.editors.property.ComboPropertyDescriptor;
import aurora.ide.meta.gef.editors.property.DialogPropertyDescriptor;
import aurora.ide.meta.gef.editors.property.FootRendererEditDialog;
import aurora.ide.meta.gef.editors.property.RendererEditDialog;
import aurora.ide.meta.gef.editors.source.gen.DataSetFieldUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridColumn
extends RowCol
implements IDatasetFieldDelegate {
    private static final long serialVersionUID = 3032139528088861361L;
    private static final String[] editors = new String[]{"", "textField", "numberField", "comboBox", "lov", "checkBox", "datePicker", "dateTimePicker"};
    public static final String EDITOR = "editor";
    public static final String RENDERER = "renderer";
    public static final String FOOTRENDERER = "footRenderer";
    private List<GridColumn> cols = new ArrayList<GridColumn>();
    private int rowHight = 25;
    private String editor = editors[0];
    private Renderer renderer = new Renderer();
    private FootRenderer footRenderer = new FootRenderer();
    private DatasetField dsField = new DatasetField();
    private static final IPropertyDescriptor[] pds = new IPropertyDescriptor[]{PD_PROMPT, PD_WIDTH, PD_NAME, new ComboPropertyDescriptor("editor", "editor", editors), new DialogPropertyDescriptor("renderer", "renderer", RendererEditDialog.class), new DialogPropertyDescriptor("footRenderer", "footRenderer", FootRendererEditDialog.class), new BooleanPropertyDescriptor("readOnly", "*readOnly"), new BooleanPropertyDescriptor("required", "*required")};

    public int getRowHight() {
        return this.rowHight;
    }

    public void setRowHight(int rowHight) {
        this.rowHight = rowHight;
    }

    public List<GridColumn> getCols() {
        return this.cols;
    }

    public GridColumn() {
        this.row = 1;
        this.col = 999;
        this.headHight = 25;
        this.setSize(new Dimension(100, this.rowHight * 2 + 10));
        this.setType("column");
        this.setPrompt("prompt");
        this.renderer.setColumn(this);
        this.footRenderer.setColumn(this);
    }

    public void addCol(GridColumn col) {
        this.cols.add(col);
        this.addChild(col);
    }

    @Override
    public boolean isResponsibleChild(AuroraComponent child) {
        return child.getClass().equals(GridColumn.class);
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return pds;
    }

    @Override
    public Object getPropertyValue(Object propName) {
        if (EDITOR.equals(propName)) {
            return Arrays.asList(editors).indexOf(this.getEditor());
        }
        if (RENDERER.equals(propName)) {
            return this.getRenderer();
        }
        if (FOOTRENDERER.equals(propName)) {
            return this.getFootRenderer();
        }
        if ("readOnly".equals(propName)) {
            return this.getDatasetField().isReadOnly();
        }
        if ("required".equals(propName)) {
            return this.getDatasetField().isRequired();
        }
        if ("displayField".equals(propName) || "valueField".equals(propName) || "returnField".equals(propName) || "options".equals(propName) || "lovGridHeight".equals(propName) || "lovHeight".equals(propName) || "lovService".equals(propName) || "lovUrl".equals(propName) || "lovWidth".equals(propName) || "title".equals(propName)) {
            return this.dsField.getPropertyValue(propName);
        }
        if ("uncheckedValue".equals(propName) || "checkedValue".equals(propName) || "defaultValue".equals(propName)) {
            return this.getDatasetField().getPropertyValue(propName);
        }
        return super.getPropertyValue(propName);
    }

    @Override
    public void setPropertyValue(Object propName, Object val) {
        if (EDITOR.equals(propName)) {
            this.setEditor(editors[(Integer)val]);
        } else if (RENDERER.equals(propName)) {
            this.setRenderer((Renderer)val);
        } else if (FOOTRENDERER.equals(propName)) {
            this.setFootRenderer((FootRenderer)val);
        } else if ("readOnly".equals(propName)) {
            this.setReadOnly((Boolean)val);
        } else if ("required".equals(propName)) {
            this.setRequired((Boolean)val);
        } else if ("displayField".equals(propName) || "valueField".equals(propName) || "returnField".equals(propName) || "options".equals(propName) || "lovGridHeight".equals(propName) || "lovHeight".equals(propName) || "lovService".equals(propName) || "lovUrl".equals(propName) || "lovWidth".equals(propName) || "title".equals(propName)) {
            this.dsField.setPropertyValue(propName, val);
        } else if ("uncheckedValue".equals(propName) || "checkedValue".equals(propName) || "defaultValue".equals(propName)) {
            this.getDatasetField().setPropertyValue(propName, val);
        } else {
            super.setPropertyValue(propName, val);
        }
    }

    public void setRenderer(Renderer r) {
        this.renderer = r;
        r.setColumn(this);
        this.firePropertyChange(RENDERER, null, r);
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void setFootRenderer(FootRenderer r) {
        this.footRenderer = r;
        r.setColumn(this);
        this.firePropertyChange(FOOTRENDERER, null, r);
    }

    public FootRenderer getFootRenderer() {
        return this.footRenderer;
    }

    public String getEditor() {
        return this.editor;
    }

    public void setEditor(String editor) {
        if (this.eq(this.editor, editor)) {
            return;
        }
        String oldV = this.editor;
        this.editor = editor;
        this.firePropertyChange(EDITOR, oldV, editor);
    }

    public void setHeadHight(int h) {
        this.headHight = h;
    }

    @Override
    public DatasetField getDatasetField() {
        return this.dsField;
    }

    public void setReadOnly(boolean readOnly) {
        if (this.dsField.isReadOnly() == readOnly) {
            return;
        }
        this.dsField.setReadOnly(readOnly);
        this.firePropertyChange("readOnly", !readOnly, readOnly);
    }

    public void setRequired(boolean required) {
        if (this.dsField.isRequired() == required) {
            return;
        }
        this.dsField.setRequired(required);
        this.firePropertyChange("required", !required, required);
    }

    @Override
    public void setParent(Container part) {
        super.setParent(part);
        if (this.dsField != null) {
            this.dsField.setDataset(DataSetFieldUtil.findDataset(this.getParent()));
        }
    }

    @Override
    public void setDatasetField(DatasetField field) {
        this.dsField = field;
        this.dsField.setName(this.getName());
        this.dsField.setDataset(DataSetFieldUtil.findDataset(this.getParent()));
    }
}

