/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models;

import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.DatasetBinder;
import aurora.ide.meta.gef.editors.models.DatasetField;
import aurora.ide.meta.gef.editors.models.IDatasetFieldDelegate;
import aurora.ide.meta.gef.editors.models.Messages;
import aurora.ide.meta.gef.editors.property.BooleanPropertyDescriptor;
import aurora.ide.meta.gef.editors.property.ComboPropertyDescriptor;
import aurora.ide.meta.gef.editors.property.StringPropertyDescriptor;
import aurora.ide.meta.gef.editors.source.gen.DataSetFieldUtil;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class Input
extends AuroraComponent
implements IDatasetFieldDelegate,
DatasetBinder {
    private static final long serialVersionUID = -1913613647491922330L;
    public static final String TEXT = "textField";
    public static final String NUMBER = "numberField";
    public static final String Combo = "comboBox";
    public static final String LOV = "lov";
    public static final String CAL = "datePicker";
    public static final String DATETIMEPICKER = "dateTimePicker";
    public static final String CASE_LOWER = "lower";
    public static final String CASE_UPPER = "upper";
    public static final String CASE_ANY = "";
    private static final String[] CASE_TYPES = new String[]{"", "upper", "lower"};
    private static final String[] CAL_ENABLES = new String[]{"pre", "next", "both", "none"};
    public static final String[] INPUT_TYPES = new String[]{"textField", "numberField", "comboBox", "lov", "datePicker", "dateTimePicker", "checkBox"};
    public static final String ALLOWDECIMALS = "allowDecimals";
    public static final String ALLOWNEGATIVE = "allowNegative";
    public static final String ALLOWFORMAT = "allowFormat";
    public static final String EMPTYTEXT = "emptyText";
    public static final String TYPECASE = "typeCase";
    public static final String ENABLE_BESIDE_DAYS = "enableBesideDays";
    public static final String ENABLE_MONTH_BTN = "enableMonthBtn";
    private boolean allowDecimals = true;
    private boolean allowNegative = true;
    private boolean allowFormat = false;
    private String emptyText = "";
    private String typeCase = "";
    private String enableBesideDays = CAL_ENABLES[3];
    private String enableMonthBtn = CAL_ENABLES[3];
    private DatasetField dsField = new DatasetField();
    private static final IPropertyDescriptor PD_EMPYTEXT = new StringPropertyDescriptor("emptyText", "EmptyText");
    private static final IPropertyDescriptor PD_TYPECASE = new ComboPropertyDescriptor("typeCase", "TypeCase", new String[]{Messages.Input_23, Messages.Input_24, Messages.Input_25});
    private static final IPropertyDescriptor[] pds_text = new IPropertyDescriptor[]{PD_PROMPT, PD_NAME, PD_WIDTH, PD_EMPYTEXT, PD_TYPECASE, DatasetField.PD_REQUIRED, DatasetField.PD_READONLY};
    private static final IPropertyDescriptor[] pds_number = new IPropertyDescriptor[]{PD_PROMPT, PD_NAME, PD_WIDTH, PD_EMPYTEXT, new BooleanPropertyDescriptor("allowDecimals", "AllowDecimals"), new BooleanPropertyDescriptor("allowNegative", "AllowNegative"), new BooleanPropertyDescriptor("allowFormat", "AllowFormat"), DatasetField.PD_REQUIRED, DatasetField.PD_READONLY};
    private static final IPropertyDescriptor[] pds_combo = new IPropertyDescriptor[]{PD_PROMPT, PD_NAME, PD_WIDTH, PD_EMPYTEXT, PD_TYPECASE, DatasetField.PD_REQUIRED, DatasetField.PD_READONLY, new StringPropertyDescriptor("options", "*options", true), new StringPropertyDescriptor("displayField", "*displayField", true), new StringPropertyDescriptor("valueField", "*valueField", true), new StringPropertyDescriptor("returnField", "*returnField", true)};
    private static final IPropertyDescriptor[] pds_lov = new IPropertyDescriptor[]{PD_PROMPT, PD_NAME, PD_WIDTH, PD_EMPYTEXT, PD_TYPECASE, DatasetField.PD_REQUIRED, DatasetField.PD_READONLY, new StringPropertyDescriptor("lovService", "*lovService", true), new StringPropertyDescriptor("title", "*title")};
    private static final IPropertyDescriptor[] pds_datepicker = new IPropertyDescriptor[]{PD_PROMPT, PD_WIDTH, PD_NAME, new ComboPropertyDescriptor("enableBesideDays", "EnableBesideDays", CAL_ENABLES), new ComboPropertyDescriptor("enableMonthBtn", "EnableMonthBtn", CAL_ENABLES), DatasetField.PD_REQUIRED, DatasetField.PD_READONLY};

    public Input() {
        this.setSize(new Dimension(120, 20));
        this.setType(TEXT);
        this.setDatasetField(this.dsField);
    }

    public boolean isRequired() {
        return this.dsField.isRequired();
    }

    public void setRequired(boolean required) {
        if (this.getDatasetField().isRequired() == required) {
            return;
        }
        boolean oldV = this.getDatasetField().isRequired();
        this.dsField.setRequired(required);
        this.firePropertyChange("required", oldV, required);
    }

    public boolean isReadOnly() {
        return this.getDatasetField().isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        if (this.getDatasetField().isReadOnly() == readOnly) {
            return;
        }
        boolean oldV = this.getDatasetField().isReadOnly();
        this.getDatasetField().setReadOnly(readOnly);
        this.firePropertyChange("readOnly", oldV, readOnly);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        String type = this.getType();
        if (NUMBER.equals(type)) {
            return pds_number;
        }
        if (CAL.equals(type) || DATETIMEPICKER.equals(type)) {
            return pds_datepicker;
        }
        if (Combo.equals(type)) {
            return pds_combo;
        }
        if (LOV.equals(type)) {
            return pds_lov;
        }
        return pds_text;
    }

    public Object getPropertyValue(Object propName) {
        if ("required".equals(propName)) {
            return this.isRequired();
        }
        if ("readOnly".equals(propName)) {
            return this.isReadOnly();
        }
        if (ALLOWDECIMALS.equals(propName)) {
            return this.isAllowDecimals();
        }
        if (ALLOWNEGATIVE.equals(propName)) {
            return this.isAllowNegative();
        }
        if (ALLOWFORMAT.equals(propName)) {
            return this.isAllowFormat();
        }
        if (EMPTYTEXT.equals(propName)) {
            return this.getEmptyText();
        }
        if (TYPECASE.equals(propName)) {
            return this.indexOf(CASE_TYPES, this.getTypeCase());
        }
        if (ENABLE_BESIDE_DAYS.equals(propName)) {
            return this.indexOf(CAL_ENABLES, this.getEnableBesideDays());
        }
        if (ENABLE_MONTH_BTN.equals(propName)) {
            return this.indexOf(CAL_ENABLES, this.getEnableMonthBtn());
        }
        if ("displayField".equals(propName) || "valueField".equals(propName) || "returnField".equals(propName) || "options".equals(propName) || "lovGridHeight".equals(propName) || "lovHeight".equals(propName) || "lovService".equals(propName) || "lovUrl".equals(propName) || "lovWidth".equals(propName) || "title".equals(propName) || "defaultValue".equals(propName)) {
            return this.dsField.getPropertyValue(propName);
        }
        return super.getPropertyValue(propName);
    }

    public boolean isAllowDecimals() {
        return this.allowDecimals;
    }

    public void setAllowDecimals(boolean allowDecimals) {
        this.allowDecimals = allowDecimals;
    }

    public boolean isAllowNegative() {
        return this.allowNegative;
    }

    public void setAllowNegative(boolean allowNegative) {
        this.allowNegative = allowNegative;
    }

    public void setPropertyValue(Object propName, Object val) {
        if ("required".equals(propName)) {
            this.setRequired((Boolean)val);
        }
        if ("readOnly".equals(propName)) {
            this.setReadOnly((Boolean)val);
        } else if (ALLOWDECIMALS.equals(propName)) {
            this.setAllowDecimals((Boolean)val);
        } else if (ALLOWNEGATIVE.equals(propName)) {
            this.setAllowNegative((Boolean)val);
        } else if (ALLOWFORMAT.equals(propName)) {
            this.setAllowFormat((Boolean)val);
        } else if (EMPTYTEXT.equals(propName)) {
            this.setEmptyText((String)val);
        } else if (TYPECASE.equals(propName)) {
            this.setTypeCase(CASE_TYPES[(Integer)val]);
        } else if (ENABLE_BESIDE_DAYS.equals(propName)) {
            this.setEnableBesideDays(CAL_ENABLES[(Integer)val]);
        } else if (ENABLE_MONTH_BTN.equals(propName)) {
            this.setEnableMonthBtn(CAL_ENABLES[(Integer)val]);
        } else if ("displayField".equals(propName) || "valueField".equals(propName) || "returnField".equals(propName) || "options".equals(propName) || "lovGridHeight".equals(propName) || "lovHeight".equals(propName) || "lovService".equals(propName) || "lovUrl".equals(propName) || "lovWidth".equals(propName) || "title".equals(propName)) {
            this.dsField.setPropertyValue(propName, val);
        } else {
            super.setPropertyValue(propName, val);
        }
    }

    public boolean isAllowFormat() {
        return this.allowFormat;
    }

    public void setAllowFormat(boolean allowFormat) {
        this.allowFormat = allowFormat;
    }

    public String getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(String emptyText) {
        if (this.eq(this.emptyText, emptyText)) {
            return;
        }
        String oldV = this.emptyText;
        this.emptyText = emptyText;
        this.firePropertyChange(EMPTYTEXT, oldV, emptyText);
    }

    public String getTypeCase() {
        return this.typeCase;
    }

    public void setTypeCase(String typeCase) {
        this.typeCase = typeCase;
    }

    public String getEnableBesideDays() {
        return this.enableBesideDays;
    }

    public void setEnableBesideDays(String enableBesideDays) {
        this.enableBesideDays = enableBesideDays;
    }

    public String getEnableMonthBtn() {
        return this.enableMonthBtn;
    }

    public void setEnableMonthBtn(String enableMonthBtn) {
        this.enableMonthBtn = enableMonthBtn;
    }

    public void setName(String name) {
        super.setName(name);
        this.getDatasetField().setName(name);
    }

    private int indexOf(Object[] objs, Object o) {
        int i = 0;
        while (i < objs.length) {
            if (objs[i].equals(o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public DatasetField getDatasetField() {
        return this.dsField;
    }

    public void setParent(Container part) {
        super.setParent(part);
        if (this.dsField != null) {
            this.dsField.setDataset(DataSetFieldUtil.findDataset(this.getParent()));
        }
    }

    public void setDatasetField(DatasetField field) {
        this.dsField = field;
        this.dsField.setName(this.getName());
        this.dsField.setDataset(DataSetFieldUtil.findDataset(this.getParent()));
    }
}

