/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models.io;

import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.DatasetField;
import aurora.ide.meta.gef.editors.models.FootRenderer;
import aurora.ide.meta.gef.editors.models.GridColumn;
import aurora.ide.meta.gef.editors.models.Renderer;
import aurora.ide.meta.gef.editors.models.io.DatasetFieldHandler;
import aurora.ide.meta.gef.editors.models.io.DefaultIOHandler;
import aurora.ide.meta.gef.editors.models.io.FootRendererHandler;
import aurora.ide.meta.gef.editors.models.io.RendererHandler;
import org.eclipse.draw2d.geometry.Dimension;
import uncertain.composite.CompositeMap;

public class GridColumnHandler
extends DefaultIOHandler {
    public static final String COMMENT_COLUMN = "column";
    public static final String RENDERER_TYPE = "rendererType";

    protected void storeSimpleAttribute(CompositeMap map, AuroraComponent ac) {
        GridColumn gc = (GridColumn)ac;
        map.put((Object)"prompt", (Object)gc.getPrompt());
        map.put((Object)"width", (Object)gc.getSize().width);
        map.put((Object)"editor", (Object)gc.getEditor());
    }

    protected void storeComplexAttribute(CompositeMap map, AuroraComponent ac) {
        GridColumn gc = (GridColumn)ac;
        DatasetFieldHandler dsf = new DatasetFieldHandler();
        CompositeMap dsMap = dsf.toCompositeMap(gc.getDatasetField(), this.mic);
        map.addChild(dsMap);
        CompositeMap rMap = new RendererHandler().toCompositeMap(gc.getRenderer(), this.mic);
        map.addChild(rMap);
        FootRenderer fr = gc.getFootRenderer();
        if (fr.isEnabled()) {
            map.addChild(new FootRendererHandler().toCompositeMap(fr, this.mic));
        }
    }

    protected void restoreSimpleAttribute(AuroraComponent ac, CompositeMap map) {
        GridColumn gc = (GridColumn)ac;
        gc.setPrompt(map.getString((Object)"prompt"));
        gc.setSize(new Dimension(map.getInt((Object)"width").intValue(), gc.getSize().height));
        gc.setEditor(map.getString((Object)"editor"));
    }

    protected void restoreComplexAttribute(AuroraComponent ac, CompositeMap map) {
        AuroraComponent r;
        CompositeMap rMap;
        GridColumn gc = (GridColumn)ac;
        CompositeMap dfMap = map.getChild(DatasetField.class.getSimpleName());
        if (dfMap != null) {
            DatasetField df = new DatasetFieldHandler().fromCompositeMap(dfMap, this.mic);
            gc.setDatasetField(df);
        }
        if ((rMap = map.getChild(Renderer.class.getSimpleName())) != null) {
            r = (Renderer)new RendererHandler().fromCompositeMap(rMap, this.mic);
            gc.setRenderer((Renderer)r);
        }
        if ((rMap = map.getChild(FootRenderer.class.getSimpleName())) != null) {
            r = (FootRenderer)new FootRendererHandler().fromCompositeMap(rMap, this.mic);
            gc.setFootRenderer((FootRenderer)r);
        }
    }

    protected AuroraComponent getNewObject(CompositeMap map) {
        return new GridColumn();
    }
}

