/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models.io;

import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.CheckBox;
import aurora.ide.meta.gef.editors.models.DatasetField;
import aurora.ide.meta.gef.editors.models.Input;
import aurora.ide.meta.gef.editors.models.io.DatasetFieldHandler;
import aurora.ide.meta.gef.editors.models.io.DefaultIOHandler;
import org.eclipse.draw2d.geometry.Dimension;
import uncertain.composite.CompositeMap;

public class InputHandler
extends DefaultIOHandler {
    protected void storeSimpleAttribute(CompositeMap map, AuroraComponent ac) {
        Input input = (Input)ac;
        String type = input.getType();
        map.put((Object)"prompt", (Object)input.getPrompt());
        map.put((Object)"type", (Object)type);
        map.put((Object)"width", (Object)input.getSize().width);
        map.put((Object)"emptyText", (Object)input.getEmptyText());
        map.put((Object)"typeCase", (Object)input.getTypeCase());
        if (input instanceof CheckBox) {
            map.put((Object)"text", (Object)((CheckBox)input).getText());
        }
    }

    protected void storeComplexAttribute(CompositeMap map, AuroraComponent ac) {
        Input input = (Input)ac;
        DatasetField df = input.getDatasetField();
        CompositeMap dfMap = new DatasetFieldHandler().toCompositeMap(df, this.mic);
        map.addChild(dfMap);
    }

    protected void restoreSimpleAttribute(AuroraComponent ac, CompositeMap map) {
        Input input = (Input)ac;
        input.setPrompt(map.getString((Object)"prompt"));
        input.setType(map.getString((Object)"type"));
        input.setSize(new Dimension(map.getInt((Object)"width").intValue(), input.getSize().height));
        input.setEmptyText(map.getString((Object)"emptyText"));
        input.setTypeCase(map.getString((Object)"typeCase"));
        if (input instanceof CheckBox) {
            ((CheckBox)input).setText(map.getString((Object)"text"));
        }
    }

    protected void restoreComplexAttribute(AuroraComponent ac, CompositeMap map) {
        Input input = (Input)ac;
        CompositeMap dfMap = map.getChild(DatasetField.class.getSimpleName());
        if (dfMap != null) {
            DatasetField df = new DatasetFieldHandler().fromCompositeMap(dfMap, this.mic);
            input.setDatasetField(df);
        }
    }

    protected AuroraComponent getNewObject(CompositeMap map) {
        if ("checkBox".equals(map.getName())) {
            return new CheckBox();
        }
        return new Input();
    }
}

