/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.property;

import aurora.ide.meta.gef.editors.ImagesUtils;
import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.FieldSet;
import aurora.ide.meta.gef.editors.models.Form;
import aurora.ide.meta.gef.editors.models.Grid;
import aurora.ide.meta.gef.editors.models.HBox;
import aurora.ide.meta.gef.editors.models.TabFolder;
import aurora.ide.meta.gef.editors.models.TabItem;
import aurora.ide.meta.gef.editors.models.VBox;
import aurora.ide.meta.gef.editors.models.commands.ChangePropertyCommand;
import aurora.ide.meta.gef.editors.property.IPropertySource2;
import java.util.HashMap;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;

public class PropertySourceUtil {
    private static final HashMap<IPropertySource2, IPropertySource> map = new HashMap(128);

    public static IPropertySource translate(IPropertySource2 ps2, CommandStack cmdStack) {
        IPropertySource ps = map.get(ps2);
        if (ps == null) {
            ps = new ChangePropertyCommand(ps2, cmdStack);
            map.put(ps2, ps);
        }
        return ps;
    }

    public static Image getImageOf(AuroraComponent ac) {
        if (ac instanceof Form) {
            return ImagesUtils.getImage("palette/form.png");
        }
        if (ac instanceof VBox) {
            return ImagesUtils.getImage("palette/vbox.png");
        }
        if (ac instanceof HBox) {
            return ImagesUtils.getImage("palette/hbox.png");
        }
        if (ac instanceof FieldSet) {
            return ImagesUtils.getImage("palette/fieldset.png");
        }
        if (ac instanceof Grid) {
            return ImagesUtils.getImage("palette/grid.png");
        }
        if (ac instanceof TabFolder) {
            return ImagesUtils.getImage("palette/tabfolder.png");
        }
        if (ac instanceof TabItem) {
            return ImagesUtils.getImage("palette/tabitem.png");
        }
        return null;
    }
}

