/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.property;

import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.property.PropertyItem;
import java.util.ArrayList;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertySheetEntry;

public class PropertyViewer
extends Canvas
implements PaintListener,
MouseListener,
MouseMoveListener,
MouseTrackListener {
    static final int LABELSTART = 5;
    static final int EDITORSTART = 3;
    static final int ROWHEIGHT = 20;
    static final int MINWIDTHLEFT = 30;
    static final int MINWIDTHRIGHT = 40;
    static final String EMPTYTEXT = "<No Properties>";
    private ArrayList<PropertyItem> als = new ArrayList();
    private int splitLineX = 80;
    private boolean canResize = true;
    private boolean resizing = false;

    public PropertyViewer(Composite parent, int style) {
        super(parent, style);
        if (parent instanceof ScrolledComposite) {
            ((ScrolledComposite)parent).getVerticalBar().setIncrement(20);
        }
        this.addPaintListener(this);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addMouseTrackListener(this);
        this.setDragDetect(false);
    }

    public PropertyItem[] getItems() {
        PropertyItem[] pis = new PropertyItem[this.als.size()];
        int i = 0;
        while (i < pis.length) {
            pis[i] = this.als.get(i);
            ++i;
        }
        return pis;
    }

    public int getItemCount() {
        return this.als.size();
    }

    public void removeItem(PropertyItem pi) {
        this.als.remove(pi);
        this.redraw();
    }

    public PropertyItem createItem(IPropertySheetEntry pse, int index) {
        PropertyItem pi = new PropertyItem(pse);
        this.als.add(index, pi);
        Composite par = this.getParent();
        if (par instanceof ScrolledComposite) {
            ((ScrolledComposite)par).setMinSize(160, this.getItemCount() * 20);
        }
        this.redraw();
        return pi;
    }

    public void removeAll() {
        this.als.clear();
        this.redraw();
    }

    public void paintControl(PaintEvent e) {
        if (this.als.size() == 0) {
            this.drawEmpty(e.gc);
            return;
        }
        e.gc.setForeground(ColorConstants.BLACK);
        Point size = this.getSize();
        int i = 0;
        while (i < this.als.size()) {
            PropertyItem pi = this.als.get(i);
            int y = i * 20;
            this.drawString(e.gc, pi.getLabel(), 5, y, 20, this.splitLineX - 5);
            Control ctrl = pi.getControl((Composite)this);
            ctrl.setBounds(this.splitLineX + 3, y + 2, size.x - this.splitLineX - 3 - 1, 17);
            if (!ctrl.isVisible()) {
                ctrl.setVisible(true);
            }
            ++i;
        }
        e.gc.setForeground(ColorConstants.FIELDSET_BORDER);
        e.gc.drawRectangle(0, 0, size.x - 1, size.y - 1);
        i = 1;
        while (i < this.als.size() + 1) {
            e.gc.drawLine(0, i * 20, size.x, i * 20);
            ++i;
        }
        e.gc.drawLine(this.splitLineX, 0, this.splitLineX, size.y);
    }

    private void drawEmpty(GC gc) {
        gc.setForeground(ColorConstants.TITLETEXT);
        Dimension dim = FigureUtilities.getTextExtents((String)EMPTYTEXT, (Font)this.getFont());
        Point size = this.getSize();
        gc.drawString(EMPTYTEXT, (size.x - dim.width) / 2, (size.y - dim.height) / 2);
        gc.setForeground(ColorConstants.FIELDSET_BORDER);
        gc.drawRectangle(0, 0, size.x - 1, size.y - 1);
    }

    private void drawString(GC gc, String text, int x, int y, int height, int width) {
        Color fgc = ColorConstants.BLACK;
        if (text.charAt(0) == '*') {
            text = text.substring(1);
            fgc = new Color(null, 4, 168, 118);
        }
        Dimension dim = FigureUtilities.getTextExtents((String)text, (Font)this.getFont());
        StringBuilder sb = new StringBuilder(text.length() + 3);
        sb.append(text);
        sb.append("...");
        while (dim.width > width && sb.length() >= 4) {
            sb.deleteCharAt(sb.length() - 4);
            dim = FigureUtilities.getTextExtents((String)sb.toString(), (Font)this.getFont());
            text = sb.toString();
        }
        gc.setForeground(fgc);
        gc.drawString(text, x, y + (height - dim.height) / 2);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (this.canResize) {
            this.resizing = true;
        }
    }

    public void mouseUp(MouseEvent e) {
        this.resizing = false;
    }

    public void mouseMove(MouseEvent e) {
        int mx = e.x;
        if (mx >= this.splitLineX - 1 && mx <= this.splitLineX + 1) {
            this.setCursor(Display.getCurrent().getSystemCursor(9));
            this.canResize = true;
        } else {
            this.setCursor(Display.getCurrent().getSystemCursor(0));
            this.canResize = false;
        }
        if (this.resizing) {
            if (mx < 30 || mx > this.getSize().x - 40) {
                return;
            }
            this.splitLineX = mx;
            this.setCursor(Display.getCurrent().getSystemCursor(9));
            this.redraw();
        }
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
        this.resizing = false;
        this.setCursor(Display.getCurrent().getSystemCursor(0));
    }

    public void mouseHover(MouseEvent e) {
        if (this.als.size() == 0) {
            this.setToolTipText("No Properties");
            return;
        }
        int idx = e.y / 20;
        if (idx < 0 || idx >= this.als.size()) {
            this.setToolTipText(null);
            return;
        }
        PropertyItem pi = this.als.get(idx);
        String label = pi.getLabel();
        if (label.charAt(0) == '*') {
            label = label.substring(1);
        }
        this.setToolTipText(label);
    }
}

