/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.source.gen.core;

import aurora.ide.meta.gef.Util;
import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.Dataset;
import aurora.ide.meta.gef.editors.models.DatasetBinder;
import aurora.ide.meta.gef.editors.models.Grid;
import aurora.ide.meta.gef.editors.models.QueryContainer;
import aurora.ide.meta.gef.editors.models.QueryDataSet;
import aurora.ide.meta.gef.editors.models.ResultDataSet;
import aurora.ide.meta.gef.editors.source.gen.ComboDataset;
import aurora.ide.meta.gef.editors.source.gen.core.ScreenGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;

class DatasetGenerator {
    private ScreenGenerator sg;
    private Map<Dataset, String> datasetMaper = new HashMap<Dataset, String>();
    private List<ComboDataset> createdComboDatasets = new ArrayList<ComboDataset>();

    DatasetGenerator(ScreenGenerator sg) {
        this.sg = sg;
    }

    public CompositeMap fillDatasets(Container ac) {
        Dataset dataset = this.findDataset(ac);
        return this.fillDatasetsMap(dataset);
    }

    CompositeMap fillDatasetsMap(Dataset dataset) {
        if (dataset instanceof ComboDataset) {
            return this.fillComboDatasetMap((ComboDataset)dataset);
        }
        CompositeMap datasets = this.sg.getDatasetsMap();
        if (dataset == null) {
            return null;
        }
        String dsID = this.getOrCreateDSID(dataset);
        CompositeMap dsMap = datasets.getChildByAttrib((Object)"id", (Object)dsID);
        if (dsMap == null) {
            CompositeMap rds = this.createDatasetMap(dsID, dataset);
            datasets.addChild(rds);
            return rds;
        }
        return dsMap;
    }

    private CompositeMap fillComboDatasetMap(ComboDataset dataset) {
        CompositeMap datasets = this.sg.getDatasetsMap();
        if (dataset == null) {
            return null;
        }
        String dsID = this.getOrCreateDSID(dataset = this.getCreateComboDataset(dataset));
        CompositeMap dsMap = datasets.getChildByAttrib((Object)"id", (Object)dsID);
        if (dsMap == null) {
            CompositeMap rds = this.createComboDatasetMap(dsID, dataset);
            datasets.addChild(rds);
            return rds;
        }
        return dsMap;
    }

    private ComboDataset getCreateComboDataset(ComboDataset ds) {
        for (ComboDataset cds : this.createdComboDatasets) {
            if (!ds.getModel().equals(cds.getModel())) continue;
            if (ds.getLookupCode() == cds.getLookupCode()) {
                return cds;
            }
            if (ds.getLookupCode() == null || !ds.getLookupCode().equals(cds.getLookupCode())) continue;
            return cds;
        }
        this.createdComboDatasets.add(ds);
        return ds;
    }

    private CompositeMap createComboDatasetMap(String id, ComboDataset dataset) {
        CompositeMap rds = this.sg.getA2Map().toCompositMap(dataset);
        rds.put((Object)"id", (Object)id);
        rds.put((Object)"autoCreate", (Object)true);
        rds.put((Object)"model", (Object)dataset.getModel());
        rds.put((Object)"loadData", (Object)true);
        String lookupCode = dataset.getLookupCode();
        if (lookupCode != null) {
            rds.put((Object)"lookupCode", (Object)lookupCode);
        }
        rds.remove((Object)"pageSize");
        return rds;
    }

    public String getOrCreateDSID(Dataset dataset) {
        String dsID = this.datasetMaper.get(dataset);
        if (dsID == null) {
            dsID = this.sg.getIdGenerator().genDatasetID(dataset);
            this.datasetMaper.put(dataset, dsID);
        }
        return dsID;
    }

    public CompositeMap createDatasetMap(String id, Dataset dataset) {
        CompositeMap rds = this.sg.getA2Map().toCompositMap(dataset);
        rds.put((Object)"id", (Object)id);
        if (dataset.isUse4Query()) {
            rds.put((Object)"autoCreate", (Object)true);
        } else {
            rds.put((Object)"model", (Object)dataset.getModel());
        }
        QueryContainer qs = (QueryContainer)dataset.getPropertyValue("queryContainer");
        if (qs != null) {
            Container target = qs.getTarget();
            if (target != null) {
                Dataset ds = this.findDataset(target);
                String qds = this.fillDatasetsMap(ds).getString((Object)"id", "");
                if (ds instanceof QueryDataSet) {
                    rds.put((Object)"queryDataSet", (Object)qds.toString());
                }
                if (ds instanceof ResultDataSet) {
                    rds.put((Object)"bindName", (Object)rds.getString((Object)"id", ""));
                    rds.put((Object)"bindTarget", (Object)qds);
                }
            } else {
                rds.put((Object)"autoQuery", (Object)true);
                rds.put((Object)"pageSize", null);
            }
        }
        return rds;
    }

    public void bindDatasetMap(Container parent, AuroraComponent ac, CompositeMap child) {
        if (ac instanceof DatasetBinder) {
            Dataset dataset = null;
            dataset = ac instanceof Grid ? this.findDataset((Grid)ac) : this.findDataset(parent);
            if (dataset != null) {
                CompositeMap ds = this.fillDatasetsMap(dataset);
                child.put((Object)"bindTarget", ds.get((Object)"id"));
            }
        }
    }

    public void fillDatasetMap(Dataset dataset, AuroraComponent ac) {
        if (ac.getName() == null || "".equals(ac.getName())) {
            return;
        }
        CompositeMap dsMap = this.fillDatasetsMap(dataset);
        if (dsMap == null) {
            return;
        }
        this.sg.getA2Map().bindDatasetField(dsMap, dataset, ac);
    }

    public Dataset findDataset(Container container) {
        return Util.findDataset(container);
    }

    public String findDatasetId(Container container) {
        Dataset findDataset = this.findDataset(container);
        return this.datasetMaper.get(findDataset);
    }
}

