/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.source.gen.core;

import aurora.ide.meta.exception.TemplateNotBindedException;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.ILink;
import aurora.ide.meta.gef.editors.models.ViewDiagram;
import aurora.ide.meta.gef.editors.models.link.Parameter;
import aurora.ide.meta.gef.editors.source.gen.core.ScreenGenerator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import uncertain.composite.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DisplayScreenGenerator
extends ScreenGenerator {
    private ILink link;

    public DisplayScreenGenerator(IProject project, ILink link, IFile file) {
        super(project, file);
        this.link = link;
    }

    @Override
    public CompositeMap genCompositeMap(ViewDiagram view) throws TemplateNotBindedException {
        view.getBindTemplate();
        this.init(view);
        this.run(view);
        this.bindModelQueryPara();
        return this.getScreenMap();
    }

    private void bindModelQueryPara() {
        ViewDiagram viewDiagram = this.getViewDiagram();
        List<Container> sectionContainers = viewDiagram.getSectionContainers(viewDiagram, new String[]{"SECTION_TYPE_QUERY", "SECTION_TYPE_RESULT"});
        List<Parameter> parameters = this.link.getParameters();
        for (Container container : sectionContainers) {
            String model;
            String findDatasetId = this.findDatasetId(container);
            CompositeMap datasetsMap = this.getDatasetsMap();
            CompositeMap childByAttrib = datasetsMap.getChildByAttrib((Object)"id", (Object)findDatasetId);
            if (childByAttrib == null || "".equals(model = childByAttrib.getString((Object)"model", ""))) continue;
            String queryUrl = this.getQueryUrl(model, parameters);
            if (this.isBindTarget(container)) continue;
            childByAttrib.put((Object)"queryUrl", (Object)queryUrl);
            childByAttrib.put((Object)"loadData", (Object)true);
        }
    }

    private boolean isBindTarget(Container c) {
        return false;
    }

    private String getQueryUrl(String model, List<Parameter> parameters) {
        String request = "${/request/@context_path}/autocrud/";
        StringBuilder sb = new StringBuilder(request);
        String query = "/query?";
        sb.append(model).append(query);
        String kv = "key=${/parameter/@key}";
        int i = 0;
        while (i < parameters.size()) {
            String name = parameters.get(i).getName();
            kv = kv.replaceAll("key", name);
            sb.append(kv);
            if (i < parameters.size() - 1) {
                sb.append("&");
            }
            ++i;
        }
        return sb.toString();
    }
}

