/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.wizard.dialog;

import aurora.ide.builder.ResourceUtil;
import aurora.ide.meta.gef.editors.models.GridColumn;
import aurora.ide.meta.gef.editors.models.Renderer;
import aurora.ide.meta.gef.editors.wizard.SetLinkOrRefWizardPage;
import aurora.ide.meta.gef.editors.wizard.dialog.PComposite;
import aurora.ide.meta.gef.i18n.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CridColumnDialog
extends Dialog {
    private GridColumn gridColumn;
    private Renderer renderer;
    private SetLinkOrRefWizardPage page;

    public CridColumnDialog(SetLinkOrRefWizardPage page) {
        super(page.getShell());
        this.page = page;
        this.renderer = new Renderer();
        this.gridColumn = new GridColumn();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label lbl = new Label(composite, 0);
        lbl.setText(Messages.CridColumnDialog_Prompt);
        Text txtPrompt = new Text(composite, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        txtPrompt.setLayoutData((Object)gd);
        txtPrompt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CridColumnDialog.this.gridColumn.setPrompt(CridColumnDialog.this.getTextString((Text)e.getSource()));
                CridColumnDialog.this.setOKButtonEnabled();
            }
        });
        lbl = new Label(composite, 0);
        lbl.setText(Messages.CridColumnDialog_Show);
        Text txtTitle = new Text(composite, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        txtTitle.setLayoutData((Object)gd);
        txtTitle.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CridColumnDialog.this.renderer.setLabelText(CridColumnDialog.this.getTextString((Text)e.getSource()));
                CridColumnDialog.this.setOKButtonEnabled();
            }
        });
        lbl = new Label(composite, 0);
        lbl.setText(Messages.CridColumnDialog_Target);
        final Text txtUrl = new Text(composite, 2048);
        txtUrl.setLayoutData((Object)new GridData(768));
        txtUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String webHome = ResourceUtil.getWebHome((IProject)CridColumnDialog.this.page.getAuroraProject());
                String path = CridColumnDialog.this.getTextString((Text)e.getSource());
                if (path.endsWith("uip")) {
                    path = path.substring(path.indexOf("ui_prototype") + "ui_prototype".length());
                } else if (path.endsWith("screen")) {
                    path = path.substring(path.indexOf(webHome) + webHome.length());
                }
                CridColumnDialog.this.renderer.setOpenPath(path);
                CridColumnDialog.this.setOKButtonEnabled();
            }
        });
        Button btnOpen = new Button(composite, 0);
        btnOpen.setText(Messages.CridColumnDialog_Select);
        btnOpen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String webHome = ResourceUtil.getWebHome((IProject)CridColumnDialog.this.page.getAuroraProject());
                IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(webHome);
                IFolder uipFolder = CridColumnDialog.this.page.getMetaProject().getFolder("ui_prototype");
                Object obj = CridColumnDialog.this.page.fileSelect(new IContainer[]{(IContainer)res, uipFolder}, new String[]{"screen", "uip"});
                if (obj instanceof IFile) {
                    String path = ((IFile)obj).getFullPath().toString();
                    txtUrl.setText(path);
                }
            }
        });
        Group group = new Group(container, 0);
        group.setText(Messages.CridColumnDialog_ParSetting);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(1808));
        PComposite pComposite = new PComposite((Composite)group, this.renderer.getParameters(), 0);
        pComposite.setLayoutData(new GridData(1808));
        return container;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getButton(0).setEnabled(false);
        return control;
    }

    private String getTextString(Text txt) {
        String s = txt.getText();
        if (s == null || "".equals(s.trim())) {
            this.getButton(0).setEnabled(false);
            return "";
        }
        return s;
    }

    private void setOKButtonEnabled() {
        if ("".equals(this.renderer.getLabelText()) || this.renderer.getLabelText() == null) {
            this.getButton(0).setEnabled(false);
        } else if ("".equals(this.renderer.getOpenPath()) || this.renderer.getOpenPath() == null) {
            this.getButton(0).setEnabled(false);
        } else if ("".equals(this.gridColumn.getPrompt()) || this.gridColumn.getPrompt() == null) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
    }

    protected void okPressed() {
        this.renderer.setRendererType("PAGE_REDIRECT");
        this.gridColumn.setRenderer(this.renderer);
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(400, 350);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Add GridColumn Link");
    }

    public GridColumn getGridColumn() {
        return this.gridColumn;
    }

    public void setGridColumn(GridColumn gridColumn) {
        this.gridColumn = gridColumn;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }
}

