/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.popup.actions;

import aurora.ide.bm.AuroraDataBase;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.StatusUtil;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.designer.gen.SqlGenerator;
import aurora.ide.meta.gef.designer.model.BMModel;
import aurora.ide.meta.gef.designer.model.ModelUtil;
import aurora.ide.meta.gef.designer.wizard.CreateTableWizard;
import aurora.ide.meta.popup.actions.Messages;
import aurora.ide.meta.project.AuroraMetaProject;
import aurora.ide.search.cache.CacheManager;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import uncertain.composite.CompositeMap;

public class AutoCreateTableAction
implements IObjectActionDelegate,
IRunnableWithProgress {
    private Shell shell;
    private ArrayList<IFile> als = new ArrayList();
    private ArrayList<IStatus> errorMsgs = new ArrayList();
    private Connection conn;
    private Statement stmt;
    private HashMap<String, Boolean> config;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    boolean initdb() {
        try {
            IProject proj = this.als.get(0).getProject();
            AuroraMetaProject amp = new AuroraMetaProject(proj);
            IProject project = amp.getAuroraProject();
            this.conn = new AuroraDataBase(project).getDBConnection();
            this.stmt = this.conn.createStatement();
        }
        catch (ApplicationException e) {
            StatusUtil.showExceptionDialog((Shell)this.shell, (String)"Error", (String)Messages.AutoCreateTableAction_1, (boolean)true, (Throwable)e);
            return false;
        }
        catch (SQLException e) {
            StatusUtil.showExceptionDialog((Shell)this.shell, (String)"Error", (String)Messages.AutoCreateTableAction_3, (boolean)true, (Throwable)e);
            return false;
        }
        catch (ResourceNotFoundException e) {
            StatusUtil.showExceptionDialog((Shell)this.shell, (String)"Error", (String)Messages.AutoCreateTableAction_5, (boolean)true, (Throwable)e);
            return false;
        }
        return true;
    }

    void closedb() {
        if (this.stmt != null) {
            try {
                this.stmt.close();
            }
            catch (SQLException sQLException) {}
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public void run(IAction action) {
        if (this.als.size() == 0) {
            return;
        }
        this.errorMsgs.clear();
        if (!this.initdb()) {
            return;
        }
        CreateTableWizard ctw = new CreateTableWizard();
        ctw.setStatement(this.stmt);
        ctw.setSelection(this.als);
        WizardDialog wd = new WizardDialog(this.shell, (IWizard)ctw);
        if (wd.open() == 0) {
            this.config = ctw.getConfig();
            this.execute();
        }
        this.closedb();
    }

    private void execute() {
        try {
            new ProgressMonitorDialog(null).run(false, true, (IRunnableWithProgress)this);
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        if (this.errorMsgs.size() > 0) {
            MultiStatus status = new MultiStatus("aurora.ide.meta", 4, this.getStatusChildren(), null, null);
            ErrorDialog.openError((Shell)this.shell, (String)Messages.AutoCreateTableAction_6, (String)Messages.AutoCreateTableAction_7, (IStatus)status);
            return;
        }
        MessageBox mb = new MessageBox(this.shell, 2);
        mb.setText(Messages.AutoCreateTableAction_8);
        mb.setMessage(Messages.AutoCreateTableAction_9);
        mb.open();
    }

    /*
     * Unable to fully structure code
     */
    private void createTable(String[] sqls, String tableName) throws SQLException {
        block4: {
            block5: {
                try {
                    var6_3 = sqls;
                    var5_5 = sqls.length;
                    var4_7 = 0;
                    while (var4_7 < var5_5) {
                        s = var6_3[var4_7];
                        this.stmt.executeUpdate(s);
                        ++var4_7;
                    }
                    break block4;
                }
                catch (SQLException e) {
                    if (e.getMessage().indexOf("ORA-00955") == -1) break block5;
                    this.stmt.executeUpdate("drop table " + tableName);
                    var7_12 = sqls;
                    var6_4 = sqls.length;
                    var5_6 = 0;
                    ** while (var5_6 < var6_4)
                }
lbl-1000:
                // 1 sources

                {
                    s = var7_12[var5_6];
                    this.stmt.executeUpdate(s);
                    ++var5_6;
                    continue;
lbl25:
                    // 1 sources

                    break block4;
                }
            }
            s = new Status(2, "aurora.ide.meta", NLS.bind((String)Messages.AutoCreateTableAction_13, (Object)tableName), (Throwable)e);
            this.errorMsgs.add((IStatus)s);
        }
    }

    private void createSequence(String seqName) throws SQLException {
        try {
            this.stmt.executeUpdate(NLS.bind((String)Messages.AutoCreateTableAction_15, (Object)seqName));
        }
        catch (SQLException e) {
            if (e.getMessage().indexOf("ORA-00955") != -1) {
                this.stmt.executeUpdate(NLS.bind((String)Messages.AutoCreateTableAction_17, (Object)seqName));
                this.stmt.executeUpdate(NLS.bind((String)Messages.AutoCreateTableAction_15, (Object)seqName));
            }
            Status s = new Status(2, "aurora.ide.meta", NLS.bind((String)Messages.AutoCreateTableAction_19, (Object)seqName), (Throwable)e);
            this.errorMsgs.add((IStatus)s);
        }
    }

    private IStatus[] getStatusChildren() {
        IStatus[] ss = new IStatus[this.als.size()];
        return this.errorMsgs.toArray(ss);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.als.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object obj : ss) {
                if (!(obj instanceof IFile) || !((IFile)obj).getName().endsWith(".bmq")) continue;
                this.als.add((IFile)obj);
            }
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(Messages.AutoCreateTableAction_22, this.config.size());
        for (IFile file : this.als) {
            try {
                CompositeMap map = CacheManager.getCompositeMap((IFile)file);
                BMModel model = ModelUtil.fromCompositeMap(map);
                SqlGenerator sqlg = new SqlGenerator(model, file.getFullPath().removeFileExtension().lastSegment());
                String[] sqls = sqlg.gen();
                try {
                    String tableName = file.getFullPath().removeFileExtension().lastSegment().toLowerCase();
                    String seqName = String.valueOf(tableName) + "_s";
                    if (this.config.get(tableName).booleanValue()) {
                        monitor.subTask(NLS.bind((String)Messages.AutoCreateTableAction_24, (Object)tableName));
                        this.createTable(sqls, tableName);
                    }
                    monitor.worked(1);
                    if (this.config.get(seqName).booleanValue()) {
                        monitor.subTask(NLS.bind((String)Messages.AutoCreateTableAction_26, (Object)seqName));
                        this.createSequence(seqName);
                    }
                    monitor.worked(1);
                }
                catch (SQLException e) {
                    Status s = new Status(4, "aurora.ide.meta", NLS.bind((String)Messages.AutoCreateTableAction_28, (Object)e.getMessage()), (Throwable)e);
                    this.errorMsgs.add((IStatus)s);
                }
            }
            catch (Exception e) {
                Status s = new Status(4, "aurora.ide.meta", NLS.bind((String)Messages.AutoCreateTableAction_29, (Object)file.getFullPath()), (Throwable)e);
                this.errorMsgs.add((IStatus)s);
            }
        }
        monitor.done();
    }
}

