/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.gathering.monitors;

import org.eclipse.core.runtime.Platform;
import org.eclipse.epp.usagedata.internal.gathering.UsageDataCaptureActivator;
import org.eclipse.epp.usagedata.internal.gathering.monitors.UsageMonitor;
import org.eclipse.epp.usagedata.internal.gathering.services.UsageDataService;

public class SystemInfoMonitor
implements UsageMonitor {
    private static final String SYSINFO = "sysinfo";
    private static final String INFO_PROCESSORS = "processors";
    private static final String INFO_LOCALE = "locale";
    private static final String INFO_WS = "ws";
    private static final String INFO_ARCH = "arch";
    private static final String INFO_OS = "os";
    private static final String[] SYSTEM_PROPERTIES = new String[]{"java.runtime.name", "java.runtime.version", "java.specification.name", "java.specification.vendor", "java.specification.version", "java.vendor", "java.version", "java.vm.info", "java.vm.name", "java.vm.specification.name", "java.vm.specification.vendor", "java.vm.specification.version", "java.vm.vendor", "java.vm.version"};

    public void startMonitoring(UsageDataService usageDataService) {
        try {
            usageDataService.recordEvent(INFO_OS, SYSINFO, Platform.getOS(), null);
            usageDataService.recordEvent(INFO_ARCH, SYSINFO, Platform.getOSArch(), null);
            usageDataService.recordEvent(INFO_WS, SYSINFO, Platform.getWS(), null);
            usageDataService.recordEvent(INFO_LOCALE, SYSINFO, Platform.getNL(), null);
        }
        catch (Exception e) {
            UsageDataCaptureActivator.getDefault().logException("Exception occurred while obtaining platform properties.", e);
        }
        usageDataService.recordEvent(INFO_PROCESSORS, SYSINFO, String.valueOf(Runtime.getRuntime().availableProcessors()), null);
        String[] stringArray = SYSTEM_PROPERTIES;
        int n = SYSTEM_PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            usageDataService.recordEvent(property, SYSINFO, System.getProperty(property), null);
            ++n2;
        }
    }

    public void stopMonitoring() {
    }
}

