/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

public class Buffer {
    final byte[] tmp = new byte[4];
    byte[] buffer;
    int index;
    int s;

    public Buffer(int n) {
        this.buffer = new byte[n];
        this.index = 0;
        this.s = 0;
    }

    public Buffer(byte[] byArray) {
        this.buffer = byArray;
        this.index = 0;
        this.s = 0;
    }

    public Buffer() {
        this(20480);
    }

    public void putByte(byte by) {
        this.buffer[this.index++] = by;
    }

    public void putByte(byte[] byArray) {
        this.putByte(byArray, 0, byArray.length);
    }

    public void putByte(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this.buffer, this.index, n2);
        this.index += n2;
    }

    public void putString(byte[] byArray) {
        this.putString(byArray, 0, byArray.length);
    }

    public void putString(byte[] byArray, int n, int n2) {
        this.putInt(n2);
        this.putByte(byArray, n, n2);
    }

    public void putInt(int n) {
        this.tmp[0] = (byte)(n >>> 24);
        this.tmp[1] = (byte)(n >>> 16);
        this.tmp[2] = (byte)(n >>> 8);
        this.tmp[3] = (byte)n;
        System.arraycopy(this.tmp, 0, this.buffer, this.index, 4);
        this.index += 4;
    }

    public void putLong(long l) {
        this.tmp[0] = (byte)(l >>> 56);
        this.tmp[1] = (byte)(l >>> 48);
        this.tmp[2] = (byte)(l >>> 40);
        this.tmp[3] = (byte)(l >>> 32);
        System.arraycopy(this.tmp, 0, this.buffer, this.index, 4);
        this.tmp[0] = (byte)(l >>> 24);
        this.tmp[1] = (byte)(l >>> 16);
        this.tmp[2] = (byte)(l >>> 8);
        this.tmp[3] = (byte)l;
        System.arraycopy(this.tmp, 0, this.buffer, this.index + 4, 4);
        this.index += 8;
    }

    void skip(int n) {
        this.index += n;
    }

    void putPad(int n) {
        while (n > 0) {
            this.buffer[this.index++] = 0;
            --n;
        }
    }

    public void putMPInt(byte[] byArray) {
        int n = byArray.length;
        if ((byArray[0] & 0x80) != 0) {
            this.putInt(++n);
            this.putByte((byte)0);
        } else {
            this.putInt(n);
        }
        this.putByte(byArray);
    }

    public int getLength() {
        return this.index - this.s;
    }

    public int getOffSet() {
        return this.s;
    }

    public void setOffSet(int n) {
        this.s = n;
    }

    public long getLong() {
        long l = (long)this.getInt() & 0xFFFFFFFFL;
        l = l << 32 | (long)this.getInt() & 0xFFFFFFFFL;
        return l;
    }

    public int getInt() {
        int n = this.getShort();
        n = n << 16 & 0xFFFF0000 | this.getShort() & 0xFFFF;
        return n;
    }

    public long getUInt() {
        long l = 0L;
        long l2 = 0L;
        l = this.getByte();
        l = l << 8 & 0xFF00L | (long)(this.getByte() & 0xFF);
        l2 = this.getByte();
        l2 = l2 << 8 & 0xFF00L | (long)(this.getByte() & 0xFF);
        l = l << 16 & 0xFFFFFFFFFFFF0000L | l2 & 0xFFFFL;
        return l;
    }

    int getShort() {
        int n = this.getByte();
        n = n << 8 & 0xFF00 | this.getByte() & 0xFF;
        return n;
    }

    public int getByte() {
        return this.buffer[this.s++] & 0xFF;
    }

    public void getByte(byte[] byArray) {
        this.getByte(byArray, 0, byArray.length);
    }

    void getByte(byte[] byArray, int n, int n2) {
        System.arraycopy(this.buffer, this.s, byArray, n, n2);
        this.s += n2;
    }

    public int getByte(int n) {
        int n2 = this.s;
        this.s += n;
        return n2;
    }

    public byte[] getMPInt() {
        int n = this.getInt();
        if (n < 0 || n > 8192) {
            n = 8192;
        }
        byte[] byArray = new byte[n];
        this.getByte(byArray, 0, n);
        return byArray;
    }

    public byte[] getMPIntBits() {
        int n = this.getInt();
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        this.getByte(byArray, 0, n2);
        if ((byArray[0] & 0x80) != 0) {
            byte[] byArray2 = new byte[byArray.length + 1];
            byArray2[0] = 0;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            byArray = byArray2;
        }
        return byArray;
    }

    public byte[] getString() {
        int n = this.getInt();
        if (n < 0 || n > 262144) {
            n = 262144;
        }
        byte[] byArray = new byte[n];
        this.getByte(byArray, 0, n);
        return byArray;
    }

    byte[] getString(int[] nArray, int[] nArray2) {
        int n = this.getInt();
        nArray[0] = this.getByte(n);
        nArray2[0] = n;
        return this.buffer;
    }

    public void reset() {
        this.index = 0;
        this.s = 0;
    }

    public void shift() {
        if (this.s == 0) {
            return;
        }
        System.arraycopy(this.buffer, this.s, this.buffer, 0, this.index - this.s);
        this.index -= this.s;
        this.s = 0;
    }

    void rewind() {
        this.s = 0;
    }

    byte getCommand() {
        return this.buffer[5];
    }

    void checkFreeSize(int n) {
        if (this.buffer.length < this.index + n) {
            byte[] byArray = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, byArray, 0, this.index);
            this.buffer = byArray;
        }
    }
}

