/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.internal.jpql.util.Filter;
import org.eclipse.persistence.jpa.internal.jpql.util.NullFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JPQLQueryBNF {
    private Set<String> cachedFactories;
    private Map<String, ExpressionFactory> cachedIdentifiers;
    private Set<JPQLQueryBNF> childNonCompoundQueryBNFs;
    private Set<JPQLQueryBNF> childQueryBNFs;
    private List<String> children;
    private List<String> expressionFactories;
    private Boolean handleAggregate;
    private Boolean handleCollection;
    private String id;
    private boolean traversed;

    JPQLQueryBNF(String id) {
        this.id = id;
        this.expressionFactories = new ArrayList<String>();
        this.initialize();
    }

    void addChildren(Set<JPQLQueryBNF> queryBNFs, Filter<JPQLQueryBNF> filter) {
        if (this.children != null) {
            for (String id : this.children) {
                JPQLQueryBNF queryBNF = this.queryBNF(id);
                if (!queryBNFs.add(queryBNF) || !filter.accept(queryBNF)) continue;
                queryBNF.addChildren(queryBNFs, filter);
            }
        }
    }

    private Set<JPQLQueryBNF> buildChildren(Filter<JPQLQueryBNF> filter) {
        HashSet<JPQLQueryBNF> queryBNFs = new HashSet<JPQLQueryBNF>();
        queryBNFs.add(this);
        this.addChildren(queryBNFs, this.buildNonCompoundFilter());
        return queryBNFs;
    }

    private Map<String, ExpressionFactory> buildIdentifiers() {
        HashMap<String, ExpressionFactory> identifiers = new HashMap<String, ExpressionFactory>();
        for (String expressionFactoryId : this.expressionFactoryIds()) {
            ExpressionFactory expressionFactory = JPQLExpression.expressionFactory(expressionFactoryId);
            for (String identifier : expressionFactory.identifiers()) {
                identifiers.put(identifier, expressionFactory);
            }
        }
        return Collections.unmodifiableMap(identifiers);
    }

    private Filter<JPQLQueryBNF> buildNonCompoundFilter() {
        return new Filter<JPQLQueryBNF>(){

            @Override
            public boolean accept(JPQLQueryBNF queryBNF) {
                return !queryBNF.isCompound();
            }
        };
    }

    private boolean calculateHandleAggregate() {
        for (JPQLQueryBNF queryBNF : this.children()) {
            if (queryBNF == this || queryBNF.traversed) continue;
            queryBNF.traversed = true;
            if (queryBNF.handleAggregate()) {
                queryBNF.traversed = false;
                return true;
            }
            queryBNF.traversed = false;
        }
        return false;
    }

    private boolean calculateHandleCollection() {
        for (JPQLQueryBNF queryBNF : this.children()) {
            if (queryBNF == this || queryBNF.traversed) continue;
            queryBNF.traversed = true;
            if (queryBNF.handleCollection()) {
                queryBNF.traversed = false;
                return true;
            }
            queryBNF.traversed = false;
        }
        return false;
    }

    final Set<JPQLQueryBNF> children() {
        if (this.childQueryBNFs == null) {
            this.childQueryBNFs = this.buildChildren(NullFilter.<JPQLQueryBNF>instance());
        }
        return this.childQueryBNFs;
    }

    public final ExpressionFactory expressionFactory(String identifier) {
        this.populateIdentifiers();
        return this.cachedIdentifiers.get(identifier.toUpperCase());
    }

    public final Set<String> expressionFactoryIds() {
        if (this.cachedFactories == null) {
            this.cachedFactories = new HashSet<String>();
            this.cachedFactories.addAll(this.expressionFactories);
            for (JPQLQueryBNF queryBNF : this.children()) {
                if (queryBNF == this) continue;
                this.cachedFactories.addAll(queryBNF.expressionFactoryIds());
            }
        }
        return Collections.unmodifiableSet(this.cachedFactories);
    }

    String getFallbackBNFId() {
        return null;
    }

    String getFallbackExpressionFactoryId() {
        return null;
    }

    public final String getId() {
        return this.id;
    }

    public boolean handleAggregate() {
        if (this.handleAggregate == null) {
            this.handleAggregate = this.calculateHandleAggregate();
        }
        return this.handleAggregate;
    }

    public boolean handleCollection() {
        if (this.handleCollection == null) {
            this.handleCollection = this.calculateHandleCollection();
        }
        return this.handleCollection;
    }

    public final boolean hasIdentifier(String word) {
        this.populateIdentifiers();
        return this.cachedIdentifiers.containsKey(word);
    }

    public final Iterable<String> identifiers() {
        this.populateIdentifiers();
        return this.cachedIdentifiers.keySet();
    }

    void initialize() {
    }

    public boolean isCompound() {
        return false;
    }

    public final Set<JPQLQueryBNF> nonCompoundChildren() {
        if (this.childNonCompoundQueryBNFs == null) {
            this.childNonCompoundQueryBNFs = this.buildChildren(this.buildNonCompoundFilter());
        }
        return this.childNonCompoundQueryBNFs;
    }

    private void populateIdentifiers() {
        if (this.cachedIdentifiers == null) {
            this.cachedIdentifiers = this.buildIdentifiers();
        }
    }

    private JPQLQueryBNF queryBNF(String id) {
        return AbstractExpression.queryBNF(id);
    }

    final void registerChild(String queryBNF) {
        if (this.children == null) {
            this.children = new ArrayList<String>();
        }
        this.children.add(queryBNF);
    }

    final void registerExpressionFactory(String expressionFactory) {
        this.expressionFactories.add(expressionFactory);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("(id=");
        sb.append(this.id);
        sb.append(", expressionFactories=");
        sb.append(this.expressionFactories);
        sb.append(")");
        return sb.toString();
    }
}

