/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.web.core.internal.JsCoreMessages;
import org.eclipse.wst.jsdt.web.core.internal.JsCorePlugin;
import org.eclipse.wst.jsdt.web.core.internal.Logger;
import org.eclipse.wst.jsdt.web.core.internal.PathUtils;
import org.eclipse.wst.jsdt.web.core.internal.project.ModuleSourcePathProvider;
import org.eclipse.wst.sse.core.indexing.AbstractIndexManager;

public class JSWebResourceEventManager
extends AbstractIndexManager {
    private static JSWebResourceEventManager INSTANCE;
    private static final String DOT_PROJECT_FILE_NAME = ".project";
    private IPath fWorkingLocation;

    private JSWebResourceEventManager() {
        super(Messages.build_analyzingDeltas, Messages.build_analyzingDeltas, JsCoreMessages.model_initialization, Messages.manager_filesToIndex);
    }

    public static JSWebResourceEventManager getDefault() {
        return INSTANCE != null ? INSTANCE : (INSTANCE = new JSWebResourceEventManager());
    }

    protected boolean isResourceToIndex(int type, IPath path) {
        return type == 8 || type == 4 || type == 1 && DOT_PROJECT_FILE_NAME.equals(path.lastSegment());
    }

    protected void performAction(byte source, byte action, IResource resource, IPath movePath) {
        switch (action) {
            case 0: {
                if (!resource.getName().equals(DOT_PROJECT_FILE_NAME)) break;
                JSWebResourceEventManager.updateClassPathEntries(resource.getProject());
            }
        }
    }

    protected IPath getWorkingLocation() {
        if (this.fWorkingLocation == null) {
            IPath workingLocation = JsCorePlugin.getDefault().getStateLocation().append("resourceEventManager");
            File folder = new File(workingLocation.toOSString());
            if (!folder.isDirectory()) {
                try {
                    folder.mkdir();
                }
                catch (SecurityException e) {
                    Logger.logException(String.valueOf(this.getName()) + ": Error while creating state location: " + folder + " This renders the index manager irrevocably broken for this workspace session", e);
                }
            }
            this.fWorkingLocation = workingLocation;
        }
        return this.fWorkingLocation;
    }

    private static void updateClassPathEntries(IProject project) {
        try {
            if (project.hasNature("org.eclipse.wst.jsdt.core.jsNature") && ModuleCoreNature.isFlexibleProject((IProject)project)) {
                JavaProject jsProject = (JavaProject)JavaScriptCore.create((IProject)project);
                IIncludePathEntry[] oldEntries = jsProject.getRawIncludepath();
                ArrayList<IIncludePathEntry> updatedEntries = new ArrayList<IIncludePathEntry>();
                boolean updateIncludePath = false;
                int oldEntry = 0;
                while (oldEntry < oldEntries.length) {
                    IIncludePathAttribute[] entryAttributes = oldEntries[oldEntry].getExtraAttributes();
                    boolean isProvidedEntry = false;
                    int attribute = 0;
                    while (attribute < entryAttributes.length) {
                        isProvidedEntry = entryAttributes[attribute].getName().equals("provider") && entryAttributes[attribute].getValue().equals(ModuleSourcePathProvider.PROVIDER_ATTRIBUTE_KEY_VALUE);
                        updateIncludePath |= isProvidedEntry;
                        if (isProvidedEntry) {
                            IPath[] nonRelativeExclusionPaths = oldEntries[oldEntry].getExclusionPatterns();
                            int i = 0;
                            while (i < nonRelativeExclusionPaths.length) {
                                nonRelativeExclusionPaths[i] = oldEntries[oldEntry].getPath().append(nonRelativeExclusionPaths[i]);
                                ++i;
                            }
                            IPath[] nonRelativeInclusionPaths = oldEntries[oldEntry].getInclusionPatterns();
                            int i2 = 0;
                            while (i2 < nonRelativeInclusionPaths.length) {
                                nonRelativeInclusionPaths[i2] = oldEntries[oldEntry].getPath().append(nonRelativeInclusionPaths[i2]);
                                ++i2;
                            }
                            IResource[] roots = JSWebResourceEventManager.getRoots(project);
                            IIncludePathEntry[] resolvedEntries = jsProject.getResolvedClasspath();
                            int root = 0;
                            while (root < roots.length) {
                                IPath rootPath = roots[root].getFullPath();
                                boolean foundMatch = false;
                                int k = 0;
                                while (k < resolvedEntries.length) {
                                    if (resolvedEntries[k].getPath().equals((Object)rootPath)) {
                                        foundMatch = true;
                                        break;
                                    }
                                    ++k;
                                }
                                if (!foundMatch) {
                                    ArrayList<IPath> exclusionPatterns = new ArrayList<IPath>();
                                    int i3 = 0;
                                    while (i3 < nonRelativeExclusionPaths.length) {
                                        IPath parentRelativeExclusionPattern = PathUtils.makePatternRelativeToParent(nonRelativeExclusionPaths[i3], rootPath);
                                        if (parentRelativeExclusionPattern != null) {
                                            exclusionPatterns.add(parentRelativeExclusionPattern);
                                        }
                                        ++i3;
                                    }
                                    ArrayList<IPath> inclusionPatterns = new ArrayList<IPath>();
                                    int i4 = 0;
                                    while (i4 < nonRelativeInclusionPaths.length) {
                                        IPath parentRelativeInclusionPattern = PathUtils.makePatternRelativeToParent(nonRelativeInclusionPaths[i4], rootPath);
                                        if (parentRelativeInclusionPattern != null) {
                                            inclusionPatterns.add(parentRelativeInclusionPattern);
                                        }
                                        ++i4;
                                    }
                                    IPath[] exclusionPaths = exclusionPatterns.isEmpty() ? ClasspathEntry.EXCLUDE_NONE : exclusionPatterns.toArray(new IPath[exclusionPatterns.size()]);
                                    IPath[] inclusionPaths = inclusionPatterns.isEmpty() ? ClasspathEntry.INCLUDE_ALL : inclusionPatterns.toArray(new IPath[inclusionPatterns.size()]);
                                    IIncludePathEntry newEntry = JavaScriptCore.newSourceEntry((IPath)rootPath, (IPath[])inclusionPaths, (IPath[])exclusionPaths, null);
                                    updatedEntries.add(newEntry);
                                }
                                ++root;
                            }
                        }
                        ++attribute;
                    }
                    if (!isProvidedEntry) {
                        updatedEntries.add(oldEntries[oldEntry]);
                    }
                    ++oldEntry;
                }
                if (updateIncludePath) {
                    jsProject.setRawIncludepath(updatedEntries.toArray(new IIncludePathEntry[updatedEntries.size()]), jsProject.getOutputLocation(), null);
                }
            }
        }
        catch (CoreException e) {
            Logger.logException("Error while updating JavaScript includepath", e);
        }
    }

    private static IResource[] getRoots(IProject project) {
        IVirtualFile root = ComponentCore.createFile((IProject)project, (IPath)Path.ROOT);
        IResource[] underlyingResources = root.getUnderlyingResources();
        if (underlyingResources == null || underlyingResources.length == 0) {
            underlyingResources = new IResource[]{root.getUnderlyingResource()};
        }
        return underlyingResources;
    }
}

