/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.filter.ExtensiblityElementFilter;
import org.eclipse.wst.wsdl.ui.internal.text.WSDLModelAdapter;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.xsd.ui.internal.text.XSDModelQueryExtension;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDLModelQueryExtension
extends XSDModelQueryExtension {
    static /* synthetic */ Class class$0;

    protected boolean isParentElementMessageReference(String parentElementName) {
        return "input".equals(parentElementName) || "output".equals(parentElementName) || "fault".equals(parentElementName);
    }

    protected boolean isMessageReference(String elementName) {
        return "body".equals(elementName) || "header".equals(elementName) || "fault".equals(elementName) || "urlReplacement".equals(elementName) || "urlEncoded".equals(elementName);
    }

    public boolean isApplicableChildElement(Node parentNode, String namespace, String name) {
        boolean result = true;
        if (parentNode.getNodeType() == 1) {
            Element element = (Element)parentNode;
            String parentElementNamespaceURI = parentNode.getNamespaceURI();
            String parentElementName = parentNode.getLocalName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(parentElementNamespaceURI)) {
                if (parentElementName != null && name != null && namespace != null) {
                    if (namespace.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                        result = false;
                    } else if (namespace.equals("http://www.w3.org/2001/XMLSchema")) {
                        result = "types".equals(parentElementName) && "schema".equals(name);
                    } else if (namespace.equals("http://schemas.xmlsoap.org/wsdl/")) {
                        result = !name.equals("required");
                    } else {
                        ExtensiblityElementFilter filter = (ExtensiblityElementFilter)WSDLEditorPlugin.getInstance().getExtensiblityElementFilterRegistry().getProperty(namespace, "");
                        if (filter != null) {
                            result = filter.isValidContext(element, name);
                        }
                    }
                }
            } else {
                return super.isApplicableChildElement(parentNode, namespace, name);
            }
        }
        return result;
    }

    public String[] getAttributeValues(Element element, String namespace, String name) {
        if ("http://schemas.xmlsoap.org/wsdl/".equals(namespace)) {
            ArrayList list = new ArrayList();
            ComponentReferenceUtil util = new ComponentReferenceUtil(this.lookupOrCreateDefinition(element.getOwnerDocument()));
            String currentElementName = element.getLocalName();
            if (this.checkName(name, "message")) {
                list.addAll(util.getMessageNames());
            } else if (this.checkName(name, "binding")) {
                list.addAll(util.getBindingNames());
            } else if (this.checkName(name, "type")) {
                if (this.checkName(currentElementName, "binding")) {
                    list.addAll(util.getPortTypeNames());
                } else if (this.checkName(currentElementName, "part")) {
                    list.addAll(util.getComponentNameList(true));
                }
            } else if (this.checkName(name, "element") && this.checkName(currentElementName, "part")) {
                list.addAll(util.getComponentNameList(false));
            }
            String[] result = new String[list.size()];
            list.toArray(result);
            return result;
        }
        return super.getAttributeValues(element, namespace, name);
    }

    protected XSDSchema lookupOrCreateSchemaForElement(Element element) {
        return this.lookupOrCreateSchema(element);
    }

    private XSDSchema lookupOrCreateSchema(Element element) {
        XSDSchema schema = null;
        Definition definition = this.lookupOrCreateDefinition(element.getOwnerDocument());
        Object o = WSDLEditorUtil.getInstance().findModelObjectForElement(definition, element);
        if (o instanceof XSDConcreteComponent) {
            schema = ((XSDConcreteComponent)o).getSchema();
        }
        return schema;
    }

    protected Definition lookupOrCreateDefinition(Document document) {
        Definition definition = null;
        if (document instanceof INodeNotifier) {
            WSDLModelAdapter adapter;
            INodeNotifier notifier = (INodeNotifier)document;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.wsdl.ui.internal.text.WSDLModelAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (WSDLModelAdapter)notifier.getAdapterFor((Object)clazz)) == null) {
                adapter = new WSDLModelAdapter();
                notifier.addAdapter((INodeAdapter)adapter);
                adapter.createDefinition(document);
            }
            definition = adapter.getDefinition();
        }
        return definition;
    }

    protected TypesHelper getTypesHelper(final Element element) {
        XSDSchema schema = this.lookupOrCreateSchema(element);
        return new TypesHelper(schema){

            protected List getPrefixesForNamespace(String namespace) {
                List list = super.getPrefixesForNamespace(namespace);
                Definition definition = WSDLModelQueryExtension.this.lookupOrCreateDefinition(element.getOwnerDocument());
                if (definition != null) {
                    Map map = definition.getNamespaces();
                    Iterator i = map.keySet().iterator();
                    while (i.hasNext()) {
                        String prefix = (String)i.next();
                        String ns = (String)map.get(prefix);
                        if (ns == null || !ns.equals(namespace) || list.contains(prefix)) continue;
                        list.add(prefix);
                    }
                }
                return list;
            }
        };
    }

    protected Definition lookupOrCreateDefinition(Element element) {
        return this.lookupOrCreateDefinition(element.getOwnerDocument());
    }
}

