/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.common.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.ReadOnlyBaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinTable;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.JoinColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.GenericOrmReferenceTable;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinTable;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmJoinTable
extends GenericOrmReferenceTable<XmlJoinTable>
implements OrmJoinTable {
    protected final Vector<OrmJoinColumn> specifiedInverseJoinColumns = new Vector();
    protected final SpecifiedInverseJoinColumnContainerAdapter specifiedInverseJoinColumnContainerAdapter = new SpecifiedInverseJoinColumnContainerAdapter();
    protected final OrmJoinColumn.Owner inverseJoinColumnOwner = this.buildInverseJoinColumnOwner();
    protected OrmJoinColumn defaultInverseJoinColumn;

    public GenericOrmJoinTable(OrmJoinTableRelationshipStrategy parent, Table.Owner owner) {
        super(parent, owner);
        this.initializeSpecifiedInverseJoinColumns();
    }

    @Override
    protected OrmJoinColumn.Owner buildJoinColumnOwner() {
        return new JoinColumnOwner();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncSpecifiedInverseJoinColumns();
        if (this.defaultInverseJoinColumn != null) {
            this.defaultInverseJoinColumn.synchronizeWithResourceModel();
        }
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSpecifiedInverseJoinColumns());
        this.updateDefaultInverseJoinColumn();
    }

    @Override
    protected XmlJoinTable getXmlTable() {
        return this.getJoinStrategy().getXmlJoinTable();
    }

    @Override
    protected XmlJoinTable buildXmlTable() {
        return this.getJoinStrategy().buildXmlJoinTable();
    }

    @Override
    protected void removeXmlTable() {
        this.getJoinStrategy().removeXmlJoinTable();
    }

    @Override
    public ListIterator<OrmJoinColumn> inverseJoinColumns() {
        return this.getInverseJoinColumns().iterator();
    }

    protected ListIterable<OrmJoinColumn> getInverseJoinColumns() {
        return this.hasSpecifiedInverseJoinColumns() ? this.getSpecifiedInverseJoinColumns() : this.getDefaultInverseJoinColumns();
    }

    @Override
    public int inverseJoinColumnsSize() {
        return this.hasSpecifiedInverseJoinColumns() ? this.specifiedInverseJoinColumnsSize() : this.getDefaultInverseJoinColumnsSize();
    }

    @Override
    public void convertDefaultToSpecifiedInverseJoinColumn() {
        MappingTools.convertJoinTableDefaultToSpecifiedInverseJoinColumn(this);
    }

    @Override
    public ListIterator<OrmJoinColumn> specifiedInverseJoinColumns() {
        return this.getSpecifiedInverseJoinColumns().iterator();
    }

    public ListIterable<OrmJoinColumn> getSpecifiedInverseJoinColumns() {
        return new LiveCloneListIterable(this.specifiedInverseJoinColumns);
    }

    @Override
    public int specifiedInverseJoinColumnsSize() {
        return this.specifiedInverseJoinColumns.size();
    }

    @Override
    public boolean hasSpecifiedInverseJoinColumns() {
        return this.specifiedInverseJoinColumns.size() != 0;
    }

    @Override
    public OrmJoinColumn getSpecifiedInverseJoinColumn(int index) {
        return this.specifiedInverseJoinColumns.get(index);
    }

    @Override
    public OrmJoinColumn addSpecifiedInverseJoinColumn() {
        return this.addSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumns.size());
    }

    @Override
    public OrmJoinColumn addSpecifiedInverseJoinColumn(int index) {
        XmlJoinTable xmlTable = (XmlJoinTable)this.getXmlTableForUpdate();
        XmlJoinColumn xmlJoinColumn = this.buildXmlJoinColumn();
        OrmJoinColumn joinColumn = this.addSpecifiedInverseJoinColumn_(index, xmlJoinColumn);
        xmlTable.getInverseJoinColumns().add(index, (Object)xmlJoinColumn);
        return joinColumn;
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(int index) {
        this.removeSpecifiedInverseJoinColumn_(index);
        this.getXmlTable().getInverseJoinColumns().remove(index);
        this.removeXmlTableIfUnset();
    }

    protected void removeSpecifiedInverseJoinColumn_(int index) {
        this.removeItemFromList(index, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
    }

    @Override
    public void moveSpecifiedInverseJoinColumn(int targetIndex, int sourceIndex) {
        this.moveItemInList(targetIndex, sourceIndex, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
        this.getXmlTable().getInverseJoinColumns().move(targetIndex, sourceIndex);
    }

    @Override
    public void clearSpecifiedInverseJoinColumns() {
        this.clearCollection(this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
        this.getXmlTable().getInverseJoinColumns().clear();
    }

    protected void initializeSpecifiedInverseJoinColumns() {
        for (XmlJoinColumn xmlJoinColumn : this.getXmlInverseJoinColumns()) {
            this.specifiedInverseJoinColumns.add(this.buildInverseJoinColumn(xmlJoinColumn));
        }
    }

    protected void syncSpecifiedInverseJoinColumns() {
        ContextContainerTools.synchronizeWithResourceModel(this.specifiedInverseJoinColumnContainerAdapter);
    }

    protected Iterable<XmlJoinColumn> getXmlInverseJoinColumns() {
        XmlJoinTable xmlTable = this.getXmlTable();
        return xmlTable == null ? EmptyIterable.instance() : new LiveCloneIterable(xmlTable.getInverseJoinColumns());
    }

    protected void moveSpecifiedInverseJoinColumn_(int index, OrmJoinColumn joinColumn) {
        this.moveItemInList(index, joinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
    }

    protected OrmJoinColumn addSpecifiedInverseJoinColumn_(int index, XmlJoinColumn xmlJoinColumn) {
        OrmJoinColumn joinColumn = this.buildInverseJoinColumn(xmlJoinColumn);
        this.addItemToList(index, joinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
        return joinColumn;
    }

    protected void removeSpecifiedInverseJoinColumn_(OrmJoinColumn joinColumn) {
        this.removeSpecifiedInverseJoinColumn_(this.specifiedInverseJoinColumns.indexOf(joinColumn));
    }

    protected OrmJoinColumn.Owner buildInverseJoinColumnOwner() {
        return new InverseJoinColumnOwner();
    }

    @Override
    public OrmJoinColumn getDefaultInverseJoinColumn() {
        return this.defaultInverseJoinColumn;
    }

    protected void setDefaultInverseJoinColumn(OrmJoinColumn joinColumn) {
        OrmJoinColumn old = this.defaultInverseJoinColumn;
        this.defaultInverseJoinColumn = joinColumn;
        this.firePropertyChanged("defaultInverseJoinColumn", old, joinColumn);
    }

    protected ListIterable<OrmJoinColumn> getDefaultInverseJoinColumns() {
        return this.defaultInverseJoinColumn != null ? new SingleElementListIterable((Object)this.defaultInverseJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultInverseJoinColumnsSize() {
        return this.defaultInverseJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultInverseJoinColumn() {
        if (this.buildsDefaultInverseJoinColumn()) {
            if (this.defaultInverseJoinColumn == null) {
                this.setDefaultInverseJoinColumn(this.buildInverseJoinColumn(null));
            } else {
                this.defaultInverseJoinColumn.update();
            }
        } else {
            this.setDefaultInverseJoinColumn(null);
        }
    }

    protected boolean buildsDefaultInverseJoinColumn() {
        return !this.hasSpecifiedInverseJoinColumns();
    }

    @Override
    public OrmJoinTableRelationshipStrategy getParent() {
        return (OrmJoinTableRelationshipStrategy)super.getParent();
    }

    protected OrmJoinTableRelationshipStrategy getJoinStrategy() {
        return this.getParent();
    }

    @Override
    protected String buildDefaultName() {
        return this.getJoinStrategy().getJoinTableDefaultName();
    }

    @Override
    public void initializeFrom(ReadOnlyJoinTable oldTable) {
        super.initializeFrom(oldTable);
        for (ReadOnlyJoinColumn joinColumn : CollectionTools.iterable(oldTable.specifiedInverseJoinColumns())) {
            this.addSpecifiedInverseJoinColumn().initializeFrom(joinColumn);
        }
    }

    @Override
    public void initializeFromVirtual(ReadOnlyJoinTable virtualTable) {
        super.initializeFromVirtual(virtualTable);
        for (ReadOnlyJoinColumn joinColumn : CollectionTools.iterable(virtualTable.inverseJoinColumns())) {
            this.addSpecifiedInverseJoinColumn().initializeFromVirtual(joinColumn);
        }
    }

    protected OrmJoinColumn buildInverseJoinColumn(XmlJoinColumn xmlJoinColumn) {
        return this.getContextNodeFactory().buildOrmJoinColumn(this, this.inverseJoinColumnOwner, xmlJoinColumn);
    }

    @Override
    public RelationshipMapping getRelationshipMapping() {
        return this.getJoinStrategy().getRelationship().getMapping();
    }

    @Override
    public PersistentAttribute getPersistentAttribute() {
        return this.getRelationshipMapping().getPersistentAttribute();
    }

    @Override
    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter) {
        super.validateJoinColumns(messages, reporter);
        this.validateJoinColumns((Iterable<OrmJoinColumn>)this.getInverseJoinColumns(), messages, reporter);
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.getJoinStrategy().validatesAgainstDatabase();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractJoinColumnOwner
    implements OrmJoinColumn.Owner {
        protected AbstractJoinColumnOwner() {
        }

        @Override
        public TypeMapping getTypeMapping() {
            return GenericOrmJoinTable.this.getJoinStrategy().getRelationship().getTypeMapping();
        }

        protected PersistentAttribute getPersistentAttribute() {
            return GenericOrmJoinTable.this.getPersistentAttribute();
        }

        @Override
        public String getDefaultColumnName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return Tools.valuesAreDifferent((Object)this.getDefaultTableName(), (Object)tableName);
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return EmptyIterator.instance();
        }

        @Override
        public Table resolveDbTable(String tableName) {
            return Tools.valuesAreEqual((Object)GenericOrmJoinTable.this.getName(), (Object)tableName) ? GenericOrmJoinTable.this.getDbTable() : null;
        }

        @Override
        public String getDefaultTableName() {
            return GenericOrmJoinTable.this.getName();
        }

        @Override
        public TextRange getValidationTextRange() {
            return GenericOrmJoinTable.this.getValidationTextRange();
        }

        protected String getPersistentAttributeName() {
            return this.getPersistentAttribute().getName();
        }

        protected OrmJoinTableRelationshipStrategy getJoinStrategy() {
            return GenericOrmJoinTable.this.getJoinStrategy();
        }
    }

    protected class InverseJoinColumnOwner
    extends AbstractJoinColumnOwner {
        protected InverseJoinColumnOwner() {
        }

        public Entity getRelationshipTarget() {
            RelationshipMapping relationshipMapping = GenericOrmJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getResolvedTargetEntity();
        }

        public String getAttributeName() {
            RelationshipMapping relationshipMapping = GenericOrmJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getName();
        }

        public Table resolveDbTable(String tableName) {
            Table dbTable = super.resolveDbTable(tableName);
            if (dbTable != null) {
                return dbTable;
            }
            Entity relationshipTarget = this.getRelationshipTarget();
            return relationshipTarget == null ? null : relationshipTarget.resolveDbTable(tableName);
        }

        public Table getReferencedColumnDbTable() {
            Entity relationshipTarget = this.getRelationshipTarget();
            return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
        }

        public boolean joinColumnIsDefault(ReadOnlyBaseJoinColumn joinColumn) {
            return GenericOrmJoinTable.this.defaultInverseJoinColumn == joinColumn;
        }

        public int joinColumnsSize() {
            return GenericOrmJoinTable.this.inverseJoinColumnsSize();
        }

        public JptValidator buildColumnValidator(NamedColumn column, NamedColumnTextRangeResolver textRangeResolver) {
            return this.getJoinStrategy().buildJoinTableInverseJoinColumnValidator((JoinColumn)column, this, (JoinColumnTextRangeResolver)textRangeResolver);
        }
    }

    protected class JoinColumnOwner
    extends AbstractJoinColumnOwner {
        protected JoinColumnOwner() {
        }

        public Entity getRelationshipTarget() {
            return this.getJoinStrategy().getRelationship().getEntity();
        }

        public String getAttributeName() {
            return MappingTools.getTargetAttributeName(GenericOrmJoinTable.this.getRelationshipMapping());
        }

        public Table resolveDbTable(String tableName) {
            Table dbTable = super.resolveDbTable(tableName);
            return dbTable != null ? dbTable : this.getTypeMapping().resolveDbTable(tableName);
        }

        public Table getReferencedColumnDbTable() {
            return this.getTypeMapping().getPrimaryDbTable();
        }

        public boolean joinColumnIsDefault(ReadOnlyBaseJoinColumn joinColumn) {
            return GenericOrmJoinTable.this.defaultJoinColumn == joinColumn;
        }

        public int joinColumnsSize() {
            return GenericOrmJoinTable.this.joinColumnsSize();
        }

        public JptValidator buildColumnValidator(NamedColumn column, NamedColumnTextRangeResolver textRangeResolver) {
            return this.getJoinStrategy().buildJoinTableJoinColumnValidator((JoinColumn)column, this, (JoinColumnTextRangeResolver)textRangeResolver);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedInverseJoinColumnContainerAdapter
    implements ContextContainerTools.Adapter<OrmJoinColumn, XmlJoinColumn> {
        protected SpecifiedInverseJoinColumnContainerAdapter() {
        }

        @Override
        public Iterable<OrmJoinColumn> getContextElements() {
            return GenericOrmJoinTable.this.getSpecifiedInverseJoinColumns();
        }

        @Override
        public Iterable<XmlJoinColumn> getResourceElements() {
            return GenericOrmJoinTable.this.getXmlInverseJoinColumns();
        }

        @Override
        public XmlJoinColumn getResourceElement(OrmJoinColumn contextElement) {
            return contextElement.getXmlColumn();
        }

        @Override
        public void moveContextElement(int index, OrmJoinColumn element) {
            GenericOrmJoinTable.this.moveSpecifiedInverseJoinColumn_(index, element);
        }

        @Override
        public void addContextElement(int index, XmlJoinColumn resourceElement) {
            GenericOrmJoinTable.this.addSpecifiedInverseJoinColumn_(index, resourceElement);
        }

        @Override
        public void removeContextElement(OrmJoinColumn element) {
            GenericOrmJoinTable.this.removeSpecifiedInverseJoinColumn_(element);
        }
    }
}

