/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.libval;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.common.core.libval.LibraryValidator;
import org.eclipse.jpt.jpa.core.internal.JptCoreMessages;
import org.eclipse.jpt.jpa.core.internal.libprov.JpaOsgiBundlesLibraryProviderInstallOperationConfig;
import org.eclipse.jst.common.project.facet.core.libprov.osgi.BundleReference;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOsgiBundlesLibraryValidator
implements LibraryValidator {
    protected IStatus validate(JpaOsgiBundlesLibraryProviderInstallOperationConfig config, Map<String, VersionRange[]> bundleVersionRanges) {
        HashMap<String, Bundle> bundles = new HashMap<String, Bundle>();
        for (BundleReference bundleRef : config.getBundleReferences()) {
            for (String bundleName : bundleVersionRanges.keySet()) {
                if (!bundleRef.getBundle().getSymbolicName().equals(bundleName)) continue;
                bundles.put(bundleName, bundleRef.getBundle());
            }
        }
        for (String bundleName : bundleVersionRanges.keySet()) {
            if (bundles.get(bundleName) != null) continue;
            String message = NLS.bind((String)JptCoreMessages.OSGI_BUNDLES_LIBRARY_VALIDATOR__BUNDLE_NOT_FOUND, (Object)bundleName);
            return new Status(4, "org.eclipse.jpt.jpa.core", message);
        }
        for (String bundleName : bundleVersionRanges.keySet()) {
            Bundle bundle = (Bundle)bundles.get(bundleName);
            VersionRange[] versionRangeArray = bundleVersionRanges.get(bundleName);
            int n = versionRangeArray.length;
            int n2 = 0;
            while (n2 < n) {
                VersionRange versionRange = versionRangeArray[n2];
                if (!versionRange.isIncluded(bundle.getVersion())) {
                    String message = NLS.bind((String)JptCoreMessages.OSGI_BUNDLES_LIBRARY_VALIDATOR__IMPROPER_BUNDLE_VERSION, (Object)bundleName);
                    return new Status(4, "org.eclipse.jpt.jpa.core", message);
                }
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }
}

