/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.create.component.wizard;

import aurora.ide.create.component.ComponentListFactory;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import uncertain.composite.CompositeMap;

public class ComponentListWizardPage
extends WizardPage
implements ISelectionChangedListener {
    private TreeViewer viewer;
    private CompositeMap currentSelectionObject;

    public ComponentListWizardPage(String pageName) {
        super(pageName);
    }

    private void init(CompositeMap createInput) {
        this.viewer.setSelection((ISelection)new StructuredSelection(createInput.getChilds().get(0)));
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        FilteredTree ff = new FilteredTree(control, 4, new PatternFilter(), true);
        this.viewer = ff.getViewer();
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new VLabelProvider());
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setControl((Control)control);
        CompositeMap createInput = ComponentListFactory.createInput();
        this.setInput(createInput);
        this.init(createInput);
    }

    public void setInput(Object input) {
        this.viewer.setInput(input);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object firstElement;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof CompositeMap) {
            this.setCurrentSelectionObject((CompositeMap)firstElement);
            return;
        }
        this.setCurrentSelectionObject(null);
    }

    public CompositeMap getCurrentSelectionObject() {
        return this.currentSelectionObject;
    }

    public void setCurrentSelectionObject(CompositeMap currentSelectionObject) {
        this.currentSelectionObject = currentSelectionObject;
    }

    private class ContentProvider
    extends WorkbenchContentProvider {
        private ContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof CompositeMap) {
                List childsNotNull = ((CompositeMap)inputElement).getChildsNotNull();
                return childsNotNull.toArray(new CompositeMap[childsNotNull.size()]);
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class VLabelProvider
    extends LabelProvider {
        private VLabelProvider() {
        }

        public final Image getImage(Object element) {
            if (element instanceof CompositeMap) {
                return ComponentListFactory.getImage((CompositeMap)element);
            }
            return null;
        }

        public final String getText(Object element) {
            if (element instanceof CompositeMap) {
                return ((CompositeMap)element).getName();
            }
            return null;
        }
    }
}

