/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.create.component.wizard;

import aurora.ide.composite.map.CompositeMapLoadException;
import aurora.ide.composite.map.DocumentCompositeMap;
import aurora.ide.create.component.ViewDiagramCreator;
import aurora.ide.create.component.wizard.ComponentListWizardPage;
import aurora.ide.create.component.wizard.PrototpyeViewWizardPage;
import aurora.ide.editor.textpage.TextPage;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.DocumentUtil;
import aurora.ide.meta.exception.TemplateNotBindedException;
import aurora.ide.meta.gef.editors.models.ViewDiagram;
import aurora.ide.meta.gef.editors.source.gen.core.ScreenGenerator;
import aurora.ide.views.bm.view.FakePrototypeProject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import uncertain.composite.CompositeMap;
import uncertain.composite.IterationHandle;

public class CreateComponentWizard
extends Wizard
implements IPageChangedListener {
    private IProject project;
    private IDocument document;
    private CompositeMap bodyMap;
    private CompositeMap viewMap;
    private CompositeMap screenMap;
    private CompositeMap datasetsMap;
    private List<CompositeMap> insertAfters = new ArrayList<CompositeMap>();
    private PrototpyeViewWizardPage prototpyePage = new PrototpyeViewWizardPage("PrototpyeViewWizardPage");
    private ComponentListWizardPage componentListPage = new ComponentListWizardPage("ComponentListWizardPage");
    private TextPage textPage;
    private ViewDiagramCreator viewDiagramCreator;

    public CreateComponentWizard(List<CompositeMap> input, IProject project, TextPage textPage) {
        this.project = project;
        this.document = (IDocument)textPage.getAdapter(IDocument.class);
        this.textPage = textPage;
        this.viewDiagramCreator = new ViewDiagramCreator(input);
        try {
            this.createAfterList();
        }
        catch (CompositeMapLoadException e) {
            this.componentListPage.setErrorMessage(e.getMessage());
            this.componentListPage.setPageComplete(false);
        }
        if (this.screenMap == null) {
            this.componentListPage.setErrorMessage("\u627e\u4e0d\u5230screen\u8282\u70b9");
            this.componentListPage.setPageComplete(false);
        }
        if (this.viewMap == null) {
            this.componentListPage.setErrorMessage("\u627e\u4e0d\u5230view\u8282\u70b9");
            this.componentListPage.setPageComplete(false);
        }
        this.prototpyePage.setInserOfterList(this.insertAfters);
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.componentListPage);
        this.componentListPage.setTitle("Component List");
        this.componentListPage.setDescription("\u7ec4\u4ef6\u5217\u8868");
        this.addPage((IWizardPage)this.prototpyePage);
        this.prototpyePage.setTitle("GUI");
        this.prototpyePage.setDescription("\u7ec4\u4ef6\u5b9a\u5236");
        super.addPages();
    }

    public boolean performFinish() {
        try {
            CompositeMap afterMap;
            ViewDiagram viewDiagram = this.prototpyePage.getViewDiagram();
            CompositeMap generate = this.generate(viewDiagram);
            String text = this.createInsertText(generate);
            String insertDatasetText = "";
            IRewriteTarget target = (IRewriteTarget)this.textPage.getAdapter(IRewriteTarget.class);
            if (target != null) {
                target.beginCompoundChange();
            }
            int dsOffset = 0;
            int dslength = 0;
            if (this.viewMap != null && !this.isInSameLine(this.viewMap)) {
                insertDatasetText = this.createInsertDatasetText(generate);
                if (this.datasetsMap == null) {
                    dsOffset = DocumentUtil.getMapLineOffset((IDocument)this.document, (CompositeMap)this.viewMap, (int)0, (boolean)true);
                }
                if (this.datasetsMap != null) {
                    boolean inSameLine = this.isInSameLine(this.datasetsMap);
                    if (inSameLine) {
                        int endLine = this.datasetsMap.getLocation().getEndLine();
                        dsOffset = DocumentUtil.getMapLineOffset((IDocument)this.document, (CompositeMap)this.datasetsMap, (int)-1, (boolean)false);
                        dslength = this.document.getLineLength(endLine - 1);
                    } else {
                        dsOffset = DocumentUtil.getMapLineOffset((IDocument)this.document, (CompositeMap)this.datasetsMap, (int)-1, (boolean)false);
                    }
                }
            }
            if ((afterMap = this.prototpyePage.getAfterMap()) == null) {
                afterMap = this.insertAfters.get(0);
            }
            int viewOffset = 0;
            int viewLength = 0;
            boolean inSameLine = this.isInSameLine(this.viewMap);
            if (inSameLine) {
                int endLine = this.viewMap.getLocation().getEndLine();
                viewOffset = this.document.getLineOffset(endLine - 1);
                viewLength = this.document.getLineLength(endLine - 1);
            } else if ("begin".equals(afterMap.getName())) {
                CompositeMap aMap = this.bodyMap == null ? this.viewMap : this.bodyMap;
                viewOffset = DocumentUtil.getMapLineOffset((IDocument)this.document, (CompositeMap)aMap, (int)0, (boolean)true);
            } else if ("end".equals(afterMap.getName())) {
                CompositeMap aMap = this.bodyMap == null ? this.viewMap : this.bodyMap;
                viewOffset = DocumentUtil.getMapLineOffset((IDocument)this.document, (CompositeMap)aMap, (int)-1, (boolean)false);
            } else {
                viewOffset = DocumentUtil.getMapLineOffset((IDocument)this.document, (CompositeMap)afterMap, (int)0, (boolean)false);
            }
            if (viewOffset - dsOffset >= 0) {
                this.document.replace(viewOffset, viewLength, text);
                if (dsOffset != 0) {
                    this.document.replace(dsOffset, dslength, insertDatasetText);
                }
                viewOffset += insertDatasetText.length() - dslength;
            } else {
                if (dsOffset != 0) {
                    this.document.replace(dsOffset, dslength, insertDatasetText);
                }
                this.document.replace(viewOffset, viewLength, text);
            }
            StyledText st = (StyledText)this.textPage.getAdapter(StyledText.class);
            st.setSelectionRange(viewOffset, text.length());
        }
        catch (BadLocationException e) {
            this.componentListPage.setErrorMessage("\u64cd\u4f5c\u65e0\u6cd5\u5b8c\u6210\u8bf7\u67e5\u770blog\u83b7\u5f97\u66f4\u591a\u4fe1\u606f");
            DialogUtil.logErrorException((Throwable)e);
            return false;
        }
        return true;
    }

    private String createInsertText(CompositeMap generate) {
        if (this.screenMap == null) {
            return generate.toXML();
        }
        if (this.viewMap == null || this.isInSameLine(this.viewMap)) {
            return generate.getChild("view").toXML();
        }
        if (this.viewMap != null) {
            CompositeMap child = generate.getChild("view").getChild("screenBody");
            if (child == null) {
                return "";
            }
            return this.getChildText(child);
        }
        return "";
    }

    private String createInsertDatasetText(CompositeMap generate) {
        if (this.viewMap == null) {
            return "";
        }
        if (this.datasetsMap == null || this.isInSameLine(this.datasetsMap)) {
            return generate.getChild("view").getChild("dataSets").toXML();
        }
        if (this.datasetsMap != null) {
            CompositeMap child = generate.getChild("view").getChild("dataSets");
            if (child == null) {
                return "";
            }
            return this.getChildText(child);
        }
        return "";
    }

    private String getChildText(CompositeMap child) {
        StringBuilder sb = new StringBuilder();
        List childsNotNull = child.getChildsNotNull();
        for (CompositeMap m : childsNotNull) {
            String string = m.getString((Object)"model", "");
            if ("".equals(string)) {
                m.remove((Object)"model");
            }
            sb.append(m.toXML());
        }
        return sb.toString();
    }

    private boolean isInSameLine(CompositeMap map) {
        if (map != null) {
            return map.getLocation().getStartLine() == map.getLocation().getEndLine();
        }
        return false;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public void pageChanged(PageChangedEvent event) {
        Object selectedPage = event.getSelectedPage();
        if (((Object)((Object)this.prototpyePage)).equals(selectedPage)) {
            CompositeMap currentSelectionObject = this.componentListPage.getCurrentSelectionObject();
            this.prototpyePage.setInput(this.viewDiagramCreator.createPrototypeDiagram(currentSelectionObject));
            this.prototpyePage.setPageComplete(true);
        } else {
            this.prototpyePage.setPageComplete(false);
        }
        this.getContainer().updateButtons();
    }

    private CompositeMap generate(ViewDiagram diagram) {
        ScreenGenerator sg = new ScreenGenerator((IProject)new FakePrototypeProject(this.project), null);
        try {
            CompositeMap genCompositeMap = sg.genCompositeMap(diagram);
            return genCompositeMap;
        }
        catch (TemplateNotBindedException templateNotBindedException) {
            return null;
        }
    }

    public void createAfterList() throws CompositeMapLoadException {
        this.insertAfters.add(new CompositeMap("begin"));
        this.insertAfters.add(new CompositeMap("end"));
        DocumentCompositeMap dcm = new DocumentCompositeMap(this.document);
        CompositeMap load = dcm.load();
        load.iterate(new IterationHandle(){

            public int process(CompositeMap map) {
                if ("screen".equalsIgnoreCase(map.getName())) {
                    CreateComponentWizard.this.screenMap = map;
                }
                if ("view".equalsIgnoreCase(map.getName())) {
                    CreateComponentWizard.this.viewMap = map;
                }
                if ("datasets".equalsIgnoreCase(map.getName())) {
                    CreateComponentWizard.this.datasetsMap = map;
                }
                if ("screenBody".equalsIgnoreCase(map.getName())) {
                    CreateComponentWizard.this.bodyMap = map;
                }
                return 0;
            }
        }, true);
        load.iterate(new IterationHandle(){

            public int process(CompositeMap map) {
                if (CreateComponentWizard.this.viewMap != null && CreateComponentWizard.this.bodyMap == null && CreateComponentWizard.this.viewMap.equals((Object)map.getParent())) {
                    CreateComponentWizard.this.insertAfters.add(map);
                }
                if (CreateComponentWizard.this.viewMap != null && CreateComponentWizard.this.bodyMap != null && CreateComponentWizard.this.bodyMap.equals((Object)map.getParent())) {
                    CreateComponentWizard.this.insertAfters.add(map);
                }
                return 0;
            }
        }, false);
    }
}

