/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.views.bm.view;

import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.meta.gef.designer.BMCompositeMap;
import aurora.ide.search.cache.CacheManager;
import aurora.ide.search.core.Util;
import aurora.ide.views.bm.BMTransfer;
import aurora.ide.views.bm.view.PatternFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.DelegatingDragAdapter;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import uncertain.composite.CompositeMap;

public class BMViewer {
    private IProject project;
    private TreeViewer viewer;

    public BMViewer(Composite c) {
        this.configrueTreeViewer(c);
    }

    private void configrueTreeViewer(Composite c) {
        FilteredTree ff = new FilteredTree(c, 4, (org.eclipse.ui.dialogs.PatternFilter)new CustomPatternFilter(), true);
        this.setViewer(ff.getViewer());
        DelegatingDragAdapter dragAdapter = new DelegatingDragAdapter();
        dragAdapter.addDragSourceListener(new TransferDragSourceListener(){

            public Transfer getTransfer() {
                return BMTransfer.getInstance();
            }

            public void dragStart(DragSourceEvent event) {
                List<CompositeMap> data = this.getData();
                if (data == null) {
                    event.doit = false;
                    return;
                }
                event.detail = 1;
                event.doit = true;
                BMTransfer.getInstance().setObject(data);
            }

            protected List<CompositeMap> getFields(Object data) throws CoreException, ApplicationException {
                if (data instanceof IContainer) {
                    return null;
                }
                ArrayList<CompositeMap> fs = new ArrayList<CompositeMap>();
                if (data instanceof IFile) {
                    ModelField[] createFields;
                    ModelField[] modelFieldArray = createFields = BMViewer.this.createFields((IFile)data);
                    int n = createFields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ModelField mf = modelFieldArray[n2];
                        fs.add(this.getFieldMap(mf));
                        ++n2;
                    }
                }
                if (data instanceof ModelField) {
                    CompositeMap fieldMap = this.getFieldMap((ModelField)data);
                    fs.add(fieldMap);
                }
                return fs;
            }

            private CompositeMap getFieldMap(ModelField data) {
                CompositeMap fieldMap = data.fieldMap;
                if ("ref-field".equals(data.editor)) {
                    fieldMap = (CompositeMap)fieldMap.clone();
                    fieldMap.put((Object)"prompt", (Object)data.getPrompt());
                }
                fieldMap.put((Object)"model", (Object)Util.toBMPKG((IFile)data.parent));
                return fieldMap;
            }

            private List<CompositeMap> getData() {
                TreeSelection selection = (TreeSelection)BMViewer.this.getViewer().getSelection();
                Object obj = selection.getFirstElement();
                try {
                    return this.getFields(obj);
                }
                catch (CoreException coreException) {
                }
                catch (ApplicationException applicationException) {}
                return null;
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = this.getData();
            }

            public void dragFinished(DragSourceEvent event) {
                BMTransfer.getInstance().setObject(null);
            }
        });
        this.getViewer().addDragSupport(1, dragAdapter.getTransfers(), (DragSourceListener)dragAdapter);
        this.getViewer().setContentProvider((IContentProvider)new ContentProvider());
        DecoratingStyledCellLabelProvider labelProvider = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new VLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null);
        this.getViewer().setLabelProvider((IBaseLabelProvider)labelProvider);
        this.getViewer().getControl().setLayoutData((Object)new GridData(1808));
    }

    public void refreshInput() {
    }

    public List<IFile> getModelFiles(IFolder folder) {
        final ArrayList<IFile> files = new ArrayList<IFile>();
        try {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFile && "bm".equalsIgnoreCase(resource.getFileExtension())) {
                        files.add((IFile)resource);
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            DialogUtil.logErrorException((Throwable)e);
            e.printStackTrace();
        }
        return files;
    }

    private ModelField[] createFields(IFile model) {
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            CompositeMap modelMap = CacheManager.getWholeBMCompositeMap((IFile)model);
            BMCompositeMap bmMap = new BMCompositeMap(modelMap);
            List fields = bmMap.getFields();
            for (CompositeMap qf : fields) {
                if (!"field".equals(qf.getName()) || qf.get((Object)"name") == null || this.isPK(bmMap, qf)) continue;
                ModelField field = new ModelField(model, qf, aurora.ide.meta.gef.Util.getType((CompositeMap)qf));
                result.add(field);
            }
            List refFields = bmMap.getRefFields();
            for (CompositeMap qf : refFields) {
                if (!"ref-field".equals(qf.getName()) || qf.get((Object)"name") == null) continue;
                ModelField field = new ModelField(model, qf, "ref-field");
                result.add(field);
            }
            List queryFields = bmMap.getQueryFields();
            for (CompositeMap qf : queryFields) {
                if (!"query-field".equals(qf.getName()) || qf.get((Object)"name") == null) continue;
                ModelField field = new ModelField(model, qf, "query-field");
                result.add(field);
            }
        }
        catch (CoreException coreException) {
        }
        catch (ApplicationException applicationException) {}
        return result.toArray(new ModelField[result.size()]);
    }

    private boolean isPK(BMCompositeMap bmMap, CompositeMap qf) {
        List primaryKeys = bmMap.getPrimaryKeys();
        for (CompositeMap compositeMap : primaryKeys) {
            if (!compositeMap.getString((Object)"name", "").equals(qf.get((Object)"name"))) continue;
            return true;
        }
        return qf.getBoolean((Object)"isprimarykey", false);
    }

    public void setInput(IFolder web_classes) {
        this.project = web_classes.getProject();
        this.getViewer().setInput((Object)web_classes);
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    private void setViewer(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public Object getSelectObject() {
        TreeItem[] items = this.viewer.getTree().getSelection();
        if (items.length > 0) {
            return items[0].getData();
        }
        return null;
    }

    private class ContentProvider
    extends WorkbenchContentProvider {
        private ContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            IProject auroraProject = BMViewer.this.project;
            if (auroraProject == null) {
                return new String[]{"\u8bf7\u9009\u62e9Aurora\u5de5\u7a0b"};
            }
            if (inputElement instanceof IFolder) {
                List<IFile> modelFiles = BMViewer.this.getModelFiles((IFolder)inputElement);
                if (modelFiles.size() == 0) {
                    return new String[]{"Model\u4e0d\u5b58\u5728"};
                }
                if (modelFiles.size() > 500) {
                    try {
                        return ((IFolder)inputElement).members();
                    }
                    catch (CoreException e) {
                        DialogUtil.logErrorException((Throwable)e);
                        e.printStackTrace();
                    }
                }
                return modelFiles.toArray(new IFile[modelFiles.size()]);
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            boolean cfr_ignored_0 = parentElement instanceof IFile;
            if (parentElement instanceof IContainer) {
                IContainer c = (IContainer)parentElement;
                try {
                    return c.members();
                }
                catch (CoreException e) {
                    DialogUtil.logErrorException((Throwable)e);
                    e.printStackTrace();
                }
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof ModelField) {
                return ((ModelField)element).parent;
            }
            if (element instanceof IFile) {
                return ((IFile)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IContainer;
        }
    }

    private class CustomPatternFilter
    extends PatternFilter {
        @Override
        public boolean isLeafMatch(Viewer viewer, Object element) {
            if (!(element instanceof IFile)) {
                return false;
            }
            String labelText = ((DecoratingStyledCellLabelProvider)((StructuredViewer)viewer).getLabelProvider()).getStyledStringProvider().getStyledText(element).getString();
            if (labelText == null) {
                return false;
            }
            return this.wordMatches(labelText);
        }
    }

    private class ModelField {
        public IFile parent;
        public CompositeMap fieldMap;
        public String editor;
        static final String REF_FIELD = "ref-field";
        static final String QUERY_FIELD = "query-field";

        public ModelField(IFile parent, CompositeMap fieldMap, String editor) {
            this.parent = parent;
            this.fieldMap = fieldMap;
            this.editor = editor;
        }

        public String getPrompt() {
            String prompt = null;
            if (REF_FIELD.equals(this.editor)) {
                if (BMViewer.this.project != null) {
                    prompt = aurora.ide.meta.gef.Util.getRefFieldSourcePrompt((IProject)BMViewer.this.project, (CompositeMap)this.fieldMap, (String)"");
                }
            } else {
                prompt = aurora.ide.meta.gef.Util.getPrompt((CompositeMap)this.fieldMap, (String)"");
            }
            return prompt == null ? this.fieldMap.getString((Object)"prompt", "") : prompt;
        }

        public String getName() {
            String fname = this.fieldMap.getString((Object)"name", "");
            return "[" + fname + "]";
        }
    }

    private class VLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private ResourceManager resourceManager;

        private VLabelProvider() {
        }

        private ResourceManager getResourceManager() {
            if (this.resourceManager == null) {
                this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
            }
            return this.resourceManager;
        }

        protected final Object getAdapter(Object sourceObject) {
            Object result;
            IAdaptable adaptable;
            Object result2;
            Class<IWorkbenchAdapter> adapterType = IWorkbenchAdapter.class;
            if (sourceObject == null) {
                return null;
            }
            if (adapterType.isInstance(sourceObject)) {
                return sourceObject;
            }
            if (sourceObject instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)sourceObject).getAdapter(adapterType)) != null) {
                Assert.isTrue((boolean)adapterType.isInstance(result2));
                return result2;
            }
            if (!(sourceObject instanceof PlatformObject) && (result = Platform.getAdapterManager().getAdapter(sourceObject, adapterType)) != null) {
                return result;
            }
            return null;
        }

        public final Image getImage(Object element) {
            if (element instanceof IResource) {
                IWorkbenchAdapter adapter = (IWorkbenchAdapter)this.getAdapter(element);
                if (adapter == null) {
                    return null;
                }
                ImageDescriptor descriptor = adapter.getImageDescriptor(element);
                if (descriptor == null) {
                    return null;
                }
                return (Image)this.getResourceManager().get((DeviceResourceDescriptor)descriptor);
            }
            if (element instanceof ModelField) {
                return this.getImage((ModelField)element);
            }
            return null;
        }

        private Image getImage(ModelField model) {
            return null;
        }

        public final String getText(Object element) {
            if (element instanceof IFolder) {
                return ((IFolder)element).getName();
            }
            if (element instanceof String) {
                return element.toString();
            }
            return this.getStyledText(element).getString();
        }

        public StyledString getStyledText(Object element) {
            StyledString s = new StyledString();
            if (element instanceof IFolder) {
                s.append(((IFolder)element).getName());
                return s;
            }
            if (element instanceof IFile) {
                s.append(((IFile)element).getFullPath().removeFileExtension().lastSegment());
                s.append(" ");
                String pkg = Util.getPKG((IPath)((IFile)element).getProjectRelativePath());
                s.append("[" + pkg + "]", StyledString.DECORATIONS_STYLER);
                return s;
            }
            if (element instanceof ModelField) {
                s.append(((ModelField)element).getPrompt());
                s.append(" ");
                s.append(((ModelField)element).getName(), StyledString.QUALIFIER_STYLER);
                return s;
            }
            if (element instanceof String) {
                return s.append(element.toString());
            }
            return s;
        }
    }
}

