/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.views.editor;

import aurora.ide.views.prompts.view.ViewNode;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PromptsEditor {
    private TableItem item;
    private Table table;
    private ViewNode viewNode;
    private Text text;
    private TableEditor editor;

    public PromptsEditor(Table table, TableItem item) {
        this.table = table;
        this.item = item;
        this.viewNode = (ViewNode)item.getData();
    }

    public void createEditor(int column) {
        this.editor = new TableEditor(this.table);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.text = new Text((Composite)this.table, 0);
        this.editor.setEditor((Control)this.text, this.item, column);
        this.autoDispose();
    }

    public void addModifyListener(ModifyListener listener) {
        this.text.addModifyListener(listener);
    }

    public void setText(String t) {
        this.text.setText(t);
    }

    private void autoDispose() {
        this.item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PromptsEditor.this.text.dispose();
                PromptsEditor.this.editor.dispose();
            }
        });
    }

    public String getText() {
        return this.text.getText();
    }
}

