/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.views.prompts.view;

import aurora.ide.editor.editorInput.StringEditorInput;
import aurora.ide.freemarker.FreeMarkerGenerator;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.search.cache.CacheManager;
import aurora.ide.views.dialog.ResourceSelector;
import aurora.ide.views.editor.PromptsEditor;
import aurora.ide.views.prompts.preference.PromptsRegisterSqlConfigration;
import aurora.ide.views.prompts.util.PromptsFinder;
import aurora.ide.views.prompts.view.ViewNode;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeMap;
import uncertain.composite.IterationHandle;

public class PromptsView
extends ViewPart {
    public static final String ID = "aurora.ide.views.prompts.view.PromptsView";
    private TableViewer viewer;
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private Table table;
    private Action selectALL;
    private Action deselectAll;
    private Action doubleClickAction;
    private IFile file;
    private CompositeMap compositeMap;
    private ViewNode[] result;

    public void createPartControl(Composite parent) {
        Composite container = this.toolkit.createComposite(parent, 0);
        this.viewer = new TableViewer(container, 66338);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        GridLayout gl = new GridLayout();
        container.setLayout((Layout)gl);
        this.toolkit.paintBordersFor(container);
        this.table = this.viewer.getTable();
        GridData gd = new GridData(1808);
        this.table.setLayoutData((Object)gd);
        this.toolkit.adapt((Composite)this.table);
        this.toolkit.paintBordersFor((Composite)this.table);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(100);
        tableColumn.setText("\u6807\u7b7e\u540d");
        TableColumn tableColumn_1 = new TableColumn(this.table, 0);
        tableColumn_1.setWidth(100);
        tableColumn_1.setText("\u5c5e\u6027\u540d");
        TableColumn tableColumn_2 = new TableColumn(this.table, 0);
        tableColumn_2.setWidth(150);
        tableColumn_2.setText("\u4e2d\u6587");
        TableColumn tableColumn_3 = new TableColumn(this.table, 0);
        tableColumn_3.setWidth(150);
        tableColumn_3.setText("\u82f1\u6587");
        TableColumn tblclmnPromptscode = new TableColumn(this.table, 0);
        tblclmnPromptscode.setWidth(200);
        tblclmnPromptscode.setText("Prompts_Code");
        gd = new GridData(768);
        Composite c = this.toolkit.createComposite(container, 0);
        gl = new GridLayout();
        c.setLayoutData((Object)gd);
        c.setLayout((Layout)gl);
        gl.numColumns = 4;
        this.toolkit.adapt(c);
        Button dbScript = new Button(c, 0);
        dbScript.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<String> promptsCode = new ArrayList<String>();
                if (PromptsView.this.result == null || PromptsView.this.compositeMap == null) {
                    return;
                }
                String result = "";
                List<ViewNode> sNodes = PromptsView.this.getSelectedViewNodes();
                ArrayList<TemplateModel> prompts = new ArrayList<TemplateModel>();
                for (ViewNode n : sNodes) {
                    String code = n.getPromptsCode();
                    if (promptsCode.contains(code)) continue;
                    promptsCode.add(code);
                    HashMap<String, TemplateModel> root = new HashMap<String, TemplateModel>();
                    try {
                        DefaultObjectWrapper dow = new DefaultObjectWrapper();
                        HashMap<String, String> prompt = new HashMap<String, String>();
                        prompt.put("code", code);
                        prompt.put("zhs", n.getZhsPrompt());
                        prompts.add(dow.wrap(prompt));
                        root.put("prompts", dow.wrap(prompts));
                    }
                    catch (TemplateModelException e1) {
                        DialogUtil.logErrorException((Throwable)e1);
                    }
                    try {
                        PromptsRegisterSqlConfigration config = new PromptsRegisterSqlConfigration();
                        Template template = config.getTemplate();
                        FreeMarkerGenerator fg = new FreeMarkerGenerator();
                        result = fg.gen(template, root);
                    }
                    catch (IOException e1) {
                        DialogUtil.logErrorException((Throwable)e1);
                        e1.printStackTrace();
                    }
                    catch (SAXException e1) {
                        DialogUtil.logErrorException((Throwable)e1);
                        e1.printStackTrace();
                    }
                    catch (TemplateException e1) {
                        DialogUtil.logErrorException((Throwable)e1);
                        e1.printStackTrace();
                    }
                }
                try {
                    IDE.openEditor((IWorkbenchPage)PromptsView.this.getSite().getPage(), (IEditorInput)new StringEditorInput(result, "utf-8"), (String)"org.eclipse.ui.DefaultTextEditor");
                }
                catch (PartInitException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.toolkit.adapt((Control)dbScript, true, true);
        dbScript.setText("\u4e2d\u82f1\u6587\u811a\u672c");
        Button newFile = new Button(c, 0);
        this.toolkit.adapt((Control)newFile, true, true);
        newFile.setText("\u65b0\u6587\u4ef6\u5185\u5bb9");
        newFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PromptsView.this.result == null || PromptsView.this.compositeMap == null) {
                    return;
                }
                List<ViewNode> sNodes = PromptsView.this.getSelectedViewNodes();
                for (ViewNode n : sNodes) {
                    n.applyCode();
                }
                try {
                    IDE.openEditor((IWorkbenchPage)PromptsView.this.getSite().getPage(), (IEditorInput)new StringEditorInput(PromptsView.this.compositeMap.toXML(), "utf-8"), (String)"org.eclipse.ui.DefaultTextEditor");
                }
                catch (PartInitException e1) {
                    e1.printStackTrace();
                }
            }
        });
        Button openButton = new Button(c, 0);
        this.toolkit.adapt((Control)openButton, true, true);
        openButton.setText("\u6253\u5f00\u539f\u6587\u4ef6");
        openButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (PromptsView.this.file == null || !PromptsView.this.file.exists()) {
                        return;
                    }
                    IDE.openEditor((IWorkbenchPage)PromptsView.this.getSite().getPage(), (IFile)PromptsView.this.file);
                }
                catch (PartInitException e1) {
                    e1.printStackTrace();
                }
            }
        });
        Button linkFile = new Button(c, 0);
        this.toolkit.adapt((Control)linkFile, true, true);
        linkFile.setText("\u8fde\u63a5\u6587\u4ef6");
        linkFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PromptsView.this.linkFile();
            }
        });
        this.makeActions();
        this.contributeToActionBars();
    }

    protected List<ViewNode> getSelectedViewNodes() {
        ArrayList<ViewNode> nodes = new ArrayList<ViewNode>();
        TableItem[] items = this.table.getItems();
        if (items != null) {
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem i = tableItemArray[n2];
                if (i.getChecked()) {
                    nodes.add((ViewNode)i.getData());
                }
                ++n2;
            }
        }
        return nodes;
    }

    public IFile openResourceSelector(Shell shell, String[] exts) {
        ResourceSelector fss = new ResourceSelector(shell);
        IWorkspaceRoot res = ResourcesPlugin.getWorkspace().getRoot();
        fss.setExtFilter(exts);
        fss.setInput((IContainer)res);
        IResource obj = fss.getSelection();
        if (!(obj instanceof IFile)) {
            return null;
        }
        return (IFile)obj;
    }

    protected void linkFile() {
        String[] as = new String[]{"screen", "bm"};
        this.file = this.openResourceSelector(this.getSite().getShell(), as);
        if (this.file == null) {
            return;
        }
        try {
            this.compositeMap = (CompositeMap)CacheManager.getCompositeMap((IFile)this.file).clone();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (ApplicationException e) {
            e.printStackTrace();
        }
        if (this.compositeMap == null) {
            return;
        }
        this.table.removeAll();
        String promptPrefix = CompositeMapUtil.getValueIgnoreCase((CompositeMap)this.compositeMap, (String)"promptprefix");
        promptPrefix = promptPrefix == null ? "" : promptPrefix;
        PromptsFinder pf = new PromptsFinder(promptPrefix);
        this.compositeMap.iterate((IterationHandle)pf, true);
        this.result = pf.getResult();
        this.viewer.setInput((Object)this.result);
        this.updateCellEditor();
        if (this.selectALL != null) {
            this.selectALL.run();
        }
    }

    private void updateCellEditor() {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.table.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            this.createCHEditor(item);
            this.createCodesEditor(item);
            ++n2;
        }
    }

    private void createCHEditor(TableItem item) {
        final PromptsEditor pe = new PromptsEditor(this.table, item);
        pe.createEditor(2);
        final ViewNode viewNode = (ViewNode)item.getData();
        pe.setText(viewNode.getZhsPrompt());
        pe.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                viewNode.setZhsPrompt(pe.getText());
            }
        });
    }

    private void createCodesEditor(TableItem item) {
        final PromptsEditor pe = new PromptsEditor(this.table, item);
        pe.createEditor(4);
        final ViewNode viewNode = (ViewNode)item.getData();
        pe.setText(viewNode.getPromptsCode());
        pe.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                viewNode.setPromptsCode(pe.getText());
            }
        });
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PromptsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.selectALL);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.deselectAll);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.selectALL);
        manager.add((IAction)this.deselectAll);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.selectALL);
        manager.add((IAction)this.deselectAll);
    }

    private void makeActions() {
        this.selectALL = new Action(){

            public void run() {
                TableItem[] items = PromptsView.this.table.getItems();
                if (items == null) {
                    return;
                }
                TableItem[] tableItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem i = tableItemArray[n2];
                    i.setChecked(true);
                    ++n2;
                }
            }
        };
        this.selectALL.setText("\u5168\u9009");
        this.selectALL.setToolTipText("\u5168\u9009");
        this.selectALL.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.deselectAll = new Action(){

            public void run() {
                TableItem[] items = PromptsView.this.table.getItems();
                if (items == null) {
                    return;
                }
                TableItem[] tableItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem i = tableItemArray[n2];
                    i.setChecked(false);
                    ++n2;
                }
            }
        };
        this.deselectAll.setText("\u53d6\u6d88\u5168\u9009");
        this.deselectAll.setToolTipText("\u53d6\u6d88\u5168\u9009");
        this.deselectAll.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PromptsView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Prompt View", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof ViewNode[]) {
                return (ViewNode[])parent;
            }
            return null;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (!(obj instanceof ViewNode)) {
                return "";
            }
            ViewNode vn = (ViewNode)obj;
            switch (index) {
                case 0: {
                    return vn.getElementRawName();
                }
                case 1: {
                    return vn.getNameAttribute();
                }
                case 2: {
                    return vn.getZhsPrompt();
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return vn.getPromptsCode();
                }
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            if (index != 0) {
                return null;
            }
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

